/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.icon;

import com.miui.theme.tool.gui.TransparentPanel;
import com.miui.theme.tool.gui.main.ModuleRightPanel;
import com.miui.theme.tool.gui.skin.ThemeScrollPane;
import com.miui.theme.tool.icon.IconFilterRightPanel;
import com.miui.theme.tool.icon.IconManager;
import com.miui.theme.tool.icon.IconPageList;
import com.miui.theme.tool.icon.MockLauncher;
import com.miui.theme.tool.icon.PageClickListener;
import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.io.File;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import miui.content.res.IconConfig;
import miui.content.res.IconCustomizer;

public class IconFilterPanel
extends ModuleRightPanel {
    public static final int ICON_PER_PAGE = 20;
    public static final int ICON_PER_LINE = 4;
    private JPanel mIconPanel;
    protected Vector<MockLauncher> mMockLaunchers = new Vector();
    private IconConfig mIconConfig;
    protected Vector<String> mIcons = new Vector();
    private IconFilterRightPanel mIconFilterRightPanel;
    protected int mCurrentPage = 0;
    protected File mCurrentIcon;
    private IconPageList mIconPageList;
    private JScrollPane mIconPageScroll;
    private MockLauncher mCurrentPanel;

    public IconFilterPanel() {
        this.initFilter();
        this.initMockLauncher();
        this.initLayout();
    }

    private void initFilter() {
        this.mIconConfig = IconCustomizer.loadIconConfig();
    }

    private void initLayout() {
        double[][] dArrayArray = new double[][]{{470.0, 1.0, -1.0}, {568.0, -1.0, 200.0}};
        TableLayout tableLayout = new TableLayout(dArrayArray);
        this.setLayout(tableLayout);
        this.initIconPageList();
        this.initIconLeftPanel();
        this.initIconRightPanel();
        this.add((Component)this.mIconPanel, "0, 0");
        this.add((Component)this.getSepPanel(), "1, 0, 1, 2");
        this.mIconPageScroll = new ThemeScrollPane(this.mIconPageList);
        this.mIconPageScroll.getHorizontalScrollBar().setUnitIncrement(20);
        this.mIconPageScroll.getHorizontalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                IconFilterPanel.this.repaint();
            }
        });
        this.mIconPageScroll.setVerticalScrollBarPolicy(21);
        this.add((Component)this.mIconPageScroll, "0, 2");
    }

    protected void initIconPageList() {
        this.mIconPageList = new IconPageList(this.mMockLaunchers);
        this.mIconPageList.setPageClickListener(new PageClickListener(){

            @Override
            public void onClick(int n) {
                IconFilterPanel.this.switchPage(n);
            }
        });
    }

    protected void switchPage(int n) {
        this.mIconPanel.remove(this.mMockLaunchers.get(this.mCurrentPage));
        this.mCurrentPage = n;
        this.mIconPageList.refresh(this.mCurrentPage);
        MockLauncher mockLauncher = this.mMockLaunchers.get(this.mCurrentPage);
        mockLauncher.setIconConfig(this.mIconConfig);
        mockLauncher.refresh();
        this.mCurrentPanel = mockLauncher;
        this.mIconPanel.add((Component)mockLauncher, "3, 3");
        this.mIconPanel.revalidate();
        this.mIconPanel.repaint();
    }

    protected void initIconRightPanel() {
        this.mIconFilterRightPanel = new IconFilterRightPanel(this.mIconConfig, this.mCurrentPanel);
        this.add((Component)this.mIconFilterRightPanel, "2, 0, 2, 2");
    }

    protected void initIconLeftPanel() {
        this.mIconPanel = new TransparentPanel();
        double[][] dArrayArray = new double[][]{{-1.0, 39.0, 20.0, 280.0, 20.0, 39.0, -1.0}, {47.0, 11.0, 10.0, -1.0, 37.0}};
        TableLayout tableLayout = new TableLayout(dArrayArray);
        this.mIconPanel.setLayout(tableLayout);
        if (this.mIcons.size() > 0) {
            this.switchPage(this.mCurrentPage);
        }
    }

    protected void initMockLauncher() {
        this.mIcons = IconManager.getOtherIcons();
        Vector<String> vector = null;
        for (int i = 0; i < this.mIcons.size(); ++i) {
            if (i % 20 == 0) {
                vector = new Vector<String>();
                MockLauncher mockLauncher = new MockLauncher(vector);
                mockLauncher.setIconConfig(this.mIconConfig);
                this.mMockLaunchers.add(mockLauncher);
            }
            vector.add(this.mIcons.get(i));
        }
        new Thread(){

            @Override
            public void run() {
                for (MockLauncher mockLauncher : IconFilterPanel.this.mMockLaunchers) {
                    mockLauncher.refresh();
                    IconFilterPanel.this.mIconPageList.refresh(IconFilterPanel.this.mCurrentPage);
                    IconFilterPanel.this.mIconPanel.revalidate();
                    IconFilterPanel.this.mIconPanel.repaint();
                }
            }
        }.start();
    }

    public static void refreshPreviewPanel(final MockLauncher mockLauncher, final IconConfig iconConfig) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JPanel jPanel = (JPanel)mockLauncher.getParent();
                jPanel.remove(mockLauncher);
                mockLauncher.refresh();
                jPanel.add((Component)mockLauncher, "3, 3");
                jPanel.revalidate();
                jPanel.repaint();
                IconCustomizer.save(iconConfig);
            }
        });
    }
}

