/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.gui.skin;

import com.miui.theme.tool.resource.ResourceFactory;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import sun.swing.SwingUtilities2;

public class ModuleTabbedPaneUI
extends BasicTabbedPaneUI {
    public static final int TAB_WIDTH = 85;
    public static final int TAB_HEIGHT = 69;
    private static BufferedImage mLeftNormal = ResourceFactory.getInstance().getImage("tab/tab_left_n.png");
    private static BufferedImage mLeftPressed = ResourceFactory.getInstance().getImage("tab/tab_left_p.png");
    private static BufferedImage mRightNormal = ResourceFactory.getInstance().getImage("tab/tab_right_n.png");
    private static BufferedImage mRightPressed = ResourceFactory.getInstance().getImage("tab/tab_right_p.png");
    private static BufferedImage mTabDevide = ResourceFactory.getInstance().getImage("tab/tab_devide.png");

    public static ComponentUI createUI(JComponent jComponent) {
        return new ModuleTabbedPaneUI();
    }

    @Override
    protected void installComponents() {
        super.installComponents();
        this.tabPane.setBorder(BorderFactory.createEmptyBorder());
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        int n = this.tabPane.getSelectedIndex();
        int n2 = this.tabPane.getTabPlacement();
        this.paintTabArea(graphics, n2, n);
        graphics.drawImage(mTabDevide, (jComponent.getWidth() - mTabDevide.getWidth()) / 2, 0, null);
    }

    @Override
    protected void paintTab(Graphics graphics, int n, Rectangle[] rectangleArray, int n2, Rectangle rectangle, Rectangle rectangle2) {
        Rectangle rectangle3 = rectangleArray[n2];
        int n3 = this.tabPane.getSelectedIndex();
        boolean bl = n3 == n2;
        this.paintTabBackground(graphics, n, n2, rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height, bl);
        String string = this.tabPane.getTitleAt(n2);
        Font font = this.tabPane.getFont();
        FontMetrics fontMetrics = SwingUtilities2.getFontMetrics(this.tabPane, graphics, font);
        Icon icon = this.getIconForTab(n2);
        this.layoutLabel(n, fontMetrics, n2, string, icon, rectangle3, rectangle, rectangle2, bl);
        if (this.tabPane.getTabComponentAt(n2) == null) {
            String string2 = string;
            this.paintText(graphics, n, font, fontMetrics, n2, string2, rectangle2, bl);
            this.paintIcon(graphics, n, n2, icon, rectangle, bl);
        }
    }

    @Override
    protected void paintTabBackground(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (n2 == 0) {
            if (bl) {
                graphics2D.drawImage((Image)mLeftPressed, n3, n4, null);
            } else {
                graphics2D.drawImage((Image)mLeftNormal, n3, n4, null);
            }
        } else if (bl) {
            graphics2D.drawImage((Image)mRightPressed, n3, n4, null);
        } else {
            graphics2D.drawImage((Image)mRightNormal, n3, n4, null);
        }
    }

    @Override
    protected int calculateTabHeight(int n, int n2, int n3) {
        return super.calculateTabHeight(n, n2, n3);
    }

    @Override
    protected int calculateMaxTabHeight(int n) {
        return 69;
    }

    @Override
    protected int calculateTabWidth(int n, int n2, FontMetrics fontMetrics) {
        return 85;
    }

    @Override
    protected int calculateMaxTabWidth(int n) {
        return super.calculateMaxTabWidth(n);
    }

    @Override
    protected int calculateTabAreaHeight(int n, int n2, int n3) {
        return super.calculateTabAreaHeight(n, n2, n3);
    }

    @Override
    protected int calculateTabAreaWidth(int n, int n2, int n3) {
        return super.calculateTabAreaWidth(n, n2, n3);
    }
}

