/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.gui.outlook;

import com.miui.theme.tool.gui.outlook.OutlookSelectionEvent;
import com.miui.theme.tool.gui.outlook.OutlookTabData;
import java.util.EventListener;
import java.util.List;
import java.util.Vector;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public class OutlookPanelModel {
    public int mTabIndex;
    public int mListIndex;
    protected Vector<OutlookTabData> mData = new Vector();
    protected EventListenerList mChangeListenerList = new EventListenerList();
    protected EventListenerList mOutlookSelectionLiseners = new EventListenerList();

    public void setData(Vector<OutlookTabData> vector) {
        this.mData = vector;
        this.fireStateChanged();
    }

    public Vector<OutlookTabData> getData() {
        return this.mData;
    }

    public void add(OutlookTabData outlookTabData) {
        this.mData.add(outlookTabData);
        this.fireStateChanged();
    }

    public void add(int n, OutlookTabData outlookTabData) {
        this.mData.add(n, outlookTabData);
        this.fireStateChanged();
    }

    public int getSize() {
        return this.mData.size();
    }

    public OutlookTabData get(int n) {
        return this.mData.get(n);
    }

    public String getTabTitle(int n) {
        return this.mData.get((int)n).mTitle.toString();
    }

    public List getTabList(int n) {
        return this.mData.get((int)n).mList;
    }

    public void remove(int n) {
        this.mData.remove(this.mData.get(n));
        this.mData.remove(n);
        this.fireStateChanged();
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.mChangeListenerList.add(ChangeListener.class, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.mChangeListenerList.remove(ChangeListener.class, changeListener);
    }

    protected void fireStateChanged() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        Object[] objectArray = this.mChangeListenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ChangeListener.class) continue;
            ((ChangeListener)objectArray[i + 1]).stateChanged(changeEvent);
        }
    }

    public ChangeListener[] getChangeListeners() {
        return (ChangeListener[])this.mChangeListenerList.getListeners(ChangeListener.class);
    }

    public void addSelectionListener(OutlookSelectionLisener outlookSelectionLisener) {
        this.mOutlookSelectionLiseners.add(OutlookSelectionLisener.class, outlookSelectionLisener);
    }

    public void removeSelectionListener(OutlookSelectionLisener outlookSelectionLisener) {
        this.mOutlookSelectionLiseners.remove(OutlookSelectionLisener.class, outlookSelectionLisener);
    }

    protected void fireSelectionChanged() {
        OutlookSelectionEvent outlookSelectionEvent = new OutlookSelectionEvent(this);
        outlookSelectionEvent.mTabIndex = this.mTabIndex;
        outlookSelectionEvent.mListIndex = this.mListIndex;
        Object[] objectArray = this.mOutlookSelectionLiseners.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != OutlookSelectionLisener.class) continue;
            ((OutlookSelectionLisener)objectArray[i + 1]).valueChanged(outlookSelectionEvent);
        }
    }

    public OutlookSelectionLisener[] getSelectionListeners() {
        return (OutlookSelectionLisener[])this.mOutlookSelectionLiseners.getListeners(OutlookSelectionLisener.class);
    }

    public static interface OutlookSelectionLisener
    extends EventListener {
        public void valueChanged(OutlookSelectionEvent var1);
    }
}

