/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.gui.outlook;

import com.android.ninepatch.NinePatch;
import com.miui.theme.tool.gui.outlook.BasicOutlookPanelUI;
import com.miui.theme.tool.gui.outlook.OutlookListPanel;
import com.miui.theme.tool.gui.outlook.OutlookPanelModel;
import com.miui.theme.tool.gui.outlook.OutlookTabData;
import com.miui.theme.tool.util.GUIUtil;
import com.miui.theme.tool.util.I18nObject;
import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;

public class OutlookPanel
extends JComponent {
    private static final String uiClassID = "OutlookPanelUI";
    protected OutlookPanelModel mModel = new OutlookPanelModel();
    private NinePatch mPatch = GUIUtil.getNinePatch("outlook/main_tree_frame.9.png");
    private Vector<OutlookListPanel> mOutlookListPanels = new Vector();
    private ChangeListener mChangeListener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            OutlookPanel.this.resetComponents();
            OutlookPanel.this.repaint();
        }
    };
    protected boolean mIsUnselecting = false;

    public OutlookPanel() {
        this.updateUI();
        this.mModel.addChangeListener(this.mChangeListener);
    }

    @Override
    public void setUI(ComponentUI componentUI) {
        super.setUI(componentUI);
    }

    @Override
    public void updateUI() {
        if (UIManager.get(this.getUIClassID()) != null) {
            this.setUI(UIManager.getUI(this));
        } else {
            this.setUI(new BasicOutlookPanelUI());
        }
    }

    @Override
    public ComponentUI getUI() {
        return this.ui;
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    public OutlookPanelModel getModel() {
        return this.mModel;
    }

    @Override
    protected void paintChildren(Graphics graphics) {
        super.paintChildren(graphics);
        this.mPatch.draw((Graphics2D)graphics, 0, 0, this.getWidth(), this.getHeight());
    }

    private void resetComponents() {
        int n;
        this.removeAll();
        boolean bl = true;
        double[][] dArrayArray = new double[][]{{1.0, -1.0, 1.0}, new double[0]};
        TableLayout tableLayout = new TableLayout(dArrayArray);
        this.setLayout(tableLayout);
        this.mOutlookListPanels.clear();
        for (n = 0; n < this.mModel.getSize(); ++n) {
            tableLayout.insertRow(n, -2.0);
        }
        for (n = 0; n < this.mModel.getSize(); ++n) {
            OutlookListPanel outlookListPanel = new OutlookListPanel(this.mModel.get(n));
            this.mOutlookListPanels.add(outlookListPanel);
            this.add((Component)outlookListPanel, "1, " + n);
            outlookListPanel.mOutlookPanel = this;
        }
    }

    public synchronized void listSelected(OutlookListPanel outlookListPanel) {
        if (this.mIsUnselecting) {
            return;
        }
        for (int i = 0; i < this.mOutlookListPanels.size(); ++i) {
            if (this.mOutlookListPanels.get(i).equals(outlookListPanel)) {
                this.mModel.mTabIndex = i;
                this.mModel.mListIndex = outlookListPanel.mOutlookPanelList.getSelectedIndex();
                this.mModel.fireSelectionChanged();
                continue;
            }
            this.mIsUnselecting = true;
            this.mOutlookListPanels.get(i).listUnselect();
            this.mIsUnselecting = false;
        }
    }

    public void defaultOpen() {
        if (this.mOutlookListPanels.size() > 0) {
            this.tabSelect(this.mOutlookListPanels.get(0));
            if (this.mOutlookListPanels.get((int)0).mOutlookPanelList.getModel().getSize() > 0) {
                this.mOutlookListPanels.get((int)0).mOutlookPanelList.setSelectedIndex(0);
            }
        }
    }

    public void defaultOpen(String string, String string2) {
        int n = 0;
        int n2 = 0;
        if (string != null && string2 != null) {
            block0: for (int i = 0; i < this.mModel.getData().size(); ++i) {
                OutlookTabData outlookTabData = this.mModel.get(i);
                if (!outlookTabData.mTitle.mKey.equals(string)) continue;
                for (int j = 0; j < outlookTabData.mList.size(); ++j) {
                    if (!((I18nObject)outlookTabData.mList.get((int)j)).mKey.equals(string2)) continue;
                    n = i;
                    n2 = j;
                    continue block0;
                }
            }
            this.tabSelect(this.mOutlookListPanels.get(n));
            System.out.println(n2);
            this.mOutlookListPanels.get((int)n).mOutlookPanelList.setSelectedIndex(n2);
        }
    }

    public void tabSelect(OutlookListPanel outlookListPanel) {
        outlookListPanel.setListVisible(!outlookListPanel.mIsOpened);
        for (int i = 0; i < this.mOutlookListPanels.size(); ++i) {
            if (!this.mOutlookListPanels.get(i).equals(outlookListPanel) || i + 1 > this.mOutlookListPanels.size() - 1) continue;
            this.mOutlookListPanels.get(i + 1).setAfterOpened(outlookListPanel.mIsOpened);
        }
        Container container = this.getParent().getParent();
        container.validate();
        container.repaint();
    }

    public void addSelectionListener(OutlookPanelModel.OutlookSelectionLisener outlookSelectionLisener) {
        this.mModel.addSelectionListener(outlookSelectionLisener);
    }

    public void removeSelectionListener(OutlookPanelModel.OutlookSelectionLisener outlookSelectionLisener) {
        this.mModel.removeSelectionListener(outlookSelectionLisener);
    }
}

