/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.gui.outlook;

import com.android.ninepatch.NinePatch;
import com.miui.theme.tool.gui.skin.ThemeLookAndFeel;
import com.miui.theme.tool.util.GUIUtil;
import info.clearthought.layout.TableLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;

public class OutlookList<E>
extends JList<E> {
    public OutlookList(Vector vector) {
        super(vector);
        this.setCellRenderer(new OutlookCellRenderer());
    }

    class OutlookCellRenderer<E>
    extends JPanel
    implements ListCellRenderer<E> {
        public Color mNormalBackgroundColor = GUIUtil.hex2color("#e6e7e8");
        public NinePatch mSelectedBackgroundPatch = GUIUtil.getNinePatch("outlook/list_pressed.9.png");
        public NinePatch mFirstShadowPatch = GUIUtil.getNinePatch("outlook/first_shadow.9.png");
        public NinePatch mDevidePatch = GUIUtil.getNinePatch("outlook/devide.9.png");
        public NinePatch mLastShadowPatch = GUIUtil.getNinePatch("outlook/last_shadow.9.png");
        public JLabel mLabel = new JLabel();
        public int mIndex;
        public Color mNormalFontColor = GUIUtil.hex2color("#313338");
        public Color mSelectedFontColor = Color.WHITE;
        private boolean mIsSelected;

        public OutlookCellRenderer() {
            Dimension dimension = this.getPreferredSize();
            dimension.height = 50;
            this.setPreferredSize(dimension);
            this.setBackground(this.mNormalBackgroundColor);
            this.mLabel.setFont(ThemeLookAndFeel.getFont(13.0f));
            double[][] dArrayArray = new double[][]{{18.0, -1.0, 15.0}, {-1.0}};
            TableLayout tableLayout = new TableLayout(dArrayArray);
            this.setLayout(tableLayout);
            this.add((Component)this.mLabel, "1, 0");
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends E> jList, E object, int n, boolean bl, boolean bl2) {
            Pattern pattern;
            Matcher matcher;
            this.mIndex = n;
            this.mIsSelected = bl;
            if (-1 != object.toString().indexOf(" ") && (matcher = (pattern = Pattern.compile("(\\d+.\\d+ )(.+)")).matcher(object.toString())).find()) {
                object = matcher.group(2);
            }
            this.setToolTipText(object.toString());
            this.mLabel.setText(object.toString());
            if (bl) {
                this.mLabel.setForeground(this.mSelectedFontColor);
            } else {
                this.mLabel.setForeground(this.mNormalFontColor);
            }
            return this;
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            if (this.mIndex == 0) {
                this.mFirstShadowPatch.draw((Graphics2D)graphics, 0, 0, this.getWidth(), 3);
            } else {
                this.mDevidePatch.draw((Graphics2D)graphics, 0, 0, this.getWidth(), 2);
            }
            if (this.mIndex == OutlookList.this.getModel().getSize() - 1) {
                this.mLastShadowPatch.draw((Graphics2D)graphics, 0, this.getHeight() - 1, this.getWidth(), 2);
            }
            if (this.mIsSelected) {
                this.mSelectedBackgroundPatch.draw((Graphics2D)graphics, 0, 1, this.getWidth(), this.getHeight());
            }
        }
    }
}

