/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.gui.main;

import com.miui.theme.tool.compressor.MtzCompressor;
import com.miui.theme.tool.extract.Extractor;
import com.miui.theme.tool.gui.main.HistoryConfig;
import com.miui.theme.tool.gui.main.NewMainFrame;
import com.miui.theme.tool.gui.main.ThemeInfoData;
import com.miui.theme.tool.ninepatch.NinePatchUtils;
import com.miui.theme.tool.os.CmdUtils;
import com.miui.theme.tool.resource.ResourceFactory;
import com.miui.theme.tool.util.ConfigUtil;
import com.miui.theme.tool.util.GUIUtil;
import com.miui.theme.tool.util.Log;
import com.miui.theme.tool.util.ThemeHelper;
import com.miui.theme.tool.util.ToastPanel;
import java.awt.Component;
import java.awt.Cursor;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;

public class ThemeManager {
    private static volatile ThemeManager single;
    private static ThemeInfoData mThemeInfoData;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ThemeManager getInstance() {
        if (single != null) return single;
        Class<ThemeManager> clazz = ThemeManager.class;
        synchronized (ThemeManager.class) {
            if (single != null) return single;
            single = new ThemeManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return single;
        }
    }

    public static boolean isThemeLoaded() {
        return mThemeInfoData != null;
    }

    public static void selectTheme() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setVisible(true);
        jFileChooser.setCurrentDirectory(new File(ConfigUtil.getThemePath()).getParentFile());
        jFileChooser.setFileSelectionMode(2);
        jFileChooser.addChoosableFileFilter(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isFile() && file.getName().toLowerCase().endsWith(".mtz") || file.isDirectory();
            }

            @Override
            public String getDescription() {
                return "mtz theme file";
            }
        });
        int n = jFileChooser.showOpenDialog(NewMainFrame.getInstance());
        if (n == 0) {
            ThemeManager.openTheme(jFileChooser.getSelectedFile());
        }
    }

    public static void openTheme(File file) {
        Log.l(file.toString() + " opening...");
        if (!file.exists()) {
            GUIUtil.alert(ResourceFactory.getString("FileNotExist"));
        }
        if (file.isFile()) {
            if (ThemeHelper.isMtzFile(file)) {
                try {
                    NewMainFrame newMainFrame = NewMainFrame.getInstance();
                    ((Component)newMainFrame).setCursor(Cursor.getPredefinedCursor(3));
                    String string = file.getParent() + File.separator + file.getName().substring(0, file.getName().length() - 4);
                    new Extractor(file.getAbsolutePath(), string).unzipTheme();
                    NinePatchUtils.decompile(string);
                    ((Component)newMainFrame).setCursor(Cursor.getDefaultCursor());
                    ThemeManager.openTheme(new File(string));
                }
                catch (Exception exception) {
                    GUIUtil.toastLong(ResourceFactory.getString("MtzFileFormatError"));
                }
            }
        } else if (file.isDirectory()) {
            ConfigUtil.setThemePath(file.getAbsolutePath());
            mThemeInfoData = new ThemeInfoData(file);
            HistoryConfig.logHistoryData(file.getAbsolutePath());
            NewMainFrame.getInstance().getMainPanel().afterOpenTheme();
        }
    }

    public ThemeInfoData getThemeInfoData() {
        return mThemeInfoData;
    }

    public void setThemeInfoData(ThemeInfoData themeInfoData) {
        mThemeInfoData = themeInfoData;
    }

    public static void applyToPhone() {
        if (!ThemeManager.isThemeLoaded()) {
            return;
        }
        final ToastPanel toastPanel = GUIUtil.toastEver(ResourceFactory.getString("Optimizing"));
        mThemeInfoData.save();
        new Thread(){

            @Override
            public void run() {
                File file = ThemeHelper.getTmpTheme();
                boolean bl = MtzCompressor.startCompress(ConfigUtil.getThemePath(), file.getAbsolutePath());
                toastPanel.setMessage(ResourceFactory.getString("Applying"));
                if (bl) {
                    bl = CmdUtils.adb_push_MIUIThemeToolGenerated(null, file.getAbsolutePath());
                }
                if (bl) {
                    CmdUtils.adb_shell_applyTheme(null, true, 0L);
                }
                toastPanel.hideToast();
                this.showResult(bl);
            }

            private void showResult(final boolean bl) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        GUIUtil.showResult(bl);
                    }
                });
            }
        }.start();
    }
}

