/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.gui.main;

import com.android.internal.util.FastXmlSerializer;
import com.miui.theme.tool.resource.ResourceFactory;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;

public class ThemeInfoData {
    public String mTitle = ResourceFactory.getString("MyTheme");
    public String mDesigner = ResourceFactory.getString("Default");
    public String mAuthor = ResourceFactory.getString("Default");
    public String mVersion = "1.0";
    public int mUIVersion = 3;
    public File mThemeDescriptionFile;
    public static final String TITLE = "title";
    public static final String DESIGNER = "designer";
    public static final String AUTHOR = "author";
    public static final String VERSION = "version";
    public static final String UIVERSION = "uiVersion";
    public static final String DESCRIPTION_FILE = "description.xml";
    public static final String ROOT_NODE = "MIUI-Theme";
    public static final String NEW_ROOT_NODE = "theme";

    public ThemeInfoData(File file) {
        this.mThemeDescriptionFile = new File(file.getAbsolutePath() + File.separator + DESCRIPTION_FILE);
        this.mTitle = file.getName();
        if (this.mThemeDescriptionFile.exists()) {
            this.parse();
        }
    }

    public void parse() {
        SAXBuilder sAXBuilder = new SAXBuilder();
        try {
            Document document = sAXBuilder.build(this.mThemeDescriptionFile);
            Element element = document.getRootElement();
            if (!element.getName().equals(ROOT_NODE) && !element.getName().equals(NEW_ROOT_NODE)) {
                return;
            }
            for (Element element2 : element.getChildren()) {
                if (element2.getName().equals(TITLE)) {
                    this.mTitle = element2.getText();
                    continue;
                }
                if (element2.getName().equals(DESIGNER)) {
                    this.mDesigner = element2.getText();
                    continue;
                }
                if (element2.getName().equals(AUTHOR)) {
                    this.mAuthor = element2.getText();
                    continue;
                }
                if (element2.getName().equals(VERSION)) {
                    this.mVersion = element2.getText();
                    continue;
                }
                if (!element2.getName().equals(UIVERSION)) continue;
                this.mUIVersion = Integer.parseInt(element2.getText());
            }
        }
        catch (JDOMException jDOMException) {
            jDOMException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void save() {
        FastXmlSerializer fastXmlSerializer = new FastXmlSerializer();
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.mThemeDescriptionFile);
            fastXmlSerializer.setOutput(fileOutputStream, "UTF-8");
            fastXmlSerializer.startDocument(null, true);
            fastXmlSerializer.startTag(null, ROOT_NODE);
            fastXmlSerializer.startTag(null, TITLE);
            fastXmlSerializer.text(this.mTitle);
            fastXmlSerializer.endTag(null, TITLE);
            fastXmlSerializer.startTag(null, DESIGNER);
            fastXmlSerializer.text(this.mDesigner);
            fastXmlSerializer.endTag(null, DESIGNER);
            fastXmlSerializer.startTag(null, AUTHOR);
            fastXmlSerializer.text(this.mAuthor);
            fastXmlSerializer.endTag(null, AUTHOR);
            fastXmlSerializer.startTag(null, VERSION);
            fastXmlSerializer.text(this.mVersion);
            fastXmlSerializer.endTag(null, VERSION);
            fastXmlSerializer.startTag(null, UIVERSION);
            fastXmlSerializer.text("" + this.mUIVersion);
            fastXmlSerializer.endTag(null, UIVERSION);
            fastXmlSerializer.endTag(null, ROOT_NODE);
            fastXmlSerializer.flush();
            fileOutputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

