/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.gui.main;

import chrriis.dj.nativeswing.swtimpl.NativeInterface;
import com.miui.theme.tool.gui.main.MainPanel;
import com.miui.theme.tool.gui.main.MainTabPanel;
import com.miui.theme.tool.gui.main.ThemeManager;
import com.miui.theme.tool.os.OS;
import com.miui.theme.tool.phone.DebugBridge;
import com.miui.theme.tool.resource.ResourceFactory;
import com.miui.theme.tool.util.AutoRun;
import com.miui.theme.tool.util.ConfigUtil;
import com.miui.theme.tool.util.FileDrop;
import com.miui.theme.tool.util.GUIUtil;
import com.miui.theme.tool.util.ShortcutManager;
import com.miui.theme.tool.util.TextUtils;
import com.miui.theme.tool.util.ThemeHelper;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class NewMainFrame
extends JFrame {
    public static final int FRAMEWIDTH = 1263;
    public static final int FRAMEHEIGHT = 812;
    public static final int FRAMEMINWIDTH = 1132;
    public static final int FRAMEMINHEIGHT = 686;
    private MainPanel mMainPanel;
    private final BufferedImage mMainFrameIcon = ResourceFactory.getInstance().getImage("MIUIThemeEditorIcon.png");
    private final MouseAdapter mMoveWindowListener = new MouseAdapter(){
        private Point lastPoint = null;

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.lastPoint = mouseEvent.getLocationOnScreen();
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() > 1) {
                NewMainFrame.getInstance().toggleMaxWindow();
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (NewMainFrame.this.getExtendedState() == 6) {
                return;
            }
            Point point = mouseEvent.getLocationOnScreen();
            int n = point.x - this.lastPoint.x;
            int n2 = point.y - this.lastPoint.y;
            Rectangle rectangle = NewMainFrame.this.getBounds();
            rectangle.x += n;
            rectangle.y += n2;
            NewMainFrame.this.setBounds(rectangle);
            this.lastPoint = point;
        }
    };
    private static volatile NewMainFrame single;
    public static final String FRAME_X = "frameX";
    public static final String FRAME_Y = "frameY";
    public static final String FRAME_WIDTH = "frameWidth";
    public static final String FRAME_HEIGHT = "frameHeight";
    private Rectangle mNormalBounds;
    public FileDrop.Listener mFileDropListener = new FileDrop.Listener(){

        @Override
        public void filesDropped(File[] fileArray) {
            ThemeManager.getInstance();
            ThemeManager.openTheme(fileArray[0]);
        }
    };

    public NewMainFrame() {
        this.init();
        AutoRun.run();
    }

    private void init() {
        this.initLookAndFeel();
        this.setDefaultCloseOperation(3);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                NewMainFrame.this.exit();
            }
        });
        this.setResizable(true);
        this.setUndecorated(true);
        this.initShortcuts();
        if (GUIUtil.supportTransparent()) {
            this.setBackground(GUIUtil.TRANSPARENT);
        }
        this.mMainPanel = new MainPanel();
        this.setContentPane(this.mMainPanel);
        this.initBound();
        this.setIconImage(this.mMainFrameIcon);
        this.initDrag(this.getContentPane());
    }

    private void initBound() {
        int n = 1263 + this.mMainPanel.getLeftPadding() + this.mMainPanel.getRightPadding();
        int n2 = 812 + this.mMainPanel.getTopPadding() + this.mMainPanel.getBottomPadding();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((dimension.width - n) / 2, (dimension.height - n2) / 2, n, n2);
        this.setPreferredSize(new Dimension(n, n2));
        if (!TextUtils.isEmpty(ConfigUtil.get("preference", FRAME_X))) {
            int n3 = Integer.parseInt(ConfigUtil.get("preference", FRAME_WIDTH));
            int n4 = Integer.parseInt(ConfigUtil.get("preference", FRAME_HEIGHT));
            int n5 = Integer.parseInt(ConfigUtil.get("preference", FRAME_X));
            int n6 = Integer.parseInt(ConfigUtil.get("preference", FRAME_Y));
            this.setBounds(n5, n6, n3, n4);
        }
    }

    private void initShortcuts() {
        ShortcutManager shortcutManager = ShortcutManager.getInstance();
        shortcutManager.addShortcutListener(new ShortcutManager.ShortcutListener(){

            @Override
            public void handle() {
                ThemeHelper.setInnerUserMode();
                GUIUtil.alert("Hello MIUI :)");
                NewMainFrame.this.exit();
            }
        }, 17, 18, 69);
        shortcutManager.addShortcutListener(new ShortcutManager.ShortcutListener(){

            @Override
            public void handle() {
                ThemeHelper.setReviewMode(!ThemeHelper.isReviewMode());
                GUIUtil.alert("Hello MIUI Reviewers :)");
                NewMainFrame.this.exit();
            }
        }, 17, 18, 82);
        shortcutManager.addShortcutListener(new ShortcutManager.ShortcutListener(){

            @Override
            public void handle() {
                ThemeHelper.convertXxhdpi2Xhdpi();
            }
        }, 18, 80);
    }

    public Rectangle getMinBounds() {
        Rectangle rectangle = super.getBounds();
        rectangle.x += this.mMainPanel.getLeftPadding();
        rectangle.y += this.mMainPanel.getTopPadding();
        rectangle.width -= this.mMainPanel.getLeftPadding() + this.mMainPanel.getRightPadding();
        rectangle.height -= this.mMainPanel.getTopPadding() + this.mMainPanel.getBottomPadding();
        return rectangle;
    }

    private void initLookAndFeel() {
        try {
            if (OS.getOS() == 1) {
                UIManager.setLookAndFeel("com.miui.theme.tool.gui.skin.WindowThemeLookAndFeel");
            } else {
                UIManager.setLookAndFeel("com.miui.theme.tool.gui.skin.OtherThemeLookAndFeel");
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
            unsupportedLookAndFeelException.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        if (ThemeHelper.isReviewMode()) {
            NativeInterface.open();
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DebugBridge.init();
                NewMainFrame.getInstance().setVisible(true);
            }
        });
        if (ThemeHelper.isReviewMode()) {
            NativeInterface.runEventPump();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static NewMainFrame getInstance() {
        if (single != null) return single;
        Class<NewMainFrame> clazz = NewMainFrame.class;
        synchronized (NewMainFrame.class) {
            if (single != null) return single;
            single = new NewMainFrame();
            // ** MonitorExit[var0] (shouldn't be in output)
            return single;
        }
    }

    public void bindMoveWindowListener(JComponent jComponent) {
        jComponent.addMouseListener(this.mMoveWindowListener);
        jComponent.addMouseMotionListener(this.mMoveWindowListener);
    }

    public void exit() {
        Rectangle rectangle = this.getBounds();
        if (this.getExtendedState() == 6) {
            rectangle = this.mNormalBounds;
            ConfigUtil.put("preference", "CloseMaxState", Boolean.TRUE.toString());
        } else {
            ConfigUtil.put("preference", "CloseMaxState", Boolean.FALSE.toString());
        }
        ConfigUtil.put("preference", FRAME_X, "" + rectangle.x);
        ConfigUtil.put("preference", FRAME_Y, "" + rectangle.y);
        ConfigUtil.put("preference", FRAME_WIDTH, "" + rectangle.width);
        ConfigUtil.put("preference", FRAME_HEIGHT, "" + rectangle.height);
        ConfigUtil.save();
        System.exit(0);
    }

    @Override
    public void setExtendedState(int n) {
        if ((n & 6) == 6) {
            Rectangle rectangle = this.getGraphicsConfiguration().getBounds();
            Rectangle rectangle2 = null;
            if (rectangle.x == 0 && rectangle.y == 0) {
                Insets insets = this.getToolkit().getScreenInsets(this.getGraphicsConfiguration());
                rectangle2 = new Rectangle(insets.left - this.mMainPanel.getLeftPadding(), insets.top - this.mMainPanel.getTopPadding(), rectangle.width - insets.right - insets.left + this.mMainPanel.getLeftPadding() + this.mMainPanel.getRightPadding(), rectangle.height - insets.bottom - insets.top + this.mMainPanel.getTopPadding() + this.mMainPanel.getBottomPadding());
            } else {
                rectangle2 = null;
            }
            super.setMaximizedBounds(rectangle2);
        }
        super.setExtendedState(n);
    }

    public boolean toggleMaxWindow() {
        if (this.getExtendedState() == 6) {
            this.mMainPanel.setResizeEnable(true);
            this.mMainPanel.setFullBackground(false);
            super.setExtendedState(0);
            return true;
        }
        this.mNormalBounds = this.getBounds();
        this.mMainPanel.setResizeEnable(false);
        this.mMainPanel.setFullBackground(true);
        this.setExtendedState(6);
        return false;
    }

    public void minWindow() {
        super.setExtendedState(1 | this.getExtendedState());
    }

    private void initDrag(Component component) {
        new FileDrop(null, component, null, true, this.mFileDropListener);
    }

    public BufferedImage getMainFrameIcon() {
        return this.mMainFrameIcon;
    }

    public MainPanel getMainPanel() {
        return this.mMainPanel;
    }

    public MainTabPanel getMainTabPanel() {
        return this.mMainPanel.mMainTabPanel;
    }

    static {
        System.setProperty("sun.java2d.noddraw", "true");
        System.setProperty("sun.java2d.d3d", "false");
        System.setProperty("awt.useSystemAAFontSettings", "lcd");
    }
}

