/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.gui.main;

import com.android.ninepatch.NinePatch;
import com.miui.theme.tool.gui.NinePBackgroundPanel;
import com.miui.theme.tool.gui.TransparentPanel;
import com.miui.theme.tool.gui.main.HistoryConfig;
import com.miui.theme.tool.gui.main.HistoryData;
import com.miui.theme.tool.gui.main.NewMainFrame;
import com.miui.theme.tool.gui.main.NewThemeDialog;
import com.miui.theme.tool.gui.main.ThemeManager;
import com.miui.theme.tool.resource.ResourceFactory;
import com.miui.theme.tool.util.DialogPopupFactory;
import com.miui.theme.tool.util.GUIUtil;
import com.miui.theme.tool.util.ThemeHelper;
import info.clearthought.layout.TableLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class MainFirstPage
extends NinePBackgroundPanel {
    ImageIcon mNewNormal = ResourceFactory.getInstance().getImageIcon("firstpage/new_n.png");
    ImageIcon mNewPressed = ResourceFactory.getInstance().getImageIcon("firstpage/new_p.png");
    JButton mNewButton = GUIUtil.createTransparentButton(this.mNewNormal, this.mNewPressed, this.mNewPressed, null);
    ImageIcon mOpenNormal = ResourceFactory.getInstance().getImageIcon("firstpage/open_n.png");
    ImageIcon mOpenPressed = ResourceFactory.getInstance().getImageIcon("firstpage/open_p.png");
    JButton mOpenButton = GUIUtil.createTransparentButton(this.mOpenNormal, this.mOpenPressed, this.mOpenPressed, null);
    ImageIcon mArrowNormal = ResourceFactory.getInstance().getImageIcon("firstpage/arrow_n.png");
    ImageIcon mArrowPressed = ResourceFactory.getInstance().getImageIcon("firstpage/arrow_p.png");
    JButton mArrowButton = GUIUtil.createTransparentButton(this.mArrowNormal, this.mArrowPressed, this.mArrowPressed, null);
    ImageIcon mSlogan = ResourceFactory.getInstance().getImageIcon(ResourceFactory.getString("FirstPageSlogan"));
    JLabel mSloganLabel = new JLabel(this.mSlogan);
    public static final float FONT_SIZE = 16.0f;
    public static Color mBackgroundColor = GUIUtil.COMMON_RIGHT_BACKGROUND_COLOR;
    MouseAdapter mFirstPageListener = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            ThemeManager.selectTheme();
        }
    };
    private JPanel mNewPanel;
    private JPanel mOpenPanel;
    private JLabel mHintLabel;
    protected HistoryPanel mHistoryPanel;

    public MainFirstPage() {
        GUIUtil.moveable(this);
        this.setNinePBackground("firstpage/right_bg.9.png");
        this.initNewPanel();
        this.initOpenPanel();
        this.initHint();
        double[][] dArrayArray = new double[][]{{-1.0, 95.0, 100.0, 95.0, -1.0}, {165.0, -1.0, 123.0, 130.0, -1.0, 20.0, 110.0}};
        TableLayout tableLayout = new TableLayout(dArrayArray);
        this.setLayout(tableLayout);
        this.add((Component)this.mSloganLabel, "0, 1, 4, 1");
        this.add((Component)this.mNewPanel, "1, 3");
        this.add((Component)this.mOpenPanel, "3, 3");
        this.add((Component)this.mHintLabel, "0, 5, 4, 5");
    }

    public void initHint() {
        this.mHintLabel = new JLabel(ResourceFactory.getString("FirstPageHint"));
        this.mHintLabel.setHorizontalAlignment(0);
        this.mHintLabel.setFont(this.mHintLabel.getFont().deriveFont(14.0f));
        this.mHintLabel.setCursor(Cursor.getPredefinedCursor(12));
        this.mHintLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                ThemeHelper.browse("http://zhuti.xiaomi.com");
            }
        });
        this.mArrowButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (MainFirstPage.this.mHistoryPanel == null || !MainFirstPage.this.mHistoryPanel.isVisible()) {
                    MainFirstPage.this.mHistoryPanel = new HistoryPanel();
                    MainFirstPage.this.mHistoryPanel.showHistory();
                } else {
                    MainFirstPage.this.mHistoryPanel.hideHistory();
                    MainFirstPage.this.mHistoryPanel = null;
                }
            }
        });
    }

    private void initNewPanel() {
        this.mNewPanel = new JPanel();
        this.mNewPanel.setBackground(mBackgroundColor);
        double[][] dArrayArray = new double[][]{{-1.0}, {95.0, 20.0, -1.0}};
        TableLayout tableLayout = new TableLayout(dArrayArray);
        this.mNewPanel.setLayout(tableLayout);
        JLabel jLabel = new JLabel(ResourceFactory.getString("New"));
        jLabel.setHorizontalAlignment(0);
        jLabel.setFont(jLabel.getFont().deriveFont(16.0f));
        this.mNewPanel.add((Component)this.mNewButton, "0, 0");
        this.mNewButton.setCursor(Cursor.getPredefinedCursor(12));
        this.mNewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new NewThemeDialog().setVisible(true);
            }
        });
        this.mNewPanel.add((Component)jLabel, "0, 2");
    }

    private void initOpenPanel() {
        this.mOpenPanel = new JPanel();
        this.mOpenPanel.setBackground(mBackgroundColor);
        double[][] dArrayArray = new double[][]{{-1.0, 7.0, 17.0, 14.0}, {95.0, 18.0, -1.0}};
        TableLayout tableLayout = new TableLayout(dArrayArray);
        this.mOpenPanel.setLayout(tableLayout);
        JLabel jLabel = new JLabel(ResourceFactory.getString("Open"));
        jLabel.setHorizontalAlignment(4);
        jLabel.setFont(jLabel.getFont().deriveFont(16.0f));
        this.mOpenPanel.add((Component)this.mOpenButton, "0, 0, 3, 0");
        this.mOpenButton.setCursor(Cursor.getPredefinedCursor(12));
        this.mOpenPanel.add((Component)jLabel, "0, 2");
        this.mOpenButton.addMouseListener(this.mFirstPageListener);
        this.mOpenPanel.add((Component)this.mArrowButton, "2, 2");
    }

    class HistoryCellRenderer
    implements ListCellRenderer {
        public Color mSelected = GUIUtil.BASE_BLUE;

        HistoryCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            JPanel jPanel = new JPanel();
            jPanel.setBackground(GUIUtil.TRANSPARENT);
            double[][] dArrayArray = new double[][]{{6.0, -1.0, 6.0}, {20.0}};
            TableLayout tableLayout = new TableLayout(dArrayArray);
            jPanel.setLayout(tableLayout);
            HistoryData historyData = (HistoryData)object;
            File file = new File(historyData.mPath);
            JLabel jLabel = new JLabel(file.getName());
            jLabel.setOpaque(true);
            if (bl) {
                jLabel.setBackground(this.mSelected);
            } else {
                jLabel.setBackground(GUIUtil.TRANSPARENT);
            }
            jPanel.add((Component)jLabel, "1, 0");
            return jPanel;
        }
    }

    class HistoryList
    extends JList {
        public NinePatch mPatch;

        public HistoryList(Vector vector) {
            super(vector);
            this.mPatch = GUIUtil.getNinePatch("firstpage/recent_list_bg.9.png");
            this.setCellRenderer(new HistoryCellRenderer());
            this.setBackground(GUIUtil.TRANSPARENT);
            this.setBorder(BorderFactory.createLineBorder(GUIUtil.TRANSPARENT, 5));
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            this.mPatch.draw((Graphics2D)graphics, 0, 0, this.getWidth(), this.getHeight());
            super.paintComponent(graphics);
        }
    }

    class HistoryPanel
    extends TransparentPanel {
        public static final int WIDTH = 230;
        public static final int HEIGHT = 230;
        private JDialog mPopup;
        private HistoryList mHistoryList;

        public HistoryPanel() {
            this.initPanel();
        }

        public void hideHistory() {
            this.mPopup.setVisible(false);
        }

        private void initPanel() {
            double[][] dArrayArray = new double[][]{{230.0}, {230.0}};
            TableLayout tableLayout = new TableLayout(dArrayArray);
            this.setLayout(tableLayout);
            this.initHistoryList();
            this.add((Component)this.mHistoryList, "0, 0");
        }

        private void initHistoryList() {
            Vector<HistoryData> vector = HistoryConfig.getHistoryData();
            this.mHistoryList = new HistoryList(vector);
            this.mHistoryList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (listSelectionEvent.getValueIsAdjusting()) {
                        return;
                    }
                    HistoryData historyData = (HistoryData)HistoryPanel.this.mHistoryList.getSelectedValue();
                    ThemeManager.openTheme(new File(historyData.mPath));
                    MainFirstPage.this.mHistoryPanel = null;
                    HistoryPanel.this.mPopup.setVisible(false);
                }
            });
        }

        public void showHistory() {
            Vector<HistoryData> vector = HistoryConfig.getHistoryData();
            Point point = new Point(0, 0);
            SwingUtilities.convertPointToScreen(point, MainFirstPage.this.mArrowButton);
            point.x = point.x - 115 + MainFirstPage.this.mArrowNormal.getIconWidth() / 2;
            point.y += MainFirstPage.this.mArrowNormal.getIconHeight();
            this.mPopup = DialogPopupFactory.getPopup(NewMainFrame.getInstance(), this, new Rectangle(point.x, point.y, 230, 230));
            this.mPopup.setVisible(true);
        }
    }
}

