/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.gui.main;

import com.miui.theme.tool.gui.main.HistoryData;
import com.miui.theme.tool.util.ThemeHelper;
import dnl.confij.ConfigException;
import dnl.confij.ConfigParam;
import dnl.confij.ConfigSection;
import dnl.confij.ini.IniConfiguration;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Vector;

public class HistoryConfig {
    public static final String CONFIG_FOLDER = "config";
    public static final String COMMON_FILE = "history.ini";
    public static final String SECTION_HISTORY = "history";

    private static IniConfiguration getConfiguration() {
        try {
            File file = new File(ThemeHelper.getUserDir() + File.separator + CONFIG_FOLDER + File.separator + COMMON_FILE);
            if (!file.exists()) {
                file.getParentFile().mkdirs();
                file.createNewFile();
            }
            return new IniConfiguration(file);
        }
        catch (ConfigException configException) {
            configException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return null;
    }

    public static Vector<HistoryData> getHistoryData() {
        IniConfiguration iniConfiguration = HistoryConfig.getConfiguration();
        ConfigSection configSection = iniConfiguration.getOrCreateSection(SECTION_HISTORY);
        Vector<HistoryData> vector = new Vector<HistoryData>();
        if (configSection == null) {
            return vector;
        }
        for (ConfigParam configParam : configSection.getConfigParameters()) {
            HistoryData historyData = new HistoryData();
            historyData.mPath = configParam.getName();
            historyData.mOpenDate = Long.parseLong(configParam.getValue());
            vector.add(historyData);
        }
        Collections.sort(vector);
        return vector;
    }

    public static void logHistoryData(String string) {
        IniConfiguration iniConfiguration = HistoryConfig.getConfiguration();
        ConfigSection configSection = iniConfiguration.getOrCreateSection(SECTION_HISTORY);
        if (configSection == null) {
            return;
        }
        configSection.setParamValue(string, "" + System.currentTimeMillis());
        try {
            iniConfiguration.saveConfiguration();
        }
        catch (ConfigException configException) {
            configException.printStackTrace();
        }
    }
}

