/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.extract;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;

public class Extractor {
    private final int zipSuffix = 4;
    private String mSrcFilePath;
    private String mDestDir;
    private final String[] SUFFIXES = new String[]{".png", ".jpg", ".mp3", ".ogg", ".mp3", ".jpeg", ".bmp", ".ivt", "maml"};
    public final int TYPE_THEME = 1;
    public final int TYPE_APK = 2;

    public Extractor(String string) {
        this.mSrcFilePath = string;
    }

    public Extractor(String string, String string2) {
        this.mSrcFilePath = string;
        this.mDestDir = string2;
    }

    public void unzipTheme() {
        String string = this.extract(this.mSrcFilePath, this.TYPE_THEME);
        if (string == null) {
            return;
        }
        File file = new File(string);
        if (!file.exists() || file.isFile()) {
            return;
        }
        this.mDestDir = null;
        this.renameToZip(file);
        this.extractInner(file);
    }

    public boolean isResFile(java.util.zip.ZipEntry zipEntry) {
        String string = zipEntry.getName().toLowerCase();
        if (zipEntry.isDirectory() && (string.endsWith("res") || string.endsWith("raw") || string.indexOf("drawable") != -1)) {
            return true;
        }
        for (int i = 0; i < this.SUFFIXES.length; ++i) {
            if (!string.endsWith(this.SUFFIXES[i])) continue;
            return true;
        }
        return false;
    }

    public void unzipApkRes() {
        if (this.mDestDir == null || this.mSrcFilePath == null) {
            return;
        }
        if (!new File(this.mSrcFilePath).exists()) {
            return;
        }
        this.extractAPK(this.mSrcFilePath, 2);
    }

    private boolean suffixNotUnzipable(String string) {
        return !string.toLowerCase().endsWith(".zip") && !string.toLowerCase().endsWith(".mtz") && !string.toLowerCase().endsWith(".apk") && !string.toLowerCase().endsWith(".maml");
    }

    private String extract(String string, int n) {
        if (this.suffixNotUnzipable(string)) {
            return null;
        }
        ZipFile zipFile = null;
        try {
            Object object;
            zipFile = new ZipFile(string);
            File file = null;
            String string2 = "";
            if (n == 2) {
                file = new File(this.mDestDir);
            } else {
                object = this.mDestDir;
                if (object == null || "".equals(object)) {
                    object = string.substring(0, string.length() - 4);
                }
                file = new File((String)object);
            }
            file.mkdir();
            string2 = file.getAbsolutePath();
            string2 = string2 + File.separator;
            object = zipFile.getEntries();
            while (object.hasMoreElements()) {
                File file2;
                ZipEntry zipEntry = (ZipEntry)object.nextElement();
                if (n == 2 && !this.isResFile((java.util.zip.ZipEntry)zipEntry)) continue;
                if (zipEntry.isDirectory()) {
                    file2 = new File(string2 + zipEntry.getName()).getParentFile();
                    if (file2 != null && !file2.exists()) {
                        file2.mkdirs();
                    }
                    new File(string2 + zipEntry.getName()).mkdirs();
                    continue;
                }
                file2 = new File(string2 + zipEntry.getName());
                File file3 = file2.getParentFile();
                if (file3 != null && !file3.exists()) {
                    file3.mkdirs();
                }
                FileOutputStream fileOutputStream = new FileOutputStream(file2);
                IOUtils.copy((InputStream)zipFile.getInputStream(zipEntry), (OutputStream)fileOutputStream);
                fileOutputStream.close();
            }
            zipFile.close();
            return string2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private String extractAPK(String string, int n) {
        if (this.suffixNotUnzipable(string)) {
            return null;
        }
        java.util.zip.ZipFile zipFile = null;
        try {
            Object object;
            zipFile = new java.util.zip.ZipFile(string);
            File file = null;
            String string2 = "";
            if (n == this.TYPE_APK) {
                file = new File(this.mDestDir);
            } else {
                object = this.mDestDir;
                if (object == null || "".equals(object)) {
                    object = string.substring(0, string.length() - 4);
                }
                file = new File((String)object);
            }
            file.mkdir();
            string2 = file.getAbsolutePath();
            string2 = string2 + File.separator;
            object = zipFile.entries();
            while (object.hasMoreElements()) {
                File file2;
                java.util.zip.ZipEntry zipEntry = (java.util.zip.ZipEntry)object.nextElement();
                if (n == this.TYPE_APK && !this.isResFile(zipEntry)) continue;
                if (zipEntry.isDirectory()) {
                    file2 = new File(string2 + zipEntry.getName()).getParentFile();
                    if (file2 != null && !file2.exists()) {
                        file2.mkdirs();
                    }
                    new File(string2 + zipEntry.getName()).mkdirs();
                    continue;
                }
                file2 = new File(string2 + zipEntry.getName());
                File file3 = file2.getParentFile();
                if (file3 != null && !file3.exists()) {
                    file3.mkdirs();
                }
                FileOutputStream fileOutputStream = new FileOutputStream(file2);
                IOUtils.copy((InputStream)zipFile.getInputStream(zipEntry), (OutputStream)fileOutputStream);
                fileOutputStream.close();
            }
            zipFile.close();
            return string2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private void renameToZip(File file) {
        for (File file2 : file.listFiles()) {
            if (file2.isDirectory() || file2.getName().toLowerCase().endsWith(".xml") || file2.getName().toLowerCase().endsWith(".zip")) continue;
            File file3 = new File(file2.getAbsolutePath() + ".zip");
            file2.renameTo(file3);
            System.out.println(file2.getAbsolutePath() + ".zip");
            try {
                new ZipFile(file3).close();
            }
            catch (Exception exception) {
                file3.renameTo(file2);
            }
        }
    }

    private void extractInner(File file) {
        File[] fileArray;
        for (File file2 : fileArray = file.listFiles()) {
            if (file2.isDirectory() && file2.getName().equals("boots")) {
                File[] fileArray2;
                for (File file3 : fileArray2 = file2.listFiles()) {
                    if (file3.getName().equals("bootanimation.zip")) {
                        this.extract(file3.getAbsolutePath(), this.TYPE_THEME);
                    }
                    file3.delete();
                }
            }
            if (!file2.getName().endsWith(".zip")) continue;
            this.extract(file2.getAbsolutePath(), this.TYPE_THEME);
            file2.delete();
        }
    }
}

