/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.catalog;

import com.android.internal.util.FastXmlSerializer;
import com.miui.theme.tool.catalog.CatalogManager;
import com.miui.theme.tool.catalog.MIUIThemeValues;
import com.miui.theme.tool.catalog.Member;
import com.miui.theme.tool.gui.main.NewMainFrame;
import com.miui.theme.tool.util.ConfigUtil;
import com.miui.theme.tool.util.ThemeHelper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JFileChooser;

public class StringsManager {
    public static final String STRING_FILE = "strings.xml";
    public static final String RESOURCES = "resources";
    public static final String STRING_TAG = "string";
    public static final String STRING_NAME = "name";

    public static void exportStrings() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setVisible(true);
        jFileChooser.setFileSelectionMode(1);
        int n = jFileChooser.showOpenDialog(NewMainFrame.getInstance());
        if (n != 0) {
            return;
        }
        File file = jFileChooser.getSelectedFile();
        String string = ConfigUtil.getThemePath();
        String[] stringArray = new File(string).list();
        HashMap<String, Member> hashMap = null;
        try {
            hashMap = CatalogManager.getHashMapApps();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        for (String string2 : stringArray) {
            boolean bl;
            if (hashMap.containsKey(string2) && (bl = StringsManager.exportOneString(string + File.separator + string2 + File.separator + "theme_values.xml", file.getAbsolutePath() + File.separator + string2 + File.separator + STRING_FILE))) continue;
        }
        ThemeHelper.open(file);
    }

    private static boolean exportOneString(String string, String string2) {
        File file = new File(string);
        File file2 = new File(string2);
        if (!file.exists()) {
            return false;
        }
        Vector<Vector<String>> vector = MIUIThemeValues.getThemeValuesFromFile(file);
        FastXmlSerializer fastXmlSerializer = new FastXmlSerializer();
        try {
            file2.getParentFile().mkdirs();
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            fastXmlSerializer.setOutput(fileOutputStream, "UTF-8");
            fastXmlSerializer.startDocument(null, true);
            fastXmlSerializer.startTag(null, RESOURCES);
            fastXmlSerializer.attribute(null, "xmlns:android", "http://schemas.android.com/apk/res/android");
            fastXmlSerializer.attribute(null, "xmlns:xliff", "urn:oasis:names:tc:xliff:document:1.2");
            for (Vector<String> vector2 : vector) {
                if (!vector2.get(0).equals(STRING_TAG) || !vector2.get(3).equals("")) continue;
                fastXmlSerializer.startTag(null, STRING_TAG);
                fastXmlSerializer.attribute(null, STRING_NAME, vector2.get(1));
                fastXmlSerializer.text(vector2.get(2));
                fastXmlSerializer.endTag(null, STRING_TAG);
            }
            fastXmlSerializer.endTag(null, RESOURCES);
            fastXmlSerializer.flush();
            fileOutputStream.close();
            return true;
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return false;
    }
}

