/*
 * Decompiled with CFR 0.152.
 */
package chrriis.dj.nativeswing.swtimpl.components;

import chrriis.dj.nativeswing.NSOption;
import chrriis.dj.nativeswing.swtimpl.components.JWebBrowser;
import chrriis.dj.nativeswing.swtimpl.components.JWebBrowserWindow;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserAdapter;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserDecorator;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserEvent;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserNavigationEvent;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserWindowFactory;
import chrriis.dj.nativeswing.swtimpl.components.internal.INativeWebBrowser;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class DefaultWebBrowserDecorator
extends WebBrowserDecorator {
    private final ResourceBundle RESOURCES;
    private boolean isViewMenuVisible;
    private static final Border STATUS_BAR_BORDER = new AbstractBorder(){

        @Override
        public Insets getBorderInsets(Component component) {
            return new Insets(1, 1, 1, 1);
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            Color color = component.getBackground();
            graphics.setColor(color == null ? Color.LIGHT_GRAY : color.darker());
            graphics.drawLine(0, 0, n3 - 1, 0);
            graphics.drawLine(n3 - 1, 0, n3 - 1, n4 - 1);
            graphics.drawLine(0, n4 - 1, n3 - 1, n4 - 1);
            graphics.drawLine(0, 0, 0, n4 - 1);
        }
    };
    private WebBrowserMenuBar menuBar;
    private WebBrowserButtonBar buttonBar;
    private WebBrowserLocationBar locationBar;
    private WebBrowserStatusBar statusBar;
    private JWebBrowser webBrowser;
    private INativeWebBrowser nativeWebBrowser;
    private JPanel menuToolAndLocationBarPanel;
    private JPanel nativeWebBrowserBorderContainerPane;

    private void updateNavigationButtons() {
        if (!this.nativeWebBrowser.isNativePeerDisposed() && (this.isViewMenuVisible || this.isButtonBarVisible())) {
            boolean bl;
            boolean bl2;
            boolean bl3 = bl2 = this.nativeWebBrowser.isNativePeerInitialized() ? this.nativeWebBrowser.isBackNavigationEnabled() : false;
            if (this.buttonBar != null) {
                this.buttonBar.getBackButton().setEnabled(bl2);
            }
            this.menuBar.backMenuItem.setEnabled(bl2);
            boolean bl4 = bl = this.nativeWebBrowser.isNativePeerInitialized() ? this.nativeWebBrowser.isForwardNavigationEnabled() : false;
            if (this.buttonBar != null) {
                this.buttonBar.getForwardButton().setEnabled(bl);
            }
            this.menuBar.forwardMenuItem.setEnabled(bl);
        }
    }

    protected void addButtonBarComponents(WebBrowserButtonBar webBrowserButtonBar) {
        webBrowserButtonBar.add(webBrowserButtonBar.getBackButton());
        webBrowserButtonBar.add(webBrowserButtonBar.getForwardButton());
        webBrowserButtonBar.add(webBrowserButtonBar.getReloadButton());
        webBrowserButtonBar.add(webBrowserButtonBar.getStopButton());
    }

    protected void addLocationBarComponents(WebBrowserLocationBar webBrowserLocationBar) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 2));
        jPanel.setOpaque(false);
        jPanel.add((Component)webBrowserLocationBar.getLocationField(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        webBrowserLocationBar.add(jPanel);
        webBrowserLocationBar.add(webBrowserLocationBar.getGoButton());
    }

    protected void addMenuBarComponents(WebBrowserMenuBar webBrowserMenuBar) {
        webBrowserMenuBar.add(webBrowserMenuBar.getFileMenu());
        webBrowserMenuBar.add(webBrowserMenuBar.getViewMenu());
    }

    public DefaultWebBrowserDecorator(JWebBrowser jWebBrowser, Component component) {
        String string = JWebBrowser.class.getName();
        this.RESOURCES = ResourceBundle.getBundle(string.substring(0, string.lastIndexOf(46)).replace('.', '/') + "/resource/WebBrowser");
        this.webBrowser = jWebBrowser;
        this.nativeWebBrowser = (INativeWebBrowser)((Object)jWebBrowser.getNativeComponent());
        this.menuToolAndLocationBarPanel = new JPanel(new BorderLayout());
        this.menuBar = new WebBrowserMenuBar();
        this.menuToolAndLocationBarPanel.add((Component)this.menuBar, "North");
        this.add((Component)this.menuToolAndLocationBarPanel, "North");
        this.nativeWebBrowserBorderContainerPane = new JPanel(new BorderLayout());
        this.nativeWebBrowserBorderContainerPane.add(component, "Center");
        this.add((Component)this.nativeWebBrowserBorderContainerPane, "Center");
        this.nativeWebBrowser.addWebBrowserListener(new NWebBrowserListener());
        this.adjustBorder();
        this.setButtonBarVisible(true);
        this.setLocationBarVisible(true);
        this.setStatusBarVisible(true);
    }

    protected JWebBrowser getWebBrowser() {
        return this.webBrowser;
    }

    private void adjustBorder() {
        this.nativeWebBrowserBorderContainerPane.setBorder(this.getInnerAreaBorder());
    }

    protected Border getInnerAreaBorder() {
        Border border = this.isMenuBarVisible() || this.isButtonBarVisible() || this.isLocationBarVisible() || this.isStatusBarVisible() ? BorderFactory.createBevelBorder(1) : null;
        return border;
    }

    @Override
    public void setStatusBarVisible(boolean bl) {
        if (bl == this.isStatusBarVisible()) {
            return;
        }
        if (bl) {
            this.statusBar = new WebBrowserStatusBar();
            this.webBrowser.add((Component)this.statusBar, "South");
        } else {
            this.webBrowser.remove(this.statusBar);
            this.statusBar = null;
        }
        this.webBrowser.revalidate();
        this.webBrowser.repaint();
        this.menuBar.statusBarCheckBoxMenuItem.setSelected(bl);
        this.adjustBorder();
    }

    @Override
    public boolean isStatusBarVisible() {
        return this.statusBar != null;
    }

    @Override
    public void setMenuBarVisible(boolean bl) {
        if (bl == this.isMenuBarVisible()) {
            return;
        }
        this.menuBar.setVisible(bl);
        this.adjustBorder();
    }

    @Override
    public boolean isMenuBarVisible() {
        return this.menuBar.isVisible();
    }

    @Override
    public void setButtonBarVisible(boolean bl) {
        if (bl == this.isButtonBarVisible()) {
            return;
        }
        if (bl) {
            this.buttonBar = new WebBrowserButtonBar();
            this.menuToolAndLocationBarPanel.add((Component)this.buttonBar, "West");
        } else {
            this.menuToolAndLocationBarPanel.remove(this.buttonBar);
            this.buttonBar = null;
        }
        this.menuToolAndLocationBarPanel.revalidate();
        this.menuToolAndLocationBarPanel.repaint();
        this.menuBar.buttonBarCheckBoxMenuItem.setSelected(bl);
        this.adjustBorder();
        if (bl && !this.isViewMenuVisible) {
            this.updateNavigationButtons();
        }
    }

    @Override
    public boolean isButtonBarVisible() {
        return this.buttonBar != null;
    }

    @Override
    public void setLocationBarVisible(boolean bl) {
        if (bl == this.isLocationBarVisible()) {
            return;
        }
        if (bl) {
            this.locationBar = new WebBrowserLocationBar();
            this.menuToolAndLocationBarPanel.add((Component)this.locationBar, "Center");
        } else {
            this.menuToolAndLocationBarPanel.remove(this.locationBar);
            this.locationBar = null;
        }
        this.menuToolAndLocationBarPanel.revalidate();
        this.menuToolAndLocationBarPanel.repaint();
        this.menuBar.locationBarCheckBoxMenuItem.setSelected(bl);
        this.adjustBorder();
    }

    @Override
    public boolean isLocationBarVisible() {
        return this.locationBar != null;
    }

    @Override
    public void configureForWebBrowserWindow(final JWebBrowserWindow jWebBrowserWindow) {
        JMenu jMenu = this.menuBar.fileMenu;
        jMenu.addSeparator();
        JMenuItem jMenuItem = new JMenuItem();
        this.configureComponent(jMenuItem, WebBrowserDecoratorComponentType.FILE_CLOSE_MENU_ITEM);
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jWebBrowserWindow.dispose();
            }
        });
        jMenu.add(jMenuItem);
        this.webBrowser.addWebBrowserListener(new WebBrowserAdapter(){

            @Override
            public void titleChanged(WebBrowserEvent webBrowserEvent) {
                DefaultWebBrowserDecorator.this.setWebBrowserWindowTitle(jWebBrowserWindow, webBrowserEvent.getWebBrowser().getPageTitle());
            }
        });
        this.setWebBrowserWindowIcon(jWebBrowserWindow);
    }

    protected void setWebBrowserWindowTitle(JWebBrowserWindow jWebBrowserWindow, String string) {
        jWebBrowserWindow.setTitle(new MessageFormat(this.RESOURCES.getString("BrowserTitle")).format(new Object[]{string}));
    }

    protected void setWebBrowserWindowIcon(JWebBrowserWindow jWebBrowserWindow) {
        String string = this.RESOURCES.getString("BrowserIcon");
        if (string.length() > 0) {
            jWebBrowserWindow.setIconImage(new ImageIcon(JWebBrowserWindow.class.getResource(string)).getImage());
        }
    }

    protected String askLocation() {
        return JOptionPane.showInputDialog(this.webBrowser, this.RESOURCES.getString("FileOpenLocationDialogMessage"), this.RESOURCES.getString("FileOpenLocationDialogTitle"), 3);
    }

    protected void configureComponent(JComponent jComponent, WebBrowserDecoratorComponentType webBrowserDecoratorComponentType) {
        switch (webBrowserDecoratorComponentType) {
            case FILE_MENU: {
                ((AbstractButton)jComponent).setText(this.RESOURCES.getString("FileMenu"));
                return;
            }
            case FILE_NEW_WINDOW_MENU_ITEM: {
                ((AbstractButton)jComponent).setText(this.RESOURCES.getString("FileNewWindowMenu"));
                return;
            }
            case FILE_OPEN_LOCATION_MENU_ITEM: {
                ((AbstractButton)jComponent).setText(this.RESOURCES.getString("FileOpenLocationMenu"));
                return;
            }
            case FILE_OPEN_FILE_MENU_ITEM: {
                ((AbstractButton)jComponent).setText(this.RESOURCES.getString("FileOpenFileMenu"));
                return;
            }
            case FILE_CLOSE_MENU_ITEM: {
                ((AbstractButton)jComponent).setText(this.RESOURCES.getString("FileCloseMenu"));
                return;
            }
            case VIEW_MENU: {
                ((AbstractButton)jComponent).setText(this.RESOURCES.getString("ViewMenu"));
                return;
            }
            case VIEW_TOOLBARS_MENU: {
                ((AbstractButton)jComponent).setText(this.RESOURCES.getString("ViewToolbarsMenu"));
                return;
            }
            case VIEW_TOOLBARS_BUTTON_BAR_CHECKBOX_MENU_ITEM: {
                ((AbstractButton)jComponent).setText(this.RESOURCES.getString("ViewToolbarsButtonBarMenu"));
                return;
            }
            case VIEW_TOOLBARS_LOCATION_BAR_CHECKBOX_MENU_ITEM: {
                ((AbstractButton)jComponent).setText(this.RESOURCES.getString("ViewToolbarsLocationBarMenu"));
                return;
            }
            case VIEW_STATUS_BAR_CHECKBOX_MENU_ITEM: {
                ((AbstractButton)jComponent).setText(this.RESOURCES.getString("ViewStatusBarMenu"));
                return;
            }
            case VIEW_BACK_MENU_ITEM: {
                ((AbstractButton)jComponent).setText(this.RESOURCES.getString("ViewMenuBack"));
                ((AbstractButton)jComponent).setIcon(this.createIcon("ViewMenuBackIcon"));
                return;
            }
            case VIEW_FORWARD_MENU_ITEM: {
                ((AbstractButton)jComponent).setText(this.RESOURCES.getString("ViewMenuForward"));
                ((AbstractButton)jComponent).setIcon(this.createIcon("ViewMenuForwardIcon"));
                return;
            }
            case VIEW_RELOAD_MENU_ITEM: {
                ((AbstractButton)jComponent).setText(this.RESOURCES.getString("ViewMenuReload"));
                ((AbstractButton)jComponent).setIcon(this.createIcon("ViewMenuReloadIcon"));
                return;
            }
            case VIEW_STOP_MENU_ITEM: {
                ((AbstractButton)jComponent).setText(this.RESOURCES.getString("ViewMenuStop"));
                ((AbstractButton)jComponent).setIcon(this.createIcon("ViewMenuStopIcon"));
                return;
            }
            case BACK_BUTTON: {
                ((AbstractButton)jComponent).setIcon(this.createIcon("BackIcon"));
                ((AbstractButton)jComponent).setToolTipText(this.RESOURCES.getString("BackText"));
                return;
            }
            case FORWARD_BUTTON: {
                ((AbstractButton)jComponent).setIcon(this.createIcon("ForwardIcon"));
                ((AbstractButton)jComponent).setToolTipText(this.RESOURCES.getString("ForwardText"));
                return;
            }
            case RELOAD_BUTTON: {
                ((AbstractButton)jComponent).setIcon(this.createIcon("ReloadIcon"));
                ((AbstractButton)jComponent).setToolTipText(this.RESOURCES.getString("ReloadText"));
                return;
            }
            case STOP_BUTTON: {
                ((AbstractButton)jComponent).setIcon(this.createIcon("StopIcon"));
                ((AbstractButton)jComponent).setToolTipText(this.RESOURCES.getString("StopText"));
                return;
            }
            case GO_BUTTON: {
                ((AbstractButton)jComponent).setIcon(this.createIcon("GoIcon"));
                ((AbstractButton)jComponent).setToolTipText(this.RESOURCES.getString("GoText"));
                return;
            }
            case STATUS_LABEL: {
                return;
            }
        }
        throw new IllegalStateException("Type not handled: " + (Object)((Object)webBrowserDecoratorComponentType));
    }

    private Icon createIcon(String string) {
        String string2 = this.RESOURCES.getString(string);
        return string2.length() == 0 ? null : new ImageIcon(JWebBrowser.class.getResource(string2));
    }

    private class WebBrowserStatusBar
    extends JPanel {
        private JLabel statusLabel;
        private JProgressBar progressBar;

        public WebBrowserStatusBar() {
            super(new BorderLayout());
            this.setBorder(BorderFactory.createCompoundBorder(STATUS_BAR_BORDER, BorderFactory.createEmptyBorder(2, 2, 2, 2)));
            this.statusLabel = new JLabel();
            DefaultWebBrowserDecorator.this.configureComponent(this.statusLabel, WebBrowserDecoratorComponentType.STATUS_LABEL);
            this.updateStatus();
            this.add((Component)this.statusLabel, "Center");
            this.progressBar = new JProgressBar(){

                @Override
                public Dimension getPreferredSize() {
                    return new Dimension(this.getParent().getWidth() / 10, 0);
                }
            };
            this.updateProgressValue();
            this.add((Component)this.progressBar, "East");
        }

        public void updateProgressValue() {
            int n = DefaultWebBrowserDecorator.this.nativeWebBrowser.isNativePeerInitialized() ? DefaultWebBrowserDecorator.this.nativeWebBrowser.getLoadingProgress() : 100;
            this.progressBar.setValue(n);
            this.progressBar.setVisible(n < 100);
        }

        public void updateStatus() {
            String string = DefaultWebBrowserDecorator.this.nativeWebBrowser.isNativePeerInitialized() ? DefaultWebBrowserDecorator.this.nativeWebBrowser.getStatusText() : "";
            this.statusLabel.setText(string.length() == 0 ? " " : string);
        }
    }

    public class WebBrowserLocationBar
    extends JToolBar {
        private JTextField locationField;
        private JButton goButton;

        WebBrowserLocationBar() {
            this.setLayout(new BoxLayout(this, 2));
            this.setFloatable(false);
            this.locationField = new JTextField();
            this.locationField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 27) {
                        WebBrowserLocationBar.this.updateLocation();
                        WebBrowserLocationBar.this.locationField.selectAll();
                    }
                }
            });
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DefaultWebBrowserDecorator.this.webBrowser.navigate(WebBrowserLocationBar.this.locationField.getText());
                    DefaultWebBrowserDecorator.this.nativeWebBrowser.requestFocus();
                }
            };
            this.locationField.addActionListener(actionListener);
            this.updateLocation();
            this.goButton = new JButton();
            DefaultWebBrowserDecorator.this.configureComponent(this.goButton, WebBrowserDecoratorComponentType.GO_BUTTON);
            this.goButton.addActionListener(actionListener);
            DefaultWebBrowserDecorator.this.addLocationBarComponents(this);
        }

        public JTextField getLocationField() {
            return this.locationField;
        }

        public JButton getGoButton() {
            return this.goButton;
        }

        void updateLocation(String string) {
            this.locationField.setText(string);
        }

        void updateLocation() {
            this.locationField.setText(DefaultWebBrowserDecorator.this.nativeWebBrowser.isNativePeerInitialized() && !DefaultWebBrowserDecorator.this.nativeWebBrowser.isNativePeerDisposed() ? DefaultWebBrowserDecorator.this.nativeWebBrowser.getResourceLocation() : "");
        }
    }

    public class WebBrowserButtonBar
    extends JToolBar {
        private JButton backButton;
        private JButton forwardButton;
        private JButton reloadButton;
        private JButton stopButton;

        WebBrowserButtonBar() {
            this.setFloatable(false);
            this.backButton = new JButton();
            DefaultWebBrowserDecorator.this.configureComponent(this.backButton, WebBrowserDecoratorComponentType.BACK_BUTTON);
            this.backButton.setEnabled(DefaultWebBrowserDecorator.this.menuBar.backMenuItem.isEnabled());
            this.backButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DefaultWebBrowserDecorator.this.webBrowser.navigateBack();
                    DefaultWebBrowserDecorator.this.nativeWebBrowser.requestFocus();
                }
            });
            this.forwardButton = new JButton();
            DefaultWebBrowserDecorator.this.configureComponent(this.forwardButton, WebBrowserDecoratorComponentType.FORWARD_BUTTON);
            this.forwardButton.setEnabled(DefaultWebBrowserDecorator.this.menuBar.forwardMenuItem.isEnabled());
            this.forwardButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DefaultWebBrowserDecorator.this.webBrowser.navigateForward();
                    DefaultWebBrowserDecorator.this.nativeWebBrowser.requestFocus();
                }
            });
            this.reloadButton = new JButton();
            DefaultWebBrowserDecorator.this.configureComponent(this.reloadButton, WebBrowserDecoratorComponentType.RELOAD_BUTTON);
            this.reloadButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DefaultWebBrowserDecorator.this.webBrowser.reloadPage();
                    DefaultWebBrowserDecorator.this.nativeWebBrowser.requestFocus();
                }
            });
            this.stopButton = new JButton();
            DefaultWebBrowserDecorator.this.configureComponent(this.stopButton, WebBrowserDecoratorComponentType.STOP_BUTTON);
            this.stopButton.setEnabled(DefaultWebBrowserDecorator.this.menuBar.stopMenuItem.isEnabled());
            this.stopButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DefaultWebBrowserDecorator.this.webBrowser.stopLoading();
                }
            });
            DefaultWebBrowserDecorator.this.addButtonBarComponents(this);
            this.add(Box.createHorizontalStrut(2));
        }

        public JButton getBackButton() {
            return this.backButton;
        }

        public JButton getForwardButton() {
            return this.forwardButton;
        }

        public JButton getReloadButton() {
            return this.reloadButton;
        }

        public JButton getStopButton() {
            return this.stopButton;
        }
    }

    public class WebBrowserMenuBar
    extends JMenuBar {
        private JMenu fileMenu = new JMenu();
        private JMenu viewMenu;
        private JCheckBoxMenuItem buttonBarCheckBoxMenuItem;
        private JCheckBoxMenuItem locationBarCheckBoxMenuItem;
        private JCheckBoxMenuItem statusBarCheckBoxMenuItem;
        private JMenuItem backMenuItem;
        private JMenuItem forwardMenuItem;
        private JMenuItem reloadMenuItem;
        private JMenuItem stopMenuItem;

        WebBrowserMenuBar() {
            DefaultWebBrowserDecorator.this.configureComponent(this.fileMenu, WebBrowserDecoratorComponentType.FILE_MENU);
            JMenuItem jMenuItem = new JMenuItem();
            DefaultWebBrowserDecorator.this.configureComponent(jMenuItem, WebBrowserDecoratorComponentType.FILE_NEW_WINDOW_MENU_ITEM);
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    JWebBrowser jWebBrowser;
                    switch (((INativeWebBrowser)((Object)DefaultWebBrowserDecorator.this.webBrowser.getNativeComponent())).getRuntime()) {
                        case WEBKIT: {
                            jWebBrowser = new JWebBrowser(JWebBrowser.useWebkitRuntime());
                            break;
                        }
                        case XULRUNNER: {
                            jWebBrowser = new JWebBrowser(JWebBrowser.useXULRunnerRuntime());
                            break;
                        }
                        default: {
                            jWebBrowser = new JWebBrowser(new NSOption[0]);
                        }
                    }
                    JWebBrowser.copyAppearance(DefaultWebBrowserDecorator.this.webBrowser, jWebBrowser);
                    JWebBrowser.copyContent(DefaultWebBrowserDecorator.this.webBrowser, jWebBrowser);
                    JWebBrowserWindow jWebBrowserWindow = WebBrowserWindowFactory.create(jWebBrowser);
                    jWebBrowserWindow.setVisible(true);
                }
            });
            this.fileMenu.add(jMenuItem);
            JMenuItem jMenuItem2 = new JMenuItem();
            DefaultWebBrowserDecorator.this.configureComponent(jMenuItem2, WebBrowserDecoratorComponentType.FILE_OPEN_LOCATION_MENU_ITEM);
            jMenuItem2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    String string = DefaultWebBrowserDecorator.this.askLocation();
                    if (string != null) {
                        DefaultWebBrowserDecorator.this.webBrowser.navigate(string);
                    }
                }
            });
            this.fileMenu.add(jMenuItem2);
            JMenuItem jMenuItem3 = new JMenuItem();
            DefaultWebBrowserDecorator.this.configureComponent(jMenuItem3, WebBrowserDecoratorComponentType.FILE_OPEN_FILE_MENU_ITEM);
            jMenuItem3.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    JFileChooser jFileChooser = new JFileChooser();
                    if (jFileChooser.showOpenDialog(DefaultWebBrowserDecorator.this.webBrowser) == 0) {
                        try {
                            DefaultWebBrowserDecorator.this.webBrowser.navigate(jFileChooser.getSelectedFile().getAbsolutePath());
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                }
            });
            this.fileMenu.add(jMenuItem3);
            this.viewMenu = new JMenu();
            DefaultWebBrowserDecorator.this.configureComponent(this.viewMenu, WebBrowserDecoratorComponentType.VIEW_MENU);
            JMenu jMenu = new JMenu();
            DefaultWebBrowserDecorator.this.configureComponent(jMenu, WebBrowserDecoratorComponentType.VIEW_TOOLBARS_MENU);
            this.buttonBarCheckBoxMenuItem = new JCheckBoxMenuItem();
            DefaultWebBrowserDecorator.this.configureComponent(this.buttonBarCheckBoxMenuItem, WebBrowserDecoratorComponentType.VIEW_TOOLBARS_BUTTON_BAR_CHECKBOX_MENU_ITEM);
            this.buttonBarCheckBoxMenuItem.setSelected(DefaultWebBrowserDecorator.this.isButtonBarVisible());
            this.buttonBarCheckBoxMenuItem.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    DefaultWebBrowserDecorator.this.setButtonBarVisible(itemEvent.getStateChange() == 1);
                }
            });
            jMenu.add(this.buttonBarCheckBoxMenuItem);
            this.locationBarCheckBoxMenuItem = new JCheckBoxMenuItem();
            DefaultWebBrowserDecorator.this.configureComponent(this.locationBarCheckBoxMenuItem, WebBrowserDecoratorComponentType.VIEW_TOOLBARS_LOCATION_BAR_CHECKBOX_MENU_ITEM);
            this.locationBarCheckBoxMenuItem.setSelected(DefaultWebBrowserDecorator.this.isLocationBarVisible());
            this.locationBarCheckBoxMenuItem.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    DefaultWebBrowserDecorator.this.setLocationBarVisible(itemEvent.getStateChange() == 1);
                }
            });
            jMenu.add(this.locationBarCheckBoxMenuItem);
            this.viewMenu.add(jMenu);
            this.statusBarCheckBoxMenuItem = new JCheckBoxMenuItem();
            DefaultWebBrowserDecorator.this.configureComponent(this.statusBarCheckBoxMenuItem, WebBrowserDecoratorComponentType.VIEW_STATUS_BAR_CHECKBOX_MENU_ITEM);
            this.statusBarCheckBoxMenuItem.setSelected(DefaultWebBrowserDecorator.this.isStatusBarVisible());
            this.statusBarCheckBoxMenuItem.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    DefaultWebBrowserDecorator.this.setStatusBarVisible(itemEvent.getStateChange() == 1);
                }
            });
            this.viewMenu.add(this.statusBarCheckBoxMenuItem);
            this.viewMenu.addSeparator();
            this.backMenuItem = new JMenuItem();
            DefaultWebBrowserDecorator.this.configureComponent(this.backMenuItem, WebBrowserDecoratorComponentType.VIEW_BACK_MENU_ITEM);
            this.backMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DefaultWebBrowserDecorator.this.webBrowser.navigateBack();
                    DefaultWebBrowserDecorator.this.nativeWebBrowser.requestFocus();
                }
            });
            this.backMenuItem.setEnabled(false);
            this.viewMenu.add(this.backMenuItem);
            this.forwardMenuItem = new JMenuItem();
            DefaultWebBrowserDecorator.this.configureComponent(this.forwardMenuItem, WebBrowserDecoratorComponentType.VIEW_FORWARD_MENU_ITEM);
            this.forwardMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DefaultWebBrowserDecorator.this.webBrowser.navigateForward();
                    DefaultWebBrowserDecorator.this.nativeWebBrowser.requestFocus();
                }
            });
            this.forwardMenuItem.setEnabled(false);
            this.viewMenu.add(this.forwardMenuItem);
            this.reloadMenuItem = new JMenuItem();
            DefaultWebBrowserDecorator.this.configureComponent(this.reloadMenuItem, WebBrowserDecoratorComponentType.VIEW_RELOAD_MENU_ITEM);
            this.reloadMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DefaultWebBrowserDecorator.this.webBrowser.reloadPage();
                    DefaultWebBrowserDecorator.this.nativeWebBrowser.requestFocus();
                }
            });
            this.viewMenu.add(this.reloadMenuItem);
            this.stopMenuItem = new JMenuItem();
            DefaultWebBrowserDecorator.this.configureComponent(this.stopMenuItem, WebBrowserDecoratorComponentType.VIEW_STOP_MENU_ITEM);
            this.stopMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DefaultWebBrowserDecorator.this.webBrowser.stopLoading();
                }
            });
            this.stopMenuItem.setEnabled(false);
            this.viewMenu.add(this.stopMenuItem);
            this.viewMenu.getPopupMenu().addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                    DefaultWebBrowserDecorator.this.isViewMenuVisible = false;
                }

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                    DefaultWebBrowserDecorator.this.isViewMenuVisible = true;
                    if (!DefaultWebBrowserDecorator.this.isButtonBarVisible()) {
                        DefaultWebBrowserDecorator.this.updateNavigationButtons();
                    }
                }
            });
            DefaultWebBrowserDecorator.this.addMenuBarComponents(this);
        }

        public JMenu getFileMenu() {
            return this.fileMenu;
        }

        public JMenu getViewMenu() {
            return this.viewMenu;
        }
    }

    private static class NWebBrowserListener
    extends WebBrowserAdapter {
        private NWebBrowserListener() {
        }

        @Override
        public void locationChanged(WebBrowserNavigationEvent webBrowserNavigationEvent) {
            JWebBrowser jWebBrowser = webBrowserNavigationEvent.getWebBrowser();
            this.updateStopButton(jWebBrowser, false);
            DefaultWebBrowserDecorator defaultWebBrowserDecorator = (DefaultWebBrowserDecorator)jWebBrowser.getWebBrowserDecorator();
            if (webBrowserNavigationEvent.isTopFrame() && defaultWebBrowserDecorator.locationBar != null) {
                defaultWebBrowserDecorator.locationBar.updateLocation();
            }
            defaultWebBrowserDecorator.updateNavigationButtons();
        }

        @Override
        public void locationChanging(WebBrowserNavigationEvent webBrowserNavigationEvent) {
            JWebBrowser jWebBrowser = webBrowserNavigationEvent.getWebBrowser();
            DefaultWebBrowserDecorator defaultWebBrowserDecorator = (DefaultWebBrowserDecorator)jWebBrowser.getWebBrowserDecorator();
            if (webBrowserNavigationEvent.isTopFrame() && defaultWebBrowserDecorator.locationBar != null) {
                defaultWebBrowserDecorator.locationBar.updateLocation(webBrowserNavigationEvent.getNewResourceLocation());
            }
            this.updateStopButton(jWebBrowser, true);
        }

        @Override
        public void locationChangeCanceled(WebBrowserNavigationEvent webBrowserNavigationEvent) {
            JWebBrowser jWebBrowser = webBrowserNavigationEvent.getWebBrowser();
            this.updateStopButton(jWebBrowser, false);
            DefaultWebBrowserDecorator defaultWebBrowserDecorator = (DefaultWebBrowserDecorator)jWebBrowser.getWebBrowserDecorator();
            if (webBrowserNavigationEvent.isTopFrame() && defaultWebBrowserDecorator.locationBar != null) {
                defaultWebBrowserDecorator.locationBar.updateLocation();
            }
            defaultWebBrowserDecorator.updateNavigationButtons();
        }

        @Override
        public void statusChanged(WebBrowserEvent webBrowserEvent) {
            JWebBrowser jWebBrowser = webBrowserEvent.getWebBrowser();
            DefaultWebBrowserDecorator defaultWebBrowserDecorator = (DefaultWebBrowserDecorator)jWebBrowser.getWebBrowserDecorator();
            if (defaultWebBrowserDecorator.statusBar != null) {
                defaultWebBrowserDecorator.statusBar.updateStatus();
            }
        }

        @Override
        public void loadingProgressChanged(WebBrowserEvent webBrowserEvent) {
            JWebBrowser jWebBrowser = webBrowserEvent.getWebBrowser();
            DefaultWebBrowserDecorator defaultWebBrowserDecorator = (DefaultWebBrowserDecorator)jWebBrowser.getWebBrowserDecorator();
            if (defaultWebBrowserDecorator.statusBar != null) {
                defaultWebBrowserDecorator.statusBar.updateProgressValue();
            }
            this.updateStopButton(jWebBrowser, false);
        }

        private void updateStopButton(JWebBrowser jWebBrowser, boolean bl) {
            boolean bl2 = bl || jWebBrowser.getLoadingProgress() != 100;
            DefaultWebBrowserDecorator defaultWebBrowserDecorator = (DefaultWebBrowserDecorator)jWebBrowser.getWebBrowserDecorator();
            if (defaultWebBrowserDecorator.buttonBar != null) {
                defaultWebBrowserDecorator.buttonBar.getStopButton().setEnabled(bl2);
            }
            defaultWebBrowserDecorator.menuBar.stopMenuItem.setEnabled(bl2);
        }
    }

    public static enum WebBrowserDecoratorComponentType {
        FILE_MENU,
        FILE_NEW_WINDOW_MENU_ITEM,
        FILE_OPEN_LOCATION_MENU_ITEM,
        FILE_OPEN_FILE_MENU_ITEM,
        FILE_CLOSE_MENU_ITEM,
        VIEW_MENU,
        VIEW_TOOLBARS_MENU,
        VIEW_TOOLBARS_BUTTON_BAR_CHECKBOX_MENU_ITEM,
        VIEW_TOOLBARS_LOCATION_BAR_CHECKBOX_MENU_ITEM,
        VIEW_STATUS_BAR_CHECKBOX_MENU_ITEM,
        VIEW_BACK_MENU_ITEM,
        VIEW_FORWARD_MENU_ITEM,
        VIEW_RELOAD_MENU_ITEM,
        VIEW_STOP_MENU_ITEM,
        BACK_BUTTON,
        FORWARD_BUTTON,
        RELOAD_BUTTON,
        STOP_BUTTON,
        GO_BUTTON,
        STATUS_LABEL;

    }
}

