/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils;

import com.alee.graphics.filters.ShadowFilter;
import com.alee.laf.StyleConstants;
import com.alee.utils.LafUtils;
import com.alee.utils.ninepatch.NinePatchIcon;
import com.alee.utils.ninepatch.NinePatchInterval;
import com.alee.utils.ninepatch.NinePatchIntervalType;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class NinePatchUtils {
    private static Map<String, NinePatchIcon> shadeIconCache = new HashMap<String, NinePatchIcon>();

    public static NinePatchIcon getShadeIcon(int n, int n2, float f) {
        String string = n + ";" + n2 + ";" + f;
        if (shadeIconCache.containsKey(string)) {
            return shadeIconCache.get(string);
        }
        NinePatchIcon ninePatchIcon = NinePatchUtils.createShadeIcon(n, n2, f);
        shadeIconCache.put(string, ninePatchIcon);
        return ninePatchIcon;
    }

    public static NinePatchIcon createShadeIcon(int n, int n2, float f) {
        int n3 = Math.max(n, n2);
        int n4 = n * 2 + n3 * 2;
        BufferedImage bufferedImage = new BufferedImage(n4, n4, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        LafUtils.setupAntialias(graphics2D);
        graphics2D.setPaint(Color.BLACK);
        graphics2D.fillRoundRect(n, n, n4 - n * 2, n4 - n * 2, n2 * 2, n2 * 2);
        graphics2D.dispose();
        ShadowFilter shadowFilter = new ShadowFilter(n, 0, 0, f);
        BufferedImage bufferedImage2 = shadowFilter.filter(bufferedImage, null);
        Graphics2D graphics2D2 = bufferedImage2.createGraphics();
        LafUtils.setupAntialias(graphics2D2);
        graphics2D2.setComposite(AlphaComposite.getInstance(5));
        graphics2D2.setPaint(StyleConstants.transparent);
        graphics2D2.fillRoundRect(n, n, n4 - n * 2, n4 - n * 2, n2 * 2, n2 * 2);
        graphics2D2.dispose();
        NinePatchIcon ninePatchIcon = NinePatchIcon.create(bufferedImage2);
        ninePatchIcon.addHorizontalStretch(new NinePatchInterval(0, n + n3, true));
        ninePatchIcon.addHorizontalStretch(new NinePatchInterval(n + n3 + 1, n4 - n - n3 - 1, false));
        ninePatchIcon.addHorizontalStretch(new NinePatchInterval(n4 - n - n3, n4, true));
        ninePatchIcon.addVerticalStretch(new NinePatchInterval(0, n + n3, true));
        ninePatchIcon.addVerticalStretch(new NinePatchInterval(n + n3 + 1, n4 - n - n3 - 1, false));
        ninePatchIcon.addVerticalStretch(new NinePatchInterval(n4 - n - n3, n4, true));
        return ninePatchIcon;
    }

    public static List<NinePatchInterval> copy(List<NinePatchInterval> list) {
        ArrayList<NinePatchInterval> arrayList = new ArrayList<NinePatchInterval>();
        for (NinePatchInterval ninePatchInterval : list) {
            arrayList.add(ninePatchInterval.clone());
        }
        return arrayList;
    }

    public static List<NinePatchInterval> parseIntervals(BufferedImage bufferedImage, NinePatchIntervalType ninePatchIntervalType) {
        boolean bl = ninePatchIntervalType.equals((Object)NinePatchIntervalType.horizontalStretch) || ninePatchIntervalType.equals((Object)NinePatchIntervalType.verticalStretch);
        int n = (ninePatchIntervalType.equals((Object)NinePatchIntervalType.horizontalStretch) || ninePatchIntervalType.equals((Object)NinePatchIntervalType.horizontalContent) ? bufferedImage.getWidth() : bufferedImage.getHeight()) - 1;
        ArrayList<NinePatchInterval> arrayList = new ArrayList<NinePatchInterval>();
        NinePatchInterval ninePatchInterval = null;
        for (int i = 1; i < n; ++i) {
            boolean bl2;
            int n2;
            switch (ninePatchIntervalType) {
                case horizontalStretch: {
                    n2 = bufferedImage.getRGB(i, 0);
                    break;
                }
                case verticalStretch: {
                    n2 = bufferedImage.getRGB(0, i);
                    break;
                }
                case horizontalContent: {
                    n2 = bufferedImage.getRGB(i, bufferedImage.getHeight() - 1);
                    break;
                }
                case verticalContent: {
                    n2 = bufferedImage.getRGB(bufferedImage.getWidth() - 1, i);
                    break;
                }
                default: {
                    n2 = 0;
                }
            }
            boolean bl3 = bl2 = n2 != Color.BLACK.getRGB();
            if (ninePatchInterval == null) {
                ninePatchInterval = new NinePatchInterval(i - 1, i - 1, bl2);
                continue;
            }
            if (bl2 == ninePatchInterval.isPixel()) {
                ninePatchInterval.setEnd(i - 1);
                continue;
            }
            if (bl2 == ninePatchInterval.isPixel()) continue;
            if (bl || !ninePatchInterval.isPixel()) {
                arrayList.add(ninePatchInterval);
            }
            ninePatchInterval = new NinePatchInterval(i - 1, i - 1, bl2);
        }
        if (ninePatchInterval != null && (bl || !ninePatchInterval.isPixel())) {
            arrayList.add(ninePatchInterval);
        }
        return arrayList;
    }

    public static List<NinePatchInterval> parseStretchIntervals(boolean[] blArray) {
        ArrayList<NinePatchInterval> arrayList = new ArrayList<NinePatchInterval>();
        NinePatchInterval ninePatchInterval = null;
        for (int i = 0; i < blArray.length; ++i) {
            boolean bl;
            boolean bl2 = bl = !blArray[i];
            if (ninePatchInterval == null) {
                ninePatchInterval = new NinePatchInterval(i, i, bl);
                continue;
            }
            if (bl == ninePatchInterval.isPixel()) {
                ninePatchInterval.setEnd(i);
                continue;
            }
            if (bl == ninePatchInterval.isPixel()) continue;
            arrayList.add(ninePatchInterval);
            ninePatchInterval = new NinePatchInterval(i, i, bl);
        }
        if (ninePatchInterval != null) {
            arrayList.add(ninePatchInterval);
        }
        return arrayList;
    }
}

