/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils;

import com.alee.utils.ReflectUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class CollectionUtils {
    public static <T> boolean addAll(Collection<T> collection, T ... TArray) {
        boolean bl = false;
        for (T t : TArray) {
            bl |= collection.add(t);
        }
        return bl;
    }

    public static <T> List<T> copy(Collection<T> collection) {
        ArrayList<T> arrayList = new ArrayList<T>(collection.size());
        arrayList.addAll(collection);
        return arrayList;
    }

    public static <T extends Cloneable> List<T> clone(Collection<T> collection) {
        ArrayList<Cloneable> arrayList = new ArrayList<Cloneable>(collection.size());
        for (Cloneable cloneable : collection) {
            arrayList.add((Cloneable)ReflectUtils.callMethodSafely(cloneable, "clone", new Object[0]));
        }
        return arrayList;
    }

    public static <T> List<T> copy(T ... TArray) {
        ArrayList arrayList = new ArrayList(TArray.length);
        Collections.addAll(arrayList, TArray);
        return arrayList;
    }

    public static <T> List<T> removeNulls(List<T> list) {
        if (list != null) {
            for (int i = list.size() - 1; i >= 0; --i) {
                if (list.get(i) != null) continue;
                list.remove(i);
            }
        }
        return list;
    }

    public static boolean areEqual(List list, List list2) {
        if (list == null && list2 == null) {
            return true;
        }
        if ((list == null || list2 == null) && list != list2) {
            return false;
        }
        if (list.size() != list2.size()) {
            return false;
        }
        for (Object e : list) {
            if (list2.contains(e)) continue;
            return false;
        }
        return true;
    }

    public static int[] toArray(List<Integer> list) {
        int[] nArray = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            Integer n = list.get(i);
            nArray[i] = n != null ? n : 0;
        }
        return nArray;
    }

    public static int indexOf(Object object, Object[] objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            Object object2 = objectArray[i];
            if ((object2 != null || object != null) && (object2 == null || object == null || !object2.equals(object))) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(String string, String[] stringArray) {
        return CollectionUtils.indexOf(string, stringArray, false);
    }

    public static int indexOf(String string, String[] stringArray, boolean bl) {
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if ((string2 != null || string != null) && (string2 == null || string == null || !string2.equalsIgnoreCase(string))) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(int n, int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            int n2 = nArray[i];
            if (n2 != n) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(char c, char[] cArray) {
        for (int i = 0; i < cArray.length; ++i) {
            char c2 = cArray[i];
            if (c2 != c) continue;
            return i;
        }
        return -1;
    }
}

