/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.popup;

import com.alee.extended.painter.DefaultPainter;
import com.alee.laf.StyleConstants;
import com.alee.laf.button.WebButton;
import com.alee.laf.panel.WebPanel;
import com.alee.managers.popup.PopupManager;
import com.alee.managers.popup.PopupWay;
import com.alee.managers.popup.WebPopup;
import com.alee.utils.LafUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.swing.AncestorAdapter;
import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.List;
import javax.swing.event.AncestorEvent;

public class WebButtonPopup
extends WebPopup {
    private static final List<String> BUTTON_PROPERTIES = Arrays.asList("icon", "text", "horizontalAlignment", "verticalAlignment", "horizontalTextPosition", "verticalTextPosition", "iconTextGap", "border");
    private PopupWay popupWay;
    private WebButton button;
    private WebButton copiedButton;
    private WebPanel container;

    public WebButtonPopup(final WebButton webButton, PopupWay popupWay) {
        this.popupWay = popupWay;
        this.button = webButton;
        this.setCloseOnFocusLoss(true);
        this.setPainter(new WebButtonPopupPainter());
        this.copiedButton = this.copy(webButton);
        this.copiedButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WebButtonPopup.this.hidePopup(true);
            }
        });
        webButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PopupManager.showPopup(webButton, (WebPopup)WebButtonPopup.this, false);
            }
        });
        webButton.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (BUTTON_PROPERTIES.contains(propertyChangeEvent.getPropertyName())) {
                    WebButtonPopup.this.copySettings(webButton, WebButtonPopup.this.copiedButton);
                }
            }
        });
        webButton.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                if (hierarchyEvent.getID() == 1) {
                    WebButtonPopup.this.hidePopup(false);
                }
            }
        });
        webButton.addAncestorListener(new AncestorAdapter(){

            @Override
            public void ancestorRemoved(AncestorEvent ancestorEvent) {
                WebButtonPopup.this.hidePopup(false);
            }

            @Override
            public void ancestorMoved(AncestorEvent ancestorEvent) {
                WebButtonPopup.this.updateBounds();
            }
        });
        webButton.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent componentEvent) {
                WebButtonPopup.this.hidePopup(false);
            }

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                WebButtonPopup.this.updateBounds();
            }

            @Override
            public void componentMoved(ComponentEvent componentEvent) {
                WebButtonPopup.this.updateBounds();
            }
        });
        this.container = new WebPanel();
        this.container.setOpaque(false);
        this.updateContent();
        this.addAncestorListener(new AncestorAdapter(){

            @Override
            public void ancestorAdded(AncestorEvent ancestorEvent) {
                WebButtonPopup.this.updateBounds();
            }

            @Override
            public void ancestorMoved(AncestorEvent ancestorEvent) {
                WebButtonPopup.this.updateBounds();
            }
        });
    }

    private void updateContent() {
        this.removeAll();
        if (this.popupWay.equals((Object)PopupWay.downLeft)) {
            this.setLayout(new TableLayout(new double[][]{{-1.0, -2.0}, {-2.0, -2.0}}));
            this.add((Component)this.copiedButton, (Object)"1,0");
            this.add((Component)this.container, (Object)"0,1,1,1");
        } else if (this.popupWay.equals((Object)PopupWay.downCenter)) {
            this.setLayout(new TableLayout(new double[][]{{-1.0, -2.0, -1.0}, {-2.0, -2.0}}));
            this.add((Component)this.copiedButton, (Object)"1,0");
            this.add((Component)this.container, (Object)"0,1,2,1");
        } else if (this.popupWay.equals((Object)PopupWay.downRight)) {
            this.setLayout(new TableLayout(new double[][]{{-2.0, -1.0}, {-2.0, -2.0}}));
            this.add((Component)this.copiedButton, (Object)"0,0");
            this.add((Component)this.container, (Object)"0,1,1,1");
        }
        if (this.popupWay.equals((Object)PopupWay.upLeft)) {
            this.setLayout(new TableLayout(new double[][]{{-1.0, -2.0}, {-2.0, -2.0}}));
            this.add((Component)this.copiedButton, (Object)"1,1");
            this.add((Component)this.container, (Object)"0,0,1,0");
        } else if (this.popupWay.equals((Object)PopupWay.upCenter)) {
            this.setLayout(new TableLayout(new double[][]{{-1.0, -2.0, -1.0}, {-2.0, -2.0}}));
            this.add((Component)this.copiedButton, (Object)"1,1");
            this.add((Component)this.container, (Object)"0,0,2,0");
        } else if (this.popupWay.equals((Object)PopupWay.upRight)) {
            this.setLayout(new TableLayout(new double[][]{{-2.0, -1.0}, {-2.0, -2.0}}));
            this.add((Component)this.copiedButton, (Object)"0,1");
            this.add((Component)this.container, (Object)"0,0,1,0");
        }
        if (this.popupWay.equals((Object)PopupWay.leftUp)) {
            this.setLayout(new TableLayout(new double[][]{{-2.0, -2.0}, {-1.0, -2.0}}));
            this.add((Component)this.copiedButton, (Object)"1,1");
            this.add((Component)this.container, (Object)"0,0,0,1");
        } else if (this.popupWay.equals((Object)PopupWay.leftCenter)) {
            this.setLayout(new TableLayout(new double[][]{{-2.0, -2.0}, {-1.0, -2.0, -1.0}}));
            this.add((Component)this.copiedButton, (Object)"1,1");
            this.add((Component)this.container, (Object)"0,0,0,2");
        } else if (this.popupWay.equals((Object)PopupWay.leftDown)) {
            this.setLayout(new TableLayout(new double[][]{{-2.0, -2.0}, {-2.0, -1.0}}));
            this.add((Component)this.copiedButton, (Object)"1,0");
            this.add((Component)this.container, (Object)"0,0,0,1");
        }
        if (this.popupWay.equals((Object)PopupWay.rightUp)) {
            this.setLayout(new TableLayout(new double[][]{{-2.0, -2.0}, {-1.0, -2.0}}));
            this.add((Component)this.copiedButton, (Object)"0,1");
            this.add((Component)this.container, (Object)"1,0,1,1");
        } else if (this.popupWay.equals((Object)PopupWay.rightCenter)) {
            this.setLayout(new TableLayout(new double[][]{{-2.0, -2.0}, {-1.0, -2.0, -1.0}}));
            this.add((Component)this.copiedButton, (Object)"0,1");
            this.add((Component)this.container, (Object)"1,0,1,2");
        } else if (this.popupWay.equals((Object)PopupWay.rightDown)) {
            this.setLayout(new TableLayout(new double[][]{{-2.0, -2.0}, {-2.0, -1.0}}));
            this.add((Component)this.copiedButton, (Object)"0,0");
            this.add((Component)this.container, (Object)"1,0,1,1");
        }
        int n = this.button.getShadeWidth() + 1;
        if (this.isDown()) {
            this.container.setMargin(new Insets(0, n, n, n));
        } else if (this.isUp()) {
            this.container.setMargin(new Insets(n, n, 0, n));
        } else if (this.isLeft()) {
            this.container.setMargin(new Insets(n, n, n, 0));
        } else if (this.isRight()) {
            this.container.setMargin(new Insets(n, 0, n, n));
        }
        this.revalidate();
    }

    @Override
    public void focusChanged(boolean bl) {
        super.focusChanged(bl);
        this.repaint();
    }

    public void setContent(Component component) {
        this.container.removeAll();
        this.container.add(component);
        this.container.revalidate();
    }

    public PopupWay getPopupWay() {
        return this.popupWay;
    }

    public void setPopupWay(PopupWay popupWay) {
        this.popupWay = popupWay;
        this.updateContent();
        this.updateBounds();
    }

    private WebButton copy(final WebButton webButton) {
        WebButton webButton2 = new WebButton(){

            @Override
            public Dimension getPreferredSize() {
                return webButton.getSize();
            }
        };
        this.copySettings(webButton, webButton2);
        webButton2.setFocusable(true);
        webButton2.setUndecorated(true);
        webButton2.setCursor(webButton.getCursor());
        return webButton2;
    }

    private void copySettings(WebButton webButton, WebButton webButton2) {
        webButton2.setIcon(webButton.getIcon());
        webButton2.setText(webButton.getText());
        webButton2.setIconTextGap(webButton.getIconTextGap());
        webButton2.setHorizontalAlignment(webButton.getHorizontalAlignment());
        webButton2.setVerticalAlignment(webButton.getVerticalAlignment());
        webButton2.setHorizontalTextPosition(webButton.getHorizontalTextPosition());
        webButton2.setVerticalTextPosition(webButton.getVerticalTextPosition());
        webButton2.setBorder(webButton.getBorder());
    }

    private void updateBounds() {
        if (this.isShowing() && this.button.isShowing()) {
            Point point = SwingUtils.getRelativeLocation(this.button, this.getParent());
            Dimension dimension = this.getPreferredSize();
            if (this.popupWay.equals((Object)PopupWay.downLeft)) {
                this.setBounds(new Rectangle(new Point(point.x + this.button.getWidth() - dimension.width, point.y), dimension));
            } else if (this.popupWay.equals((Object)PopupWay.downCenter)) {
                this.setBounds(new Rectangle(new Point(point.x + this.button.getWidth() / 2 - dimension.width / 2, point.y), dimension));
            } else if (this.popupWay.equals((Object)PopupWay.downRight)) {
                this.setBounds(new Rectangle(point, dimension));
            } else if (this.popupWay.equals((Object)PopupWay.upLeft)) {
                this.setBounds(new Rectangle(new Point(point.x + this.button.getWidth() - dimension.width, point.y + this.button.getHeight() - dimension.height), dimension));
            } else if (this.popupWay.equals((Object)PopupWay.upCenter)) {
                this.setBounds(new Rectangle(new Point(point.x + this.button.getWidth() / 2 - dimension.width / 2, point.y + this.button.getHeight() - dimension.height), dimension));
            } else if (this.popupWay.equals((Object)PopupWay.upRight)) {
                this.setBounds(new Rectangle(new Point(point.x, point.y + this.button.getHeight() - dimension.height), dimension));
            } else if (this.popupWay.equals((Object)PopupWay.leftUp)) {
                this.setBounds(new Rectangle(new Point(point.x + this.button.getWidth() - dimension.width, point.y + this.button.getHeight() - dimension.height), dimension));
            } else if (this.popupWay.equals((Object)PopupWay.leftCenter)) {
                this.setBounds(new Rectangle(new Point(point.x + this.button.getWidth() - dimension.width, point.y + this.button.getHeight() / 2 - dimension.height / 2), dimension));
            } else if (this.popupWay.equals((Object)PopupWay.leftDown)) {
                this.setBounds(new Rectangle(new Point(point.x + this.button.getWidth() - dimension.width, point.y), dimension));
            } else if (this.popupWay.equals((Object)PopupWay.rightUp)) {
                this.setBounds(new Rectangle(new Point(point.x, point.y + this.button.getHeight() - dimension.height), dimension));
            } else if (this.popupWay.equals((Object)PopupWay.rightCenter)) {
                this.setBounds(new Rectangle(new Point(point.x, point.y + this.button.getHeight() / 2 - dimension.height / 2), dimension));
            } else if (this.popupWay.equals((Object)PopupWay.rightDown)) {
                this.setBounds(new Rectangle(new Point(point.x, point.y), dimension));
            }
            this.revalidate();
        }
    }

    @Override
    public boolean contains(Point point) {
        return this.getPopupShape(this).contains(point);
    }

    public Shape getPopupShape(WebButtonPopup webButtonPopup) {
        int n = this.button.getShadeWidth();
        int n2 = this.button.getRound();
        int n3 = this.button.getHeight() - 1;
        int n4 = this.button.getWidth() - 1;
        int n5 = webButtonPopup.getWidth() - 1;
        int n6 = webButtonPopup.getHeight() - 1;
        Shape shape = null;
        if (this.isUpDown() && n5 == n4 || this.isLeftRight() && n6 == n3) {
            shape = LafUtils.createRoundedShape(n2, this.p(n, n), this.p(n5 - n, n), this.p(n5 - n, n6 - n), this.p(n, n6 - n));
        } else if (this.popupWay.equals((Object)PopupWay.downLeft)) {
            shape = LafUtils.createRoundedShape(n2, this.p(n5 - n4 + n, n), this.p(n5 - n, n), this.p(n5 - n, n6 - n), this.p(n, n6 - n), this.p(n, n3), this.p(n5 - n4 + n, n3));
        } else if (this.popupWay.equals((Object)PopupWay.downCenter)) {
            int n7 = n4 % 2;
            shape = LafUtils.createRoundedShape(n2, this.p(n5 / 2 - n4 / 2 - n7 + n, n), this.p(n5 / 2 + n4 / 2 - n, n), this.p(n5 / 2 + n4 / 2 - n, n3), this.p(n5 - n, n3), this.p(n5 - n, n6 - n), this.p(n, n6 - n), this.p(n, n3), this.p(n5 / 2 - n4 / 2 - n7 + n, n3));
        } else if (this.popupWay.equals((Object)PopupWay.downRight)) {
            shape = LafUtils.createRoundedShape(n2, this.p(n, n), this.p(n4 - n, n), this.p(n4 - n, n3), this.p(n5 - n, n3), this.p(n5 - n, n6 - n), this.p(n, n6 - n));
        } else if (this.popupWay.equals((Object)PopupWay.upLeft)) {
            shape = LafUtils.createRoundedShape(n2, this.p(n, n), this.p(n5 - n, n), this.p(n5 - n, n6 - n), this.p(n5 - n4 + n, n6 - n), this.p(n5 - n4 + n, n6 - n3), this.p(n, n6 - n3));
        } else if (this.popupWay.equals((Object)PopupWay.upCenter)) {
            int n8 = n4 % 2;
            shape = LafUtils.createRoundedShape(n2, this.p(n, n), this.p(n5 - n, n), this.p(n5 - n, n6 - n3), this.p(n5 / 2 + n4 / 2 - n, n6 - n3), this.p(n5 / 2 + n4 / 2 - n, n6 - n), this.p(n5 / 2 - n4 / 2 - n8 + n, n6 - n), this.p(n5 / 2 - n4 / 2 - n8 + n, n6 - n3), this.p(n, n6 - n3));
        } else if (this.popupWay.equals((Object)PopupWay.upRight)) {
            shape = LafUtils.createRoundedShape(n2, this.p(n, n), this.p(n5 - n, n), this.p(n5 - n, n6 - n3), this.p(n4 - n, n6 - n3), this.p(n4 - n, n6 - n), this.p(n, n6 - n));
        } else if (this.popupWay.equals((Object)PopupWay.leftUp)) {
            shape = LafUtils.createRoundedShape(n2, this.p(n, n), this.p(n5 - n4, n), this.p(n5 - n4, n6 - n3 + n), this.p(n5 - n, n6 - n3 + n), this.p(n5 - n, n6 - n), this.p(n, n6 - n));
        } else if (this.popupWay.equals((Object)PopupWay.leftCenter)) {
            int n9 = n3 % 2;
            shape = LafUtils.createRoundedShape(n2, this.p(n, n), this.p(n5 - n4, n), this.p(n5 - n4, n6 / 2 - n3 / 2 + n), this.p(n5 - n, n6 / 2 - n3 / 2 + n), this.p(n5 - n, n6 / 2 + n3 / 2 + n9 - n), this.p(n5 - n4, n6 / 2 + n3 / 2 + n9 - n), this.p(n5 - n4, n6 - n), this.p(n, n6 - n));
        } else if (this.popupWay.equals((Object)PopupWay.leftDown)) {
            shape = LafUtils.createRoundedShape(n2, this.p(n, n), this.p(n5 - n, n), this.p(n5 - n, n3 - n), this.p(n5 - n4, n3 - n), this.p(n5 - n4, n6 - n), this.p(n, n6 - n));
        } else if (this.popupWay.equals((Object)PopupWay.rightUp)) {
            shape = LafUtils.createRoundedShape(n2, this.p(n, n6 - n3 + n), this.p(n4, n6 - n3 + n), this.p(n4, n), this.p(n5 - n, n), this.p(n5 - n, n6 - n), this.p(n, n6 - n));
        } else if (this.popupWay.equals((Object)PopupWay.rightCenter)) {
            int n10 = n3 % 2;
            shape = LafUtils.createRoundedShape(n2, this.p(n, n6 / 2 - n3 / 2 + n), this.p(n4, n6 / 2 - n3 / 2 + n), this.p(n4, n), this.p(n5 - n, n), this.p(n5 - n, n6 - n), this.p(n4, n6 - n), this.p(n4, n6 / 2 + n3 / 2 + n10 - n), this.p(n, n6 / 2 + n3 / 2 + n10 - n));
        } else if (this.popupWay.equals((Object)PopupWay.rightDown)) {
            shape = LafUtils.createRoundedShape(n2, this.p(n, n), this.p(n5 - n, n), this.p(n5 - n, n6 - n), this.p(n4, n6 - n), this.p(n4, n3 - n), this.p(n, n3 - n));
        }
        return shape;
    }

    private boolean isUpDown() {
        return this.isUp() || this.isDown();
    }

    private boolean isDown() {
        return this.popupWay.equals((Object)PopupWay.downLeft) || this.popupWay.equals((Object)PopupWay.downCenter) || this.popupWay.equals((Object)PopupWay.downRight);
    }

    private boolean isUp() {
        return this.popupWay.equals((Object)PopupWay.upLeft) || this.popupWay.equals((Object)PopupWay.upCenter) || this.popupWay.equals((Object)PopupWay.upRight);
    }

    private boolean isLeftRight() {
        return this.isLeft() || this.isRight();
    }

    private boolean isRight() {
        return this.popupWay.equals((Object)PopupWay.rightUp) || this.popupWay.equals((Object)PopupWay.rightCenter) || this.popupWay.equals((Object)PopupWay.rightDown);
    }

    private boolean isLeft() {
        return this.popupWay.equals((Object)PopupWay.leftUp) || this.popupWay.equals((Object)PopupWay.leftCenter) || this.popupWay.equals((Object)PopupWay.leftDown);
    }

    private Point p(int n, int n2) {
        return new Point(n, n2);
    }

    @Override
    public Shape provideShape() {
        return this.getPopupShape(this);
    }

    @Override
    public void hidePopup() {
        this.hidePopup(false);
    }

    public void hidePopup(boolean bl) {
        if (this.isCloseOnFocusLoss() && this.button.isFocusable() && bl) {
            this.button.requestFocusInWindow();
            return;
        }
        super.hidePopup();
        if (this.button.isFocusable() && bl) {
            this.button.requestFocusInWindow();
        }
    }

    private class WebButtonPopupPainter
    extends DefaultPainter<WebButtonPopup> {
        private WebButtonPopupPainter() {
        }

        @Override
        public void paint(Graphics2D graphics2D, Rectangle rectangle, WebButtonPopup webButtonPopup) {
            LafUtils.drawCustomWebBorder(graphics2D, webButtonPopup, WebButtonPopup.this.getPopupShape(webButtonPopup), WebButtonPopup.this.button.isFocusable() && WebButtonPopup.this.button.isDrawFocus() && WebButtonPopup.this.focused ? StyleConstants.fieldFocusColor : StyleConstants.shadeColor, WebButtonPopup.this.button.getShadeWidth(), true, true);
        }
    }
}

