/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.glasspane;

import com.alee.laf.panel.WebPanel;
import com.alee.utils.LafUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.TextUtils;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Window;
import java.awt.geom.Area;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class WebGlassPane
extends WebPanel {
    private static final String ID_PREFIX = "WGP";
    private String id = null;
    private Window window = null;
    private Shape hitShape = null;
    private int imageOpacity = 0;
    private BufferedImage paintedImage = null;
    private Point imageLocation = null;
    private int highlightBorder = 3;
    private Component highlightBase = this;
    private List<Component> highlightedComponents = new ArrayList<Component>();

    public WebGlassPane(Window window) {
        this.window = window;
        this.setOpaque(false);
        this.setFocusable(false);
        this.setLayout(null);
    }

    public String getId() {
        if (this.id == null) {
            this.id = TextUtils.generateId(ID_PREFIX);
        }
        return this.id;
    }

    public Window getWindow() {
        return this.window;
    }

    public void showComponent(JComponent jComponent) {
        SwingUtils.copyOrientation(this, jComponent);
        this.add((Component)jComponent, 0);
        this.revalidate();
    }

    @Override
    public boolean contains(int n, int n2) {
        return this.hitShape != null && this.hitShape.contains(n, n2);
    }

    public Shape getHitShape() {
        return this.hitShape;
    }

    public void setHitShape(Shape shape) {
        this.hitShape = shape;
    }

    public int getImageOpacity() {
        return this.imageOpacity;
    }

    public Point getImageLocation() {
        return this.imageLocation;
    }

    public BufferedImage getPaintedImage() {
        return this.paintedImage;
    }

    public void setPaintedImage(BufferedImage bufferedImage, Point point) {
        this.setPaintedImage(100, bufferedImage, point);
    }

    public void setPaintedImage(int n, BufferedImage bufferedImage, Point point) {
        Rectangle rectangle = this.getPaintedImageRect();
        this.imageOpacity = n;
        this.paintedImage = bufferedImage;
        this.imageLocation = point;
        Rectangle rectangle2 = null;
        if (this.imageOpacity != 0 && this.paintedImage != null && this.imageLocation != null) {
            rectangle2 = this.getPaintedImageRect();
            if (rectangle != null) {
                rectangle2 = new Rectangle(Math.max(0, Math.min(rectangle.x, rectangle2.x)), Math.max(0, Math.min(rectangle.y, rectangle2.y)), Math.max(rectangle.x + rectangle.width, rectangle2.x + rectangle2.width), Math.max(rectangle.y + rectangle.height, rectangle2.y + rectangle2.height));
            }
        }
        final Rectangle rectangle3 = rectangle2 != null ? rectangle2 : rectangle;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (rectangle3 != null) {
                    WebGlassPane.this.repaint(rectangle3);
                } else {
                    WebGlassPane.this.repaint();
                }
            }
        });
    }

    public void clearPaintedImage() {
        final Rectangle rectangle = this.getPaintedImageRect();
        this.imageOpacity = 0;
        this.paintedImage = null;
        this.imageLocation = null;
        if (rectangle != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    WebGlassPane.this.repaint(rectangle);
                }
            });
        }
    }

    public Rectangle getPaintedImageRect() {
        Rectangle rectangle = null;
        if (this.imageOpacity != 0 && this.paintedImage != null && this.imageLocation != null) {
            rectangle = new Rectangle(this.imageLocation.x, this.imageLocation.y, this.paintedImage.getWidth(), this.paintedImage.getHeight());
        }
        return rectangle;
    }

    public int getHighlightBorder() {
        return this.highlightBorder;
    }

    public void setHighlightBorder(int n) {
        this.highlightBorder = n;
    }

    public Component getHighlightBase() {
        return this.highlightBase;
    }

    public void setHighlightBase(Component component) {
        this.highlightBase = component;
    }

    public void addHighlightedComponent(Component component) {
        if (!this.highlightedComponents.contains(component)) {
            this.highlightedComponents.add(component);
        }
        this.repaint();
    }

    public void addHighlightedComponents(List<Component> list) {
        for (Component component : list) {
            if (this.highlightedComponents.contains(component)) continue;
            this.highlightedComponents.add(component);
        }
        this.repaint();
    }

    public void removeHighlightedComponent(Component component) {
        this.highlightedComponents.remove(component);
        this.repaint();
    }

    public void clearHighlights() {
        this.highlightedComponents.clear();
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        Object object;
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        Object object2 = LafUtils.setupAntialias(graphics2D);
        if (this.highlightedComponents.size() > 0) {
            object = SwingUtils.getRelativeBounds(this.highlightBase, this);
            Area area = new Area(new Rectangle(((Rectangle)object).x - 1, ((Rectangle)object).y - 1, ((Rectangle)object).width + 1, ((Rectangle)object).height + 1));
            for (Component component : this.highlightedComponents) {
                if (!component.isShowing()) continue;
                Rectangle rectangle = SwingUtils.getRelativeBounds(component, this);
                RoundRectangle2D.Double double_ = new RoundRectangle2D.Double(rectangle.x - this.highlightBorder, rectangle.y - this.highlightBorder, rectangle.width + this.highlightBorder * 2 - 1, rectangle.height + this.highlightBorder * 2 - 1, 8.0, 8.0);
                area.subtract(new Area(double_));
            }
            graphics2D.setPaint(new Color(128, 128, 128, 128));
            graphics2D.fill(area);
            graphics2D.setStroke(new BasicStroke(1.5f));
            graphics2D.setPaint(Color.GRAY);
            graphics2D.draw(area);
        }
        if (this.imageOpacity != 0 && this.paintedImage != null && this.imageLocation != null) {
            object = graphics2D.getComposite();
            if (this.imageOpacity != 100) {
                graphics2D.setComposite(AlphaComposite.getInstance(3, (float)this.imageOpacity / 100.0f));
            }
            graphics2D.drawImage((Image)this.paintedImage, this.imageLocation.x, this.imageLocation.y, null);
            if (this.imageOpacity != 100) {
                graphics2D.setComposite((Composite)object);
            }
        }
        LafUtils.restoreAntialias(graphics2D, object2);
    }
}

