/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.text;

import com.alee.laf.WebLookAndFeel;
import com.alee.laf.text.WebTextPaneUI;
import com.alee.managers.language.LanguageManager;
import com.alee.managers.language.LanguageMethods;
import com.alee.managers.language.updaters.LanguageUpdater;
import com.alee.utils.ReflectUtils;
import java.awt.Component;
import javax.swing.JTextPane;
import javax.swing.text.StyledDocument;

public class WebTextPane
extends JTextPane
implements LanguageMethods {
    public WebTextPane() {
    }

    public WebTextPane(StyledDocument styledDocument) {
        super(styledDocument);
    }

    public WebTextPaneUI getWebUI() {
        return (WebTextPaneUI)this.getUI();
    }

    @Override
    public void updateUI() {
        if (this.getUI() == null || !(this.getUI() instanceof WebTextPaneUI)) {
            try {
                this.setUI((WebTextPaneUI)ReflectUtils.createInstance(WebLookAndFeel.textPaneUI, new Object[0]));
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                this.setUI(new WebTextPaneUI());
            }
        } else {
            this.setUI(this.getUI());
        }
        this.invalidate();
    }

    @Override
    public void setLanguage(String string, Object ... objectArray) {
        LanguageManager.registerComponent(this, string, objectArray);
    }

    @Override
    public void updateLanguage(Object ... objectArray) {
        LanguageManager.updateComponent((Component)this, objectArray);
    }

    @Override
    public void updateLanguage(String string, Object ... objectArray) {
        LanguageManager.updateComponent((Component)this, string, objectArray);
    }

    @Override
    public void removeLanguage() {
        LanguageManager.unregisterComponent(this);
    }

    @Override
    public boolean isLanguageSet() {
        return LanguageManager.isRegisteredComponent(this);
    }

    @Override
    public void setLanguageUpdater(LanguageUpdater languageUpdater) {
        LanguageManager.registerLanguageUpdater(this, languageUpdater);
    }

    @Override
    public void removeLanguageUpdater() {
        LanguageManager.unregisterLanguageUpdater(this);
    }

    public void clear() {
        this.setText("");
    }
}

