/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.text;

import com.alee.laf.StyleConstants;
import com.alee.utils.SwingUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicEditorPaneUI;
import javax.swing.text.JTextComponent;

public class WebEditorPaneUI
extends BasicEditorPaneUI {
    public static ComponentUI createUI(JComponent jComponent) {
        return new WebEditorPaneUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        JTextComponent jTextComponent = this.getComponent();
        SwingUtils.setOrientation(jTextComponent);
        jTextComponent.setMargin(new Insets(2, 2, 2, 2));
        jTextComponent.setFocusable(true);
        jTextComponent.setOpaque(true);
        jTextComponent.setBackground(Color.WHITE);
        jTextComponent.setSelectionColor(StyleConstants.textSelectionColor);
        jTextComponent.setForeground(Color.BLACK);
        jTextComponent.setSelectedTextColor(Color.BLACK);
        jTextComponent.setCaretColor(Color.GRAY);
    }

    @Override
    protected void paintSafely(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        JTextComponent jTextComponent = this.getComponent();
        Map map = SwingUtils.setupTextAntialias(graphics2D, (Component)jTextComponent);
        super.paintSafely(graphics);
        SwingUtils.restoreTextAntialias(graphics2D, map);
    }
}

