/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.spinner;

import com.alee.laf.StyleConstants;
import com.alee.laf.button.WebButton;
import com.alee.laf.text.WebTextFieldUI;
import com.alee.utils.LafUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.laf.ShapeProvider;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Shape;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSpinnerUI;

public class WebSpinnerUI
extends BasicSpinnerUI
implements ShapeProvider {
    private static final ImageIcon UP_ICON = new ImageIcon(WebSpinnerUI.class.getResource("icons/up.png"));
    private static final ImageIcon DOWN_ICON = new ImageIcon(WebSpinnerUI.class.getResource("icons/down.png"));
    private boolean drawBorder = StyleConstants.drawBorder;
    private boolean drawFocus = StyleConstants.drawFocus;
    private int round = StyleConstants.smallRound;
    private int shadeWidth = StyleConstants.shadeWidth;

    public static ComponentUI createUI(JComponent jComponent) {
        return new WebSpinnerUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        SwingUtils.setOrientation(this.spinner);
        this.spinner.setBackground(Color.WHITE);
        this.spinner.setOpaque(false);
        this.updateBorder(this.drawBorder);
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
    }

    @Override
    public Shape provideShape() {
        return LafUtils.getWebBorderShape(this.spinner, this.getShadeWidth(), this.getRound());
    }

    private void updateBorder(boolean bl) {
        if (this.spinner != null) {
            if (bl) {
                this.spinner.setBorder(BorderFactory.createEmptyBorder(this.shadeWidth + 2, this.shadeWidth + 2, this.shadeWidth + 2, this.shadeWidth + 2));
            } else {
                this.spinner.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            }
        }
    }

    public int getShadeWidth() {
        return this.shadeWidth;
    }

    public void setShadeWidth(int n) {
        this.shadeWidth = n;
        this.updateBorder(this.drawBorder);
    }

    public int getRound() {
        return this.round;
    }

    public void setRound(int n) {
        this.round = n;
        this.updateBorder(this.drawBorder);
    }

    public boolean isDrawBorder() {
        return this.drawBorder;
    }

    public void setDrawBorder(boolean bl) {
        this.drawBorder = bl;
        this.updateBorder(bl);
    }

    public boolean isDrawFocus() {
        return this.drawFocus;
    }

    public void setDrawFocus(boolean bl) {
        this.drawFocus = bl;
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        LafUtils.drawWebStyle((Graphics2D)graphics, jComponent, this.drawFocus && SwingUtils.hasFocusOwner(this.spinner) ? StyleConstants.fieldFocusColor : StyleConstants.shadeColor, this.shadeWidth, this.round);
        super.paint(graphics, jComponent);
    }

    @Override
    protected Component createNextButton() {
        WebButton webButton = WebButton.createIconWebButton(UP_ICON, StyleConstants.smallRound, 1, 2);
        webButton.setLeftRightSpacing(1);
        webButton.setDrawFocus(false);
        webButton.setFocusable(false);
        webButton.setName("Spinner.nextButton");
        this.installNextButtonListeners(webButton);
        return webButton;
    }

    @Override
    protected Component createPreviousButton() {
        WebButton webButton = WebButton.createIconWebButton(DOWN_ICON, StyleConstants.smallRound, 1, 2);
        webButton.setLeftRightSpacing(1);
        webButton.setDrawFocus(false);
        webButton.setFocusable(false);
        webButton.setName("Spinner.previousButton");
        this.installPreviousButtonListeners(webButton);
        return webButton;
    }

    @Override
    protected JComponent createEditor() {
        JComponent jComponent = super.createEditor();
        WebSpinnerUI.installFieldUI(((JSpinner.DefaultEditor)jComponent).getTextField(), this.spinner);
        return jComponent;
    }

    public static void installFieldUI(JFormattedTextField jFormattedTextField, final JSpinner jSpinner) {
        jFormattedTextField.setMargin(new Insets(0, 0, 0, 0));
        jFormattedTextField.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jFormattedTextField.setUI(new WebTextFieldUI(jFormattedTextField, false));
        jFormattedTextField.setOpaque(true);
        jFormattedTextField.setBackground(Color.WHITE);
        jFormattedTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                jSpinner.repaint();
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                jSpinner.repaint();
            }
        });
    }
}

