/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.separator;

import com.alee.laf.separator.WebSeparatorStyle;
import com.alee.utils.LafUtils;
import com.alee.utils.SwingUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LinearGradientPaint;
import javax.swing.JComponent;
import javax.swing.JSeparator;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSeparatorUI;

public class WebSeparatorUI
extends BasicSeparatorUI {
    private static final float[] fractions = new float[]{0.0f, 0.5f, 1.0f};
    private Color separatorLightUpperColor = WebSeparatorStyle.separatorLightUpperColor;
    private Color separatorLightColor = WebSeparatorStyle.separatorLightColor;
    private Color separatorUpperColor = WebSeparatorStyle.separatorUpperColor;
    private Color separatorColor = WebSeparatorStyle.separatorColor;
    private boolean reversedColors = WebSeparatorStyle.reversedColors;
    private boolean drawLeadingLine = WebSeparatorStyle.drawLeadingLine;
    private boolean drawTrailingLine = WebSeparatorStyle.drawTrailingLine;

    public static ComponentUI createUI(JComponent jComponent) {
        return new WebSeparatorUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        SwingUtils.setOrientation(jComponent);
        jComponent.setOpaque(false);
    }

    public Color getSeparatorColor() {
        return this.separatorColor;
    }

    public void setSeparatorColor(Color color) {
        this.separatorColor = color;
    }

    public Color getSeparatorUpperColor() {
        return this.separatorUpperColor;
    }

    public void setSeparatorUpperColor(Color color) {
        this.separatorUpperColor = color;
    }

    public Color getSeparatorLightColor() {
        return this.separatorLightColor;
    }

    public void setSeparatorLightColor(Color color) {
        this.separatorLightColor = color;
    }

    public Color getSeparatorLightUpperColor() {
        return this.separatorLightUpperColor;
    }

    public void setSeparatorLightUpperColor(Color color) {
        this.separatorLightUpperColor = color;
    }

    public boolean isReversedColors() {
        return this.reversedColors;
    }

    public void setReversedColors(boolean bl) {
        this.reversedColors = bl;
    }

    public boolean isDrawLeadingLine() {
        return this.drawLeadingLine;
    }

    public void setDrawLeadingLine(boolean bl) {
        this.drawLeadingLine = bl;
    }

    public boolean isDrawTrailingLine() {
        return this.drawTrailingLine;
    }

    public void setDrawTrailingLine(boolean bl) {
        this.drawTrailingLine = bl;
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        boolean bl;
        Graphics2D graphics2D = (Graphics2D)graphics;
        LafUtils.setupAntialias(graphics2D);
        JSeparator jSeparator = (JSeparator)jComponent;
        Insets insets = jComponent.getInsets();
        int n = insets.left;
        int n2 = insets.top;
        int n3 = jComponent.getWidth() - insets.left - insets.right;
        int n4 = jComponent.getHeight() - insets.top - insets.bottom;
        boolean bl2 = bl = this.drawLeadingLine || this.drawTrailingLine;
        if (jSeparator.getOrientation() == 1) {
            if (bl) {
                graphics2D.setPaint(new LinearGradientPaint(n, n2, n, n2 + n4, fractions, this.getLightColors()));
                if (this.drawLeadingLine) {
                    graphics2D.drawLine(n, n2, n, n2 + n4);
                }
                if (this.drawTrailingLine) {
                    graphics2D.drawLine(n + (this.drawLeadingLine ? 2 : 1), n2, n + (this.drawLeadingLine ? 2 : 1), n2 + n4);
                }
            }
            graphics2D.setPaint(new LinearGradientPaint(n, n2, n, n2 + n4, fractions, this.getDarkColors()));
            graphics2D.drawLine(n + (this.drawLeadingLine ? 1 : 0), n2, n + (this.drawLeadingLine ? 1 : 0), n2 + n4);
        } else {
            if (bl) {
                graphics2D.setPaint(new LinearGradientPaint(n, n2, n + n3, n2, fractions, this.getLightColors()));
                if (this.drawLeadingLine) {
                    graphics2D.drawLine(n, n2, n + n3, n2);
                }
                if (this.drawTrailingLine) {
                    graphics2D.drawLine(n, n2 + (this.drawLeadingLine ? 2 : 1), n + n3, n2 + (this.drawLeadingLine ? 2 : 1));
                }
            }
            graphics2D.setPaint(new LinearGradientPaint(n, n2, n + n3, n2, fractions, this.getDarkColors()));
            graphics2D.drawLine(n, n2 + (this.drawLeadingLine ? 1 : 0), n + n3, n2 + (this.drawLeadingLine ? 1 : 0));
        }
    }

    private Color[] getLightColors() {
        Color[] colorArray;
        if (this.reversedColors) {
            Color[] colorArray2 = new Color[3];
            colorArray2[0] = this.separatorUpperColor;
            colorArray2[1] = this.separatorColor;
            colorArray = colorArray2;
            colorArray2[2] = this.separatorUpperColor;
        } else {
            Color[] colorArray3 = new Color[3];
            colorArray3[0] = this.separatorLightUpperColor;
            colorArray3[1] = Color.WHITE;
            colorArray = colorArray3;
            colorArray3[2] = this.separatorLightUpperColor;
        }
        return colorArray;
    }

    private Color[] getDarkColors() {
        Color[] colorArray;
        if (this.reversedColors) {
            Color[] colorArray2 = new Color[3];
            colorArray2[0] = this.separatorLightUpperColor;
            colorArray2[1] = Color.WHITE;
            colorArray = colorArray2;
            colorArray2[2] = this.separatorLightUpperColor;
        } else {
            Color[] colorArray3 = new Color[3];
            colorArray3[0] = this.separatorUpperColor;
            colorArray3[1] = this.separatorColor;
            colorArray = colorArray3;
            colorArray3[2] = this.separatorUpperColor;
        }
        return colorArray;
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        Insets insets = jComponent.getInsets();
        int n = 1 + (this.drawLeadingLine ? 1 : 0) + (this.drawTrailingLine ? 1 : 0);
        if (((JSeparator)jComponent).getOrientation() == 1) {
            return new Dimension(insets.left + n + insets.right, insets.top + insets.bottom);
        }
        return new Dimension(insets.left + insets.right, insets.top + n + insets.bottom);
    }
}

