/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.colorchooser;

import com.alee.utils.ColorUtils;
import java.awt.Color;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.HashMap;
import java.util.Map;

public class PaletteColorChooserPaint
implements Paint {
    private Color cornerColor = Color.RED;
    private boolean webSafe = false;
    private ColorModel model = ColorModel.getRGBdefault();
    private int x;
    private int y;
    private int width;
    private int height;

    public PaletteColorChooserPaint(int n, int n2, int n3, int n4, Color color) {
        this.x = n;
        this.y = n2;
        this.width = n3;
        this.height = n4;
        this.cornerColor = color;
    }

    @Override
    public PaintContext createContext(ColorModel colorModel, Rectangle rectangle, Rectangle2D rectangle2D, final AffineTransform affineTransform, RenderingHints renderingHints) {
        return new PaintContext(){
            private Map<Rectangle, WritableRaster> rastersCache = new HashMap<Rectangle, WritableRaster>();

            @Override
            public void dispose() {
                this.rastersCache.clear();
            }

            @Override
            public ColorModel getColorModel() {
                return PaletteColorChooserPaint.this.model;
            }

            @Override
            public Raster getRaster(int n, int n2, int n3, int n4) {
                Rectangle rectangle = new Rectangle(n, n2, n3, n4);
                if (this.rastersCache.containsKey(rectangle)) {
                    return this.rastersCache.get(rectangle);
                }
                WritableRaster writableRaster = PaletteColorChooserPaint.this.model.createCompatibleWritableRaster(n3, n4);
                n = (int)((long)n - Math.round(affineTransform.getTranslateX()));
                n2 = (int)((long)n2 - Math.round(affineTransform.getTranslateY()));
                int[] nArray = new int[n3 * n4 * 4];
                for (int i = 0; i < n4; ++i) {
                    for (int j = 0; j < n3; ++j) {
                        int n5 = (i * n3 + j) * 4;
                        nArray[n5] = PaletteColorChooserPaint.this.getRed(n + j, n2 + i);
                        nArray[n5 + 1] = PaletteColorChooserPaint.this.getGreen(n + j, n2 + i);
                        nArray[n5 + 2] = PaletteColorChooserPaint.this.getBlue(n + j, n2 + i);
                        nArray[n5 + 3] = 255;
                    }
                }
                writableRaster.setPixels(0, 0, n3, n4, nArray);
                this.rastersCache.put(rectangle, writableRaster);
                return writableRaster;
            }
        };
    }

    public Color getColor(int n, int n2) {
        if (n < this.x) {
            n = this.x;
        } else if (n > this.x + 256) {
            n = this.x + 256;
        }
        if (n2 < this.y) {
            n2 = this.y;
        } else if (n2 > this.y + 256) {
            n2 = this.y + 256;
        }
        return new Color(this.getRed(n, n2), this.getGreen(n, n2), this.getBlue(n, n2));
    }

    private int getRed(int n, int n2) {
        int n3 = 255 - (255 - this.cornerColor.getRed()) * (n - this.x) / this.width;
        n3 -= n3 * (n2 - this.y) / this.height;
        return this.getWebSafe(n3);
    }

    private int getGreen(int n, int n2) {
        int n3 = 255 - (255 - this.cornerColor.getGreen()) * (n - this.x) / this.width;
        n3 -= n3 * (n2 - this.y) / this.height;
        return this.getWebSafe(n3);
    }

    private int getBlue(int n, int n2) {
        int n3 = 255 - (255 - this.cornerColor.getBlue()) * (n - this.x) / this.width;
        n3 -= n3 * (n2 - this.y) / this.height;
        return this.getWebSafe(n3);
    }

    private int getWebSafe(int n) {
        if (this.webSafe) {
            n = ColorUtils.getWebSafeValue(n);
        }
        if (n < 0) {
            n = 0;
        } else if (n > 255) {
            n = 255;
        }
        return n;
    }

    @Override
    public int getTransparency() {
        return 1;
    }

    public Color getCornerColor() {
        return this.cornerColor;
    }

    public boolean isWebSafe() {
        return this.webSafe;
    }

    public void setWebSafe(boolean bl) {
        this.webSafe = bl;
    }
}

