/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.transition;

import com.alee.extended.layout.StackLayout;
import com.alee.extended.transition.ImageTransition;
import com.alee.extended.transition.TransitionListener;
import com.alee.extended.transition.effects.TransitionEffect;
import com.alee.laf.panel.WebPanel;
import com.alee.utils.CollectionUtils;
import com.alee.utils.SwingUtils;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;

public class ComponentTransition
extends WebPanel {
    private List<TransitionListener> transitionListeners = new ArrayList<TransitionListener>();
    private boolean animating = false;
    private ImageTransition transition = null;
    private List<TransitionEffect> transitionEffects = null;
    private Component lastContent;

    public ComponentTransition() {
        this((Component)null);
    }

    public ComponentTransition(Component component) {
        this(component, null);
    }

    public ComponentTransition(TransitionEffect transitionEffect) {
        this(null, transitionEffect);
    }

    public ComponentTransition(Component component, TransitionEffect transitionEffect) {
        super(new StackLayout());
        this.setFocusable(false);
        this.setTransitionEffect(transitionEffect);
        this.lastContent = component;
        if (component != null) {
            this.add(component);
        }
    }

    public Component getContent() {
        return this.getComponentCount() > 0 ? this.getComponent(0) : null;
    }

    public void setContent(Component component) {
        if (!this.isAnimating()) {
            this.lastContent = component;
            this.removeAll();
            this.add(component);
            this.revalidate();
            this.repaint();
        }
    }

    public synchronized void performTransition(final Component component) {
        SwingUtils.invokeLater(new Runnable(){

            @Override
            public void run() {
                ComponentTransition.this.performThreadedTransition(component);
            }
        });
    }

    public void delayTransition(long l, final Component component) {
        SwingUtils.delayInvokeLater(l, new Runnable(){

            @Override
            public void run() {
                ComponentTransition.this.performThreadedTransition(component);
            }
        });
    }

    private void performThreadedTransition(final Component component) {
        Object object;
        BufferedImage bufferedImage;
        if (this.lastContent == component) {
            return;
        }
        if (!this.isShowing()) {
            this.finishTransition(component);
            return;
        }
        this.lastContent = component;
        if (this.transition != null) {
            if (this.isAnimating()) {
                this.transition.cancelTransition();
            } else {
                this.transition.setBlocked(true);
            }
        }
        this.animating = true;
        final int n = this.getWidth();
        final int n2 = this.getHeight();
        if (this.transition != null) {
            bufferedImage = this.transition.getOtherImage();
        } else {
            object = this.getComponentCount() > 0 ? this.getComponent(0) : null;
            bufferedImage = SwingUtils.createComponentSnapshot((Component)object, n, n2);
        }
        this.setFocusable(true);
        if (SwingUtils.hasFocusOwner(this)) {
            object = new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    ComponentTransition.this.removeFocusListener(this);
                    ComponentTransition.this.continueThreadedTransition(component, n, n2, bufferedImage);
                }
            };
            this.addFocusListener((FocusListener)object);
            if (!this.requestFocusInWindow()) {
                this.removeFocusListener((FocusListener)object);
                this.continueThreadedTransition(component, n, n2, bufferedImage);
            }
        } else {
            this.continueThreadedTransition(component, n, n2, bufferedImage);
        }
    }

    private void continueThreadedTransition(final Component component, int n, int n2, BufferedImage bufferedImage) {
        this.removeAll();
        if (component != null) {
            this.add(component, (Object)"HIDDEN");
        }
        BufferedImage bufferedImage2 = SwingUtils.createComponentSnapshot(component, n, n2);
        this.removeAll();
        this.transition = new ImageTransition(bufferedImage, bufferedImage2);
        this.transition.setTransitionEffects(this.transitionEffects);
        this.add((Component)this.transition);
        this.revalidate();
        this.repaint();
        this.transition.addTransitionListener(new TransitionListener(){

            @Override
            public void transitionStarted() {
                ComponentTransition.this.fireTransitionStarted();
            }

            @Override
            public void transitionFinished() {
                ComponentTransition.this.finishTransition(component);
            }
        });
        this.transition.performTransition();
    }

    private void finishTransition(Component component) {
        this.removeAll();
        if (component != null) {
            this.add(component);
        }
        this.revalidate();
        this.repaint();
        this.animating = false;
        if (this.isFocusOwner()) {
            this.transferFocus();
        }
        this.setFocusable(false);
        if (this.transition != null) {
            this.transition.destroy();
            this.transition = null;
        }
        this.fireTransitionFinished();
    }

    private boolean isAnimating() {
        return this.animating;
    }

    public List<TransitionEffect> getTransitionEffects() {
        return this.transitionEffects;
    }

    public TransitionEffect getTransitionEffect() {
        return this.transitionEffects != null && this.transitionEffects.size() > 0 ? this.transitionEffects.get(0) : null;
    }

    public void addTransitionEffect(TransitionEffect transitionEffect) {
        if (this.transitionEffects == null) {
            this.transitionEffects = new ArrayList<TransitionEffect>();
        }
        this.transitionEffects.add(transitionEffect);
    }

    public void clearTransitionEffects() {
        if (this.transitionEffects != null) {
            this.transitionEffects.clear();
            this.transitionEffects = null;
        }
    }

    public void removeTransitionEffect(TransitionEffect transitionEffect) {
        if (this.transitionEffects != null) {
            this.transitionEffects.remove(transitionEffect);
        }
    }

    public void setTransitionEffect(TransitionEffect transitionEffect) {
        this.transitionEffects = transitionEffect != null ? CollectionUtils.copy(transitionEffect) : null;
    }

    public void setTransitionEffects(List<TransitionEffect> list) {
        this.transitionEffects = list;
    }

    public void setTransitionEffects(TransitionEffect ... transitionEffectArray) {
        this.transitionEffects = transitionEffectArray != null ? CollectionUtils.copy(transitionEffectArray) : null;
    }

    public void addTransitionListener(TransitionListener transitionListener) {
        this.transitionListeners.add(transitionListener);
    }

    public void removeTransitionListener(TransitionListener transitionListener) {
        this.transitionListeners.remove(transitionListener);
    }

    private void fireTransitionStarted() {
        for (TransitionListener transitionListener : CollectionUtils.copy(this.transitionListeners)) {
            transitionListener.transitionStarted();
        }
    }

    private void fireTransitionFinished() {
        for (TransitionListener transitionListener : CollectionUtils.copy(this.transitionListeners)) {
            transitionListener.transitionFinished();
        }
    }
}

