/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.progress;

import com.alee.extended.progress.StepData;
import com.alee.extended.progress.WebStepProgressStyle;
import com.alee.laf.StyleConstants;
import com.alee.utils.CollectionUtils;
import com.alee.utils.LafUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.laf.ShapeProvider;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.LinearGradientPaint;
import java.awt.Point;
import java.awt.Shape;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingConstants;

public class WebStepProgress
extends JComponent
implements SwingConstants,
ShapeProvider {
    public static final int STEP_SELECTION = 1;
    public static final int PROGRESS_SELECTION = 2;
    private Insets margin = WebStepProgressStyle.margin;
    private int shadeWidth = WebStepProgressStyle.shadeWidth;
    private int stepControlSize = WebStepProgressStyle.stepControlSize;
    private int stepControlRound = WebStepProgressStyle.stepControlRound;
    private int stepControlFillSize = WebStepProgressStyle.stepControlFillSize;
    private int stepControlFillRound = WebStepProgressStyle.stepControlFillRound;
    private int pathSize = WebStepProgressStyle.pathSize;
    private int fillPathSize = WebStepProgressStyle.fillPathSize;
    private Color progressColor = WebStepProgressStyle.progressColor;
    private Color disabledProgressColor = WebStepProgressStyle.disabledProgressColor;
    private boolean showLabels = WebStepProgressStyle.showLabels;
    private int orientation = WebStepProgressStyle.orientation;
    private int labelsPosition = WebStepProgressStyle.labelsPosition;
    private int spacing = WebStepProgressStyle.spacing;
    private boolean selectionEnabled = WebStepProgressStyle.selectionEnabled;
    private int selectionMode = WebStepProgressStyle.selectionMode;
    private List<StepData> steps = new ArrayList<StepData>();
    private int selectedStep = 0;
    private float progress = 0.0f;
    private int rolloverStep = -1;
    private boolean selecting = false;
    private int sideWidth = 0;
    private Shape borderShape;
    private LinearGradientPaint fillPaint;
    private Shape fillShape;

    public WebStepProgress() {
        this(3);
    }

    public WebStepProgress(int n) {
        this(WebStepProgress.createDefaultData(n));
    }

    public WebStepProgress(String ... stringArray) {
        this(WebStepProgress.createSteps(stringArray));
    }

    public WebStepProgress(Component ... componentArray) {
        this(WebStepProgress.createSteps(componentArray));
    }

    public WebStepProgress(StepData ... stepDataArray) {
        this(CollectionUtils.copy(stepDataArray));
    }

    public WebStepProgress(List<StepData> list) {
        this.setSteps(list);
        this.setLayout(new ProgressLayout());
        ProgressMouseAdapter progressMouseAdapter = new ProgressMouseAdapter();
        this.addMouseListener(progressMouseAdapter);
        this.addMouseMotionListener(progressMouseAdapter);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                WebStepProgress.this.updateShapes();
            }
        });
    }

    public Insets getMargin() {
        return this.margin;
    }

    public void setMargin(Insets insets) {
        this.margin = insets;
        this.revalidate();
        this.repaint();
    }

    public void setMargin(int n, int n2, int n3, int n4) {
        this.setMargin(new Insets(n, n2, n3, n4));
    }

    public void setMargin(int n) {
        this.setMargin(n, n, n, n);
    }

    public int getShadeWidth() {
        return this.shadeWidth;
    }

    public void setShadeWidth(int n) {
        this.shadeWidth = n;
        this.revalidate();
        this.repaint();
    }

    public int getStepControlSize() {
        return this.stepControlSize;
    }

    public void setStepControlSize(int n) {
        this.stepControlSize = n;
        this.revalidate();
        this.repaint();
    }

    public int getStepControlRound() {
        return this.stepControlRound;
    }

    public void setStepControlRound(int n) {
        this.stepControlRound = n;
        this.repaint();
    }

    public int getStepControlFillSize() {
        return this.stepControlFillSize;
    }

    public void setStepControlFillSize(int n) {
        this.stepControlFillSize = n;
        this.revalidate();
        this.repaint();
    }

    public int getStepControlFillRound() {
        return this.stepControlFillRound;
    }

    public void setStepControlFillRound(int n) {
        this.stepControlFillRound = n;
        this.repaint();
    }

    public int getPathSize() {
        return this.pathSize;
    }

    public void setPathSize(int n) {
        this.pathSize = n;
        this.revalidate();
        this.repaint();
    }

    public int getFillPathSize() {
        return this.fillPathSize;
    }

    public void setFillPathSize(int n) {
        this.fillPathSize = n;
        this.revalidate();
        this.repaint();
    }

    public boolean isShowLabels() {
        return this.showLabels;
    }

    public void setShowLabels(boolean bl) {
        if (this.showLabels != bl) {
            this.showLabels = bl;
            if (bl) {
                for (StepData stepData : this.steps) {
                    if (stepData.getLabel() == null) continue;
                    this.add(stepData.getLabel());
                }
            } else {
                for (StepData stepData : this.steps) {
                    if (stepData.getLabel() == null) continue;
                    this.remove(stepData.getLabel());
                }
            }
            this.revalidate();
            this.repaint();
        }
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int n) {
        this.orientation = n;
        this.revalidate();
        this.repaint();
    }

    public int getLabelsPosition() {
        return this.labelsPosition;
    }

    public void setLabelsPosition(int n) {
        this.labelsPosition = n;
        this.revalidate();
        this.repaint();
    }

    public int getSpacing() {
        return this.spacing;
    }

    public void setSpacing(int n) {
        this.spacing = n;
        this.revalidate();
        this.repaint();
    }

    public boolean isSelectionEnabled() {
        return this.selectionEnabled;
    }

    public void setSelectionEnabled(boolean bl) {
        this.selectionEnabled = bl;
    }

    public int getSelectionMode() {
        return this.selectionMode;
    }

    public void setSelectionMode(int n) {
        this.selectionMode = n;
    }

    public int getStepsAmount() {
        return this.steps.size();
    }

    public List<StepData> getSteps() {
        return this.steps;
    }

    public StepData getStep(int n) {
        return this.steps.get(n);
    }

    public void setSteps(String ... stringArray) {
        this.setSteps(WebStepProgress.createSteps(stringArray));
    }

    public void setSteps(Component ... componentArray) {
        this.setSteps(WebStepProgress.createSteps(componentArray));
    }

    public void setSteps(List<StepData> list) {
        this.clearSteps();
        this.addSteps(list);
        this.validateSelectedStep();
    }

    public void addSteps(String ... stringArray) {
        if (stringArray != null) {
            this.addSteps(WebStepProgress.createSteps(stringArray));
        }
    }

    public void addSteps(Component ... componentArray) {
        if (componentArray != null) {
            this.addSteps(WebStepProgress.createSteps(componentArray));
        }
    }

    public void addSteps(List<StepData> list) {
        if (list != null) {
            this.steps.addAll(list);
            if (this.showLabels) {
                for (StepData stepData : list) {
                    if (stepData.getLabel() == null) continue;
                    this.add(stepData.getLabel());
                }
                this.revalidate();
                this.repaint();
            }
        }
    }

    public void removeStep(int n) {
        this.removeStep(this.getStep(n));
    }

    public void removeStep(StepData stepData) {
        this.clearStep(stepData);
        this.validateSelectedStep();
        this.revalidate();
        this.repaint();
    }

    public void setStepsAmount(int n) {
        this.clearSteps();
        this.addSteps(WebStepProgress.createDefaultData(n));
        this.validateSelectedStep();
        this.revalidate();
        this.repaint();
    }

    private void clearSteps() {
        if (this.steps.size() > 0) {
            for (StepData stepData : CollectionUtils.copy(this.steps)) {
                this.clearStep(stepData);
            }
        }
    }

    private void clearStep(StepData stepData) {
        Component component;
        if (this.showLabels && (component = stepData.getLabel()) != null) {
            component.getParent().remove(component);
        }
        this.steps.remove(stepData);
    }

    public int getSelectedStep() {
        return this.selectedStep;
    }

    public void setSelectedStep(int n) {
        if (n == this.selectedStep) {
            return;
        }
        if (n < 0) {
            n = 0;
        }
        if (n >= this.steps.size()) {
            n = this.steps.size() - 1;
        }
        this.selectedStep = n;
        this.progress = 0.0f;
        this.updateFillShape();
    }

    private void validateSelectedStep() {
        if (this.selectedStep < this.getStepsAmount()) {
            this.setSelectedStep(0);
        }
    }

    public float getProgress() {
        return this.progress;
    }

    private float getProgressAt(Point point) {
        return 0.0f;
    }

    public void setProgress(float f) {
        if (f == this.progress) {
            return;
        }
        if (f < 0.0f) {
            float f2 = Math.abs(f);
            int n = this.selectedStep - Math.round(f2 - f2 % 1.0f) - 1;
            f = n < 0 ? 0.0f : 1.0f - f2 % 1.0f;
            this.setSelectedStep(n);
        } else if (f >= 1.0f) {
            int n = this.selectedStep + Math.round(f - f % 1.0f);
            f = n >= this.steps.size() ? 0.0f : f % 1.0f;
            this.setSelectedStep(n);
        }
        this.progress = f;
        this.updateFillShape();
    }

    public float getTotalProgress() {
        return ((float)this.selectedStep + this.progress) / (float)(this.steps.size() - 1);
    }

    public float getTotalProgressAt(Point point) {
        boolean bl = this.orientation == 0;
        Point point2 = this.getPathStart();
        Point point3 = this.getPathEnd();
        float f = this.getPathWidth();
        if (bl) {
            if (this.getComponentOrientation().isLeftToRight()) {
                if (point.x < point2.x) {
                    return 0.0f;
                }
                if (point.x > point3.x) {
                    return this.steps.size() - 1;
                }
                return (float)((this.steps.size() - 1) * (point.x - point2.x)) / f;
            }
            if (point.x > point2.x) {
                return 0.0f;
            }
            if (point.x < point3.x) {
                return this.steps.size() - 1;
            }
            return (float)(this.steps.size() - 1) * (f - (float)(point.x - point3.x)) / f;
        }
        if (point.y < point2.y) {
            return 0.0f;
        }
        if (point.y > point3.y) {
            return this.steps.size() - 1;
        }
        return (float)((this.steps.size() - 1) * (point.y - point2.y)) / f;
    }

    public void setTotalProgress(float f) {
        f = (float)(this.steps.size() - 1) * f;
        this.setSelectedStep(Math.round(f - f % 1.0f));
        this.setProgress(f % 1.0f);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        Object object = LafUtils.setupAntialias(graphics2D);
        LafUtils.drawCustomWebBorder(graphics2D, this, this.getBorderShape(), StyleConstants.shadeColor, this.shadeWidth, true, true);
        graphics2D.setPaint(this.getFillPaint());
        graphics2D.fill(this.getProgressShape());
        LafUtils.restoreAntialias(graphics2D, object);
    }

    @Override
    public Shape provideShape() {
        return this.getBorderShape();
    }

    private void updateBorderShape() {
        this.borderShape = null;
        this.repaint();
    }

    private void updateFillShape() {
        this.fillPaint = null;
        this.fillShape = null;
        this.repaint();
    }

    private void updateShapes() {
        this.borderShape = null;
        this.fillPaint = null;
        this.fillShape = null;
        this.repaint();
    }

    private Shape getBorderShape() {
        if (this.borderShape == null) {
            this.borderShape = this.createBorderShape();
        }
        return this.borderShape;
    }

    private Shape createBorderShape() {
        Area area = new Area(this.getPathShape());
        for (int i = 0; i < this.steps.size(); ++i) {
            area.add(new Area(this.getStepBorderCircle(i)));
        }
        return area;
    }

    private Shape getStepBorderCircle(int n) {
        Point point = this.getStepCenter(n);
        if (this.stepControlRound * 2 >= this.stepControlSize) {
            return new Ellipse2D.Double(point.x - this.stepControlSize / 2, point.y - this.stepControlSize / 2, this.stepControlSize, this.stepControlSize);
        }
        return new RoundRectangle2D.Double(point.x - this.stepControlSize / 2, point.y - this.stepControlSize / 2, this.stepControlSize, this.stepControlSize, this.stepControlRound * 2, this.stepControlRound * 2);
    }

    private LinearGradientPaint getFillPaint() {
        if (this.fillPaint == null) {
            this.fillPaint = this.createFillPaint();
        }
        return this.fillPaint;
    }

    private LinearGradientPaint createFillPaint() {
        Color color;
        Point point = this.getPathStart();
        Point point2 = this.getPathEnd();
        float f = (float)this.selectedStep + this.progress;
        int n = this.getPathWidth() / (this.steps.size() - 1);
        float f2 = (float)this.stepControlFillSize * 1.5f + (float)n * f;
        Color color2 = color = this.isEnabled() ? this.progressColor : this.disabledProgressColor;
        if (this.orientation == 0) {
            Color[] colorArray;
            float[] fArray;
            float f3;
            boolean bl = this.getComponentOrientation().isLeftToRight();
            float f4 = f3 = bl ? (float)(point.x - this.stepControlFillSize / 2) : (float)(point.x + this.stepControlFillSize / 2) - f2;
            if (bl) {
                float[] fArray2 = new float[3];
                fArray2[0] = 0.0f;
                fArray2[1] = ((float)this.stepControlFillSize + (float)n * f) / f2;
                fArray = fArray2;
                fArray2[2] = 1.0f;
            } else {
                float[] fArray3 = new float[3];
                fArray3[0] = 0.0f;
                fArray3[1] = 1.0f - ((float)this.stepControlFillSize + (float)n * f) / f2;
                fArray = fArray3;
                fArray3[2] = 1.0f;
            }
            float[] fArray4 = fArray;
            if (bl) {
                Color[] colorArray2 = new Color[3];
                colorArray2[0] = color;
                colorArray2[1] = color;
                colorArray = colorArray2;
                colorArray2[2] = StyleConstants.transparent;
            } else {
                Color[] colorArray3 = new Color[3];
                colorArray3[0] = StyleConstants.transparent;
                colorArray3[1] = color;
                colorArray = colorArray3;
                colorArray3[2] = color;
            }
            Color[] colorArray4 = colorArray;
            return new LinearGradientPaint(f3, 0.0f, f3 + f2, 0.0f, fArray4, colorArray4);
        }
        float f5 = point.y - this.stepControlFillSize / 2;
        return new LinearGradientPaint(0.0f, f5, 0.0f, f5 + f2, new float[]{0.0f, ((float)this.stepControlFillSize + (float)n * f) / f2, 1.0f}, new Color[]{color, color, StyleConstants.transparent});
    }

    private Shape getProgressShape() {
        if (this.fillShape == null) {
            this.fillShape = this.createFillShape();
        }
        return this.fillShape;
    }

    private Shape createFillShape() {
        Area area = new Area(this.getPathFillShape());
        for (int i = 0; i < this.steps.size(); ++i) {
            area.add(new Area(this.getStepFillCircle(i)));
        }
        return area;
    }

    private Shape getStepFillCircle(int n) {
        Point point = this.getStepCenter(n);
        if (this.stepControlFillRound * 2 >= this.stepControlFillSize) {
            return new Ellipse2D.Double(point.x - this.stepControlFillSize / 2, point.y - this.stepControlFillSize / 2, this.stepControlFillSize, this.stepControlFillSize);
        }
        return new RoundRectangle2D.Double(point.x - this.stepControlFillSize / 2, point.y - this.stepControlFillSize / 2, this.stepControlFillSize, this.stepControlFillSize, this.stepControlFillRound * 2, this.stepControlFillRound * 2);
    }

    private Shape getPathShape() {
        Point point = this.getPathStart();
        Point point2 = this.getPathEnd();
        if (this.orientation == 0) {
            boolean bl = this.getComponentOrientation().isLeftToRight();
            return new Rectangle2D.Double(bl ? (double)point.x : (double)point2.x, (float)point.y - (float)this.pathSize / 2.0f, bl ? (double)(point2.x - point.x) : (double)(point.x - point2.x), this.pathSize);
        }
        return new Rectangle2D.Double((float)point.x - (float)this.pathSize / 2.0f, point.y, this.pathSize, point2.y - point.y);
    }

    private Shape getPathFillShape() {
        Point point = this.getPathStart();
        Point point2 = this.getPathEnd();
        if (this.orientation == 0) {
            boolean bl = this.getComponentOrientation().isLeftToRight();
            return new Rectangle2D.Double(bl ? (double)point.x : (double)point2.x, (float)point.y + 0.5f - (float)this.fillPathSize / 2.0f, bl ? (double)(point2.x - point.x) : (double)(point.x - point2.x), this.fillPathSize);
        }
        return new Rectangle2D.Double((float)point.x + 0.5f - (float)this.fillPathSize / 2.0f, point.y, this.fillPathSize, point2.y - point.y);
    }

    private Point getPathStart() {
        return this.getStepCenter(0);
    }

    private Point getPathEnd() {
        return this.getStepCenter(this.steps.size() - 1);
    }

    private Point getStepCenter(int n) {
        Dimension dimension = this.getMaximumComponentSize();
        boolean bl = this.getComponentOrientation().isLeftToRight();
        if (this.orientation == 0) {
            int n2 = this.margin.left + this.sideWidth + this.getPathWidth() * (bl ? n : this.steps.size() - 1 - n) / (this.steps.size() - 1);
            int n3 = this.getHeight() - this.margin.top - this.margin.bottom;
            int n4 = dimension.height + (dimension.height > 0 ? this.spacing : 0);
            int n5 = n4 + this.stepControlSize + this.shadeWidth * 2;
            int n6 = this.margin.top + n3 / 2 - n5 / 2 + (this.labelsPosition == 10 ? n4 : 0) + this.shadeWidth + this.stepControlSize / 2;
            return new Point(n2, n6);
        }
        int n7 = this.margin.top + this.sideWidth + this.getPathWidth() * n / (this.steps.size() - 1);
        int n8 = this.getWidth() - this.margin.left - this.margin.right;
        int n9 = dimension.width + (dimension.width > 0 ? this.spacing : 0);
        int n10 = n9 + this.stepControlSize + this.shadeWidth * 2;
        int n11 = this.margin.left + n8 / 2 - n10 / 2 + ((bl ? this.labelsPosition == 10 : this.labelsPosition == 11) ? n9 : 0) + this.shadeWidth + this.stepControlSize / 2;
        return new Point(n11, n7);
    }

    private int getPathWidth() {
        if (this.orientation == 0) {
            return this.getWidth() - this.sideWidth * 2 - this.margin.left - this.margin.right - 1;
        }
        return this.getHeight() - this.sideWidth * 2 - this.margin.top - this.margin.bottom - 1;
    }

    public int getStepCircleAt(Point point) {
        for (int i = 0; i < this.steps.size(); ++i) {
            if (!this.getStepBorderCircle(i).contains(point)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        Dimension dimension = this.getMaximumComponentSize();
        Dimension dimension2 = this.getMaximumSideComponentSize();
        if (this.orientation == 0) {
            this.sideWidth = Math.max(dimension2.width / 2, this.stepControlSize / 2 + this.shadeWidth);
            int n = this.margin.left + this.shadeWidth * (this.steps.size() - 1) * 2 + this.stepControlSize * (this.steps.size() - 1) + this.sideWidth * 2 + this.margin.right + 1;
            int n2 = this.margin.top + this.shadeWidth * 2 + this.stepControlSize + dimension.height + (dimension.height > 0 ? this.spacing : 0) + this.margin.bottom + 1;
            return new Dimension(n, n2);
        }
        this.sideWidth = Math.max(dimension2.height / 2, this.stepControlSize / 2 + this.shadeWidth);
        int n = this.margin.left + this.shadeWidth * 2 + this.stepControlSize + dimension.width + (dimension.width > 0 ? this.spacing : 0) + this.margin.right + 1;
        int n3 = this.margin.top + this.shadeWidth * (this.steps.size() - 1) * 2 + this.stepControlSize * (this.steps.size() - 1) + this.sideWidth * 2 + this.margin.bottom + 1;
        return new Dimension(n, n3);
    }

    private Dimension getMaximumComponentSize() {
        Dimension dimension = new Dimension(0, 0);
        if (this.showLabels && this.steps.size() > 0) {
            for (StepData stepData : this.steps) {
                if (stepData.getLabel() == null) continue;
                dimension = SwingUtils.max(dimension, stepData.getLabel().getPreferredSize());
            }
        }
        return dimension;
    }

    private Dimension getMaximumSideComponentSize() {
        if (this.showLabels && this.steps.size() > 0) {
            Component component = this.steps.get(0).getLabel();
            Component component2 = this.steps.get(this.steps.size() - 1).getLabel();
            if (component != null && component2 != null) {
                return SwingUtils.max(component.getPreferredSize(), component2.getPreferredSize());
            }
            if (component != null) {
                return component.getPreferredSize();
            }
            if (component2 != null) {
                return component2.getPreferredSize();
            }
            return new Dimension(0, 0);
        }
        return new Dimension(0, 0);
    }

    public static List<StepData> createSteps(String[] stringArray) {
        ArrayList<StepData> arrayList = new ArrayList<StepData>();
        for (String string : stringArray) {
            arrayList.add(new StepData(string));
        }
        return arrayList;
    }

    public static List<StepData> createSteps(Component[] componentArray) {
        ArrayList<StepData> arrayList = new ArrayList<StepData>();
        for (Component component : componentArray) {
            arrayList.add(new StepData(component));
        }
        return arrayList;
    }

    public static List<StepData> createDefaultData(int n) {
        ArrayList<StepData> arrayList = new ArrayList<StepData>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(new StepData());
        }
        return arrayList;
    }

    private class ProgressMouseAdapter
    extends MouseAdapter {
        private ProgressMouseAdapter() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (WebStepProgress.this.isEnabled() && WebStepProgress.this.isSelectionEnabled() && SwingUtils.isLeftMouseButton(mouseEvent)) {
                WebStepProgress.this.selecting = true;
                this.updateProgress(mouseEvent.getPoint());
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (WebStepProgress.this.selecting && SwingUtils.isLeftMouseButton(mouseEvent)) {
                this.updateProgress(mouseEvent.getPoint());
            }
        }

        private void updateProgress(Point point) {
            float f = WebStepProgress.this.getTotalProgressAt(point);
            if (WebStepProgress.this.selectionMode == 2) {
                WebStepProgress.this.setSelectedStep(Math.round(f - f % 1.0f));
                WebStepProgress.this.setProgress(f % 1.0f);
            } else {
                WebStepProgress.this.setSelectedStep(Math.round(f));
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (WebStepProgress.this.selecting && SwingUtils.isLeftMouseButton(mouseEvent)) {
                WebStepProgress.this.selecting = false;
            }
        }
    }

    private class ProgressLayout
    implements LayoutManager {
        private ProgressLayout() {
        }

        @Override
        public void addLayoutComponent(String string, Component component) {
        }

        @Override
        public void removeLayoutComponent(Component component) {
        }

        @Override
        public void layoutContainer(Container container) {
            boolean bl = WebStepProgress.this.getComponentOrientation().isLeftToRight();
            for (int i = 0; i < WebStepProgress.this.steps.size(); ++i) {
                Component component = WebStepProgress.this.getStep(i).getLabel();
                if (component == null) continue;
                Point point = WebStepProgress.this.getStepCenter(i);
                Dimension dimension = component.getPreferredSize();
                if (WebStepProgress.this.orientation == 0) {
                    if (WebStepProgress.this.labelsPosition == 10) {
                        component.setBounds(point.x - dimension.width / 2, point.y - WebStepProgress.this.stepControlSize / 2 - WebStepProgress.this.shadeWidth - WebStepProgress.this.spacing - dimension.height, dimension.width, dimension.height);
                        continue;
                    }
                    component.setBounds(point.x - dimension.width / 2, point.y + WebStepProgress.this.stepControlSize / 2 + WebStepProgress.this.shadeWidth + WebStepProgress.this.spacing, dimension.width, dimension.height);
                    continue;
                }
                if (bl ? WebStepProgress.this.labelsPosition == 10 : WebStepProgress.this.labelsPosition == 11) {
                    component.setBounds(point.x - WebStepProgress.this.stepControlSize / 2 - WebStepProgress.this.shadeWidth - WebStepProgress.this.spacing - dimension.width, point.y - dimension.height / 2, dimension.width, dimension.height);
                    continue;
                }
                component.setBounds(point.x + WebStepProgress.this.stepControlSize / 2 + WebStepProgress.this.shadeWidth + WebStepProgress.this.spacing, point.y - dimension.height / 2, dimension.width, dimension.height);
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            return null;
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            return null;
        }
    }
}

