/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.painter;

import com.alee.extended.painter.BorderPainter;
import com.alee.extended.painter.TitlePosition;
import com.alee.utils.LafUtils;
import com.alee.utils.SwingUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.SwingConstants;

public class TitledBorderPainter<E extends JComponent>
extends BorderPainter<E>
implements SwingConstants {
    protected int titleOffset = 4;
    protected int titleBorderGap = 3;
    protected TitlePosition titlePosition = TitlePosition.onLine;
    protected Color foreground = null;
    protected Color background = null;
    protected boolean clipTitleBackground = true;
    protected int titleAlignment;
    protected int titleSide;
    protected String titleText;
    private int w;
    private int h;
    private boolean emptyTitle;
    private FontMetrics fontMetrics;
    private int titleAreaHeight;
    private int titleWidth;
    private int titleX;
    private int titleY;
    private double borderCenter;
    private double borderPosition;
    private Shape borderShape;
    private boolean doClip;

    public TitledBorderPainter() {
        this((String)null);
    }

    public TitledBorderPainter(String string) {
        this(string, 10);
    }

    public TitledBorderPainter(String string, int n) {
        this(string, n, 1);
    }

    public TitledBorderPainter(String string, int n, int n2) {
        this.setTitleText(string);
        this.setTitleAlignment(n);
        this.setTitleSide(n2);
    }

    public int getTitleOffset() {
        return this.titleOffset;
    }

    public void setTitleOffset(int n) {
        this.titleOffset = n;
    }

    public int getTitleBorderGap() {
        return this.titleBorderGap;
    }

    public void setTitleBorderGap(int n) {
        this.titleBorderGap = n;
    }

    public int getTitleSide() {
        return this.titleSide;
    }

    public void setTitleSide(int n) {
        this.titleSide = n;
    }

    public int getTitleAlignment() {
        return this.titleAlignment;
    }

    public void setTitleAlignment(int n) {
        this.titleAlignment = n;
    }

    public TitlePosition getTitlePosition() {
        return this.titlePosition;
    }

    public void setTitlePosition(TitlePosition titlePosition) {
        this.titlePosition = titlePosition;
    }

    public Color getForeground() {
        return this.foreground;
    }

    public void setForeground(Color color) {
        this.foreground = color;
    }

    public Color getBackground() {
        return this.background;
    }

    public void setBackground(Color color) {
        this.background = color;
    }

    public boolean isClipTitleBackground() {
        return this.clipTitleBackground;
    }

    public void setClipTitleBackground(boolean bl) {
        this.clipTitleBackground = bl;
    }

    public String getTitleText() {
        return this.titleText;
    }

    public void setTitleText(String string) {
        this.titleText = string;
    }

    @Override
    public Insets getMargin(E e) {
        Insets insets = super.getMargin(e);
        if (!this.isEmptyTitle()) {
            switch (this.titleSide) {
                case 1: {
                    insets.top += this.getTitleAreaHeight(e);
                    break;
                }
                case 2: {
                    insets.left += this.getTitleAreaHeight(e);
                    break;
                }
                case 3: {
                    insets.bottom += this.getTitleAreaHeight(e);
                    break;
                }
                case 4: {
                    insets.right += this.getTitleAreaHeight(e);
                }
            }
        }
        return insets;
    }

    @Override
    public Dimension getPreferredSize(E e) {
        if (this.isEmptyTitle()) {
            return super.getPreferredSize(e);
        }
        int n = this.getTitleAreaHeight(e);
        int n2 = ((JComponent)e).getFontMetrics(((Component)e).getFont()).stringWidth(this.titleText);
        int n3 = Math.max(this.width, this.round);
        int n4 = Math.max(n, n3);
        switch (this.titleSide) {
            case 1: 
            case 3: {
                return new Dimension(n3 * 2 + n2 + this.titleOffset * 2 + this.titleBorderGap * 2, n4 + n3);
            }
            case 2: 
            case 4: {
                return new Dimension(n4 + n3, n3 * 2 + n2 + this.titleOffset * 2 + this.titleBorderGap * 2);
            }
        }
        return null;
    }

    @Override
    public void paint(Graphics2D graphics2D, Rectangle rectangle, E e) {
        this.w = ((JComponent)e).getWidth();
        this.h = ((JComponent)e).getHeight();
        this.emptyTitle = this.isEmptyTitle();
        this.fontMetrics = this.emptyTitle ? null : ((JComponent)e).getFontMetrics(((Component)e).getFont());
        this.titleWidth = this.emptyTitle ? 0 : this.fontMetrics.stringWidth(this.titleText);
        this.titleAreaHeight = this.getTitleAreaHeight(e);
        this.titleX = this.getTitleX(e);
        this.titleY = this.getTitleY(e);
        this.borderCenter = (double)this.width / 2.0;
        this.borderPosition = this.getBorderPosition();
        this.borderShape = this.getBorderShape(e);
        this.doClip = this.clipTitleBackground && !this.emptyTitle && this.titlePosition.equals((Object)TitlePosition.onLine);
        Object object = LafUtils.setupAntialias(graphics2D);
        Stroke stroke = LafUtils.setupStroke(graphics2D, this.stroke, this.stroke != null);
        if (this.background != null && !this.doClip) {
            graphics2D.setPaint(this.background);
            graphics2D.fill(this.borderShape);
        }
        Shape shape = this.doClip ? this.getBorderClipShape(e) : null;
        Shape shape2 = LafUtils.subtractClip(graphics2D, shape, this.doClip);
        if (this.background != null && this.doClip) {
            graphics2D.setPaint(this.background);
            graphics2D.fill(this.borderShape);
        }
        graphics2D.setPaint(this.color);
        graphics2D.draw(this.borderShape);
        LafUtils.restoreClip(graphics2D, shape2, this.doClip);
        LafUtils.restoreStroke(graphics2D, stroke, this.stroke != null);
        LafUtils.restoreAntialias(graphics2D, object);
        if (!this.emptyTitle) {
            graphics2D.setPaint(this.foreground != null ? this.foreground : ((Component)e).getForeground());
            switch (this.titleSide) {
                case 1: 
                case 3: {
                    Map map = SwingUtils.setupTextAntialias(graphics2D, e);
                    graphics2D.drawString(this.titleText, this.titleX, this.titleY);
                    SwingUtils.restoreTextAntialias(graphics2D, map);
                    break;
                }
            }
        }
    }

    public int getTitleX(E e) {
        boolean bl = ((Component)e).getComponentOrientation().isLeftToRight();
        if (this.titleAlignment == 2 || this.titleAlignment == 10 && bl || this.titleAlignment == 11 && !bl) {
            return Math.max(this.width, this.round) + this.titleOffset + this.titleBorderGap;
        }
        if (this.titleAlignment == 4 || this.titleAlignment == 11 && bl || this.titleAlignment == 10 && !bl) {
            return this.w - Math.max(this.width, this.round) - this.titleOffset - this.titleBorderGap - this.titleWidth;
        }
        return this.w / 2 - this.titleWidth / 2;
    }

    public int getTitleY(E e) {
        int n = this.fontMetrics != null ? this.fontMetrics.getDescent() : 0;
        switch (this.titleSide) {
            case 1: {
                return this.titlePosition.equals((Object)TitlePosition.aboveLive) ? this.titleAreaHeight - this.width - n : this.titleAreaHeight - n;
            }
            case 3: {
                return this.titlePosition.equals((Object)TitlePosition.belowLine) ? this.h - this.width - n : this.h - n;
            }
            case 2: {
                break;
            }
        }
        return 0;
    }

    private double getBorderPosition() {
        if (this.emptyTitle) {
            return this.borderCenter;
        }
        if (this.titlePosition.equals((Object)TitlePosition.onLine)) {
            return (double)this.titleAreaHeight / 2.0;
        }
        if (this.titlePosition.equals((Object)TitlePosition.aboveLive)) {
            return (double)this.titleAreaHeight - this.borderCenter;
        }
        return this.borderCenter;
    }

    private int getTitleAreaHeight(E e) {
        if (this.isEmptyTitle()) {
            return this.width;
        }
        int n = ((JComponent)e).getFontMetrics(((Component)e).getFont()).getHeight();
        return this.titlePosition.equals((Object)TitlePosition.onLine) ? n : n + this.width;
    }

    private boolean isEmptyTitle() {
        return this.titleText == null;
    }

    public Shape getBorderShape(E e) {
        RectangularShape rectangularShape = null;
        switch (this.titleSide) {
            case 1: {
                rectangularShape = new Rectangle2D.Double(this.borderCenter, this.borderPosition, (double)this.w - this.borderCenter * 2.0, (double)this.h - this.borderPosition - this.borderCenter);
                break;
            }
            case 2: {
                rectangularShape = new Rectangle2D.Double(this.borderPosition, this.borderCenter, (double)this.w - this.borderPosition - this.borderCenter, (double)this.h - this.borderCenter * 2.0);
                break;
            }
            case 3: {
                rectangularShape = new Rectangle2D.Double(this.borderCenter, this.borderCenter, (double)this.w - this.borderCenter * 2.0, (double)this.h - this.borderPosition - this.borderCenter);
                break;
            }
            case 4: {
                rectangularShape = new Rectangle2D.Double(this.borderCenter, this.borderCenter, (double)this.w - this.borderPosition - this.borderCenter, (double)this.h - this.borderCenter * 2.0);
            }
        }
        return this.round > 0 ? new RoundRectangle2D.Double(((RectangularShape)rectangularShape).getX(), ((RectangularShape)rectangularShape).getY(), ((RectangularShape)rectangularShape).getWidth(), ((RectangularShape)rectangularShape).getHeight(), this.round * 2, this.round * 2) : rectangularShape;
    }

    public Shape getBorderClipShape(E e) {
        if (this.emptyTitle) {
            return null;
        }
        switch (this.titleSide) {
            case 1: {
                return new RoundRectangle2D.Double(this.titleX - this.titleBorderGap, this.borderPosition - (double)(this.titleAreaHeight / 2), this.titleWidth + this.titleBorderGap * 2, this.titleAreaHeight, 3.0, 3.0);
            }
            case 3: {
                return new RoundRectangle2D.Double(this.titleX - this.titleBorderGap, (double)this.h - this.borderPosition - (double)(this.titleAreaHeight / 2), this.titleWidth + this.titleBorderGap * 2, this.titleAreaHeight, 3.0, 3.0);
            }
            case 2: {
                return null;
            }
            case 4: {
                return null;
            }
        }
        return null;
    }
}

