/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.painter;

import com.alee.extended.painter.AlphaLayerPainterStyle;
import com.alee.extended.painter.DefaultPainter;
import com.alee.utils.LafUtils;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.JComponent;

public class AlphaLayerPainter<E extends JComponent>
extends DefaultPainter<E> {
    protected int squareSize = AlphaLayerPainterStyle.squareSize;
    protected Color lightSquareColor = AlphaLayerPainterStyle.lightSquareColor;
    protected Color darkSquareColor = AlphaLayerPainterStyle.darkSquareColor;

    public AlphaLayerPainter() {
    }

    public AlphaLayerPainter(int n) {
        this.setSquareSize(n);
    }

    public AlphaLayerPainter(Color color, Color color2) {
        this.setLightSquareColor(color);
        this.setDarkSquareColor(color2);
    }

    public AlphaLayerPainter(int n, Color color, Color color2) {
        this.setSquareSize(n);
        this.setLightSquareColor(color);
        this.setDarkSquareColor(color2);
    }

    public int getSquareSize() {
        return this.squareSize;
    }

    public void setSquareSize(int n) {
        this.squareSize = n;
    }

    public Color getLightSquareColor() {
        return this.lightSquareColor;
    }

    public void setLightSquareColor(Color color) {
        this.lightSquareColor = color;
    }

    public Color getDarkSquareColor() {
        return this.darkSquareColor;
    }

    public void setDarkSquareColor(Color color) {
        this.darkSquareColor = color;
    }

    @Override
    public boolean isOpaque(E e) {
        return true;
    }

    @Override
    public void paint(Graphics2D graphics2D, Rectangle rectangle, E e) {
        LafUtils.drawAlphaLayer(graphics2D, rectangle.x, rectangle.y, rectangle.width, rectangle.height, this.squareSize, this.lightSquareColor, this.darkSquareColor);
    }
}

