/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;

public class VerticalFlowLayout
extends FlowLayout {
    int hgap;
    int vgap;
    boolean hfill;
    boolean vfill;
    public static final int TOP = 0;
    public static final int MIDDLE = 1;
    public static final int BOTTOM = 2;

    public VerticalFlowLayout() {
        this(0, 0, 0, true, false);
    }

    public VerticalFlowLayout(boolean bl, boolean bl2) {
        this(0, 0, 0, bl, bl2);
    }

    public VerticalFlowLayout(int n, int n2) {
        this(0, n, n2, true, false);
    }

    public VerticalFlowLayout(int n, int n2, int n3) {
        this(n, n2, n3, true, false);
    }

    public VerticalFlowLayout(int n) {
        this(n, 0, 0, true, false);
    }

    public VerticalFlowLayout(int n, boolean bl, boolean bl2) {
        this(n, 0, 0, bl, bl2);
    }

    public VerticalFlowLayout(int n, int n2, int n3, boolean bl, boolean bl2) {
        this.setAlignment(n);
        this.hgap = n2;
        this.vgap = n3;
        this.hfill = bl;
        this.vfill = bl2;
    }

    @Override
    public void setHgap(int n) {
        super.setHgap(n);
        this.hgap = n;
    }

    @Override
    public void setVgap(int n) {
        super.setVgap(n);
        this.vgap = n;
    }

    public void setVerticalFill(boolean bl) {
        this.vfill = bl;
    }

    public void setHorizontalFill(boolean bl) {
        this.hfill = bl;
    }

    @Override
    public int getHgap() {
        return this.hgap;
    }

    @Override
    public int getVgap() {
        return this.vgap;
    }

    public boolean getVerticalFill() {
        return this.vfill;
    }

    public boolean getHorizontalFill() {
        return this.hfill;
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        Dimension dimension = new Dimension(0, 0);
        for (int i = 0; i < container.getComponentCount(); ++i) {
            Component component = container.getComponent(i);
            if (!component.isVisible()) continue;
            Dimension dimension2 = component.getPreferredSize();
            dimension.width = Math.max(dimension.width, dimension2.width);
            if (i > 0) {
                dimension.height += this.vgap;
            }
            dimension.height += dimension2.height;
        }
        Insets insets = container.getInsets();
        dimension.width += insets.left + insets.right;
        dimension.height += insets.top + insets.bottom;
        return dimension;
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        Dimension dimension = new Dimension(0, 0);
        for (int i = 0; i < container.getComponentCount(); ++i) {
            Component component = container.getComponent(i);
            if (!component.isVisible()) continue;
            Dimension dimension2 = component.getMinimumSize();
            dimension.width = Math.max(dimension.width, dimension2.width);
            if (i > 0) {
                dimension.height += this.vgap;
            }
            dimension.height += dimension2.height;
        }
        Insets insets = container.getInsets();
        dimension.width += insets.left + insets.right;
        dimension.height += insets.top + insets.bottom;
        return dimension;
    }

    @Override
    public void layoutContainer(Container container) {
        Insets insets = container.getInsets();
        int n = container.getSize().height - (insets.top + insets.bottom);
        int n2 = container.getSize().width - (insets.left + insets.right);
        int n3 = container.getComponentCount();
        int n4 = insets.left;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        for (int i = 0; i < n3; ++i) {
            Component component = container.getComponent(i);
            if (!component.isVisible()) continue;
            Dimension dimension = component.getPreferredSize();
            if (this.vfill && i == n3 - 1) {
                dimension.height = Math.max(n - n5, component.getPreferredSize().height);
            }
            if (this.hfill) {
                component.setSize(n2, dimension.height);
                dimension.width = n2;
            } else {
                component.setSize(dimension.width, dimension.height);
            }
            if (n5 + dimension.height > n) {
                this.placethem(container, n4, insets.top, n6, n - n5, n7, i);
                n5 = dimension.height;
                n4 += this.hgap + n6;
                n6 = dimension.width;
                n7 = i;
                continue;
            }
            if (n5 > 0) {
                n5 += this.vgap;
            }
            n5 += dimension.height;
            n6 = Math.max(n6, dimension.width);
        }
        this.placethem(container, n4, insets.top, n6, n - n5, n7, n3);
    }

    private void placethem(Container container, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = this.getAlignment();
        if (n7 == 1) {
            n2 += n4 / 2;
        }
        if (n7 == 2) {
            n2 += n4;
        }
        for (int i = n5; i < n6; ++i) {
            Component component = container.getComponent(i);
            Dimension dimension = component.getSize();
            if (!component.isVisible()) continue;
            int n8 = n + (n3 - dimension.width) / 2;
            component.setLocation(n8, n2);
            n2 += this.vgap + dimension.height;
        }
    }
}

