/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.filefilter;

import com.alee.extended.filefilter.DefaultFileFilter;
import com.alee.extended.filefilter.GroupType;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.ImageIcon;

public class GroupedFileFilter
extends DefaultFileFilter {
    private GroupType groupType;
    private DefaultFileFilter defaultFilter;
    private List<FileFilter> filters;

    public GroupedFileFilter(GroupType groupType, FileFilter ... fileFilterArray) {
        this.groupType = groupType;
        this.defaultFilter = fileFilterArray != null && fileFilterArray.length > 0 && fileFilterArray[0] instanceof DefaultFileFilter ? (DefaultFileFilter)fileFilterArray[0] : null;
        this.filters = new ArrayList<FileFilter>();
        if (fileFilterArray != null) {
            Collections.addAll(this.filters, fileFilterArray);
        }
    }

    @Override
    public ImageIcon getIcon() {
        return this.defaultFilter != null ? this.defaultFilter.getIcon() : null;
    }

    @Override
    public String getDescription() {
        return this.defaultFilter != null ? this.defaultFilter.getDescription() : null;
    }

    @Override
    public boolean accept(File file) {
        if (this.groupType.equals((Object)GroupType.AND)) {
            for (FileFilter fileFilter : this.filters) {
                if (fileFilter == null || fileFilter.accept(file)) continue;
                return false;
            }
            return true;
        }
        for (FileFilter fileFilter : this.filters) {
            if (fileFilter != null && !fileFilter.accept(file)) continue;
            return true;
        }
        return false;
    }
}

