/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.filechooser;

import com.alee.extended.filechooser.FileChooserListener;
import com.alee.extended.filechooser.FilesToChoose;
import com.alee.extended.filechooser.SelectionMode;
import com.alee.extended.filechooser.WebFileChooserPanel;
import com.alee.extended.filefilter.DefaultFileFilter;
import com.alee.extended.painter.Painter;
import com.alee.laf.rootpane.WebDialog;
import com.alee.managers.hotkey.Hotkey;
import com.alee.managers.hotkey.HotkeyCondition;
import com.alee.managers.hotkey.HotkeyManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;

public class WebFileChooser
extends WebDialog {
    private static final ImageIcon ICON = new ImageIcon(WebFileChooser.class.getResource("icons/file_icon.png"));
    private ActionListener okListener;
    private WebFileChooserPanel fileChooserPanel;
    private int result = -2;

    public WebFileChooser(Window window) {
        this(window, (String)null);
    }

    public WebFileChooser(Window window, String string) {
        super(window, string != null ? string : "");
        this.setIconImage(ICON.getImage());
        if (string == null) {
            this.setLanguage("weblaf.filechooser.title", new Object[0]);
        }
        HotkeyManager.installShowAllHotkeysAction(this, Hotkey.F1);
        this.getContentPane().setBackground(Color.WHITE);
        this.getContentPane().setLayout(new BorderLayout());
        this.fileChooserPanel = new WebFileChooserPanel(true);
        this.fileChooserPanel.setOkListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WebFileChooser.this.result = 0;
                WebFileChooser.this.dispose();
                if (WebFileChooser.this.okListener != null) {
                    WebFileChooser.this.okListener.actionPerformed(actionEvent);
                }
            }
        });
        this.fileChooserPanel.setCancelListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WebFileChooser.this.result = 1;
                WebFileChooser.this.dispose();
            }
        });
        this.getContentPane().add((Component)this.fileChooserPanel, "Center");
        HotkeyManager.addContainerHotkeyCondition(this, new HotkeyCondition(){

            @Override
            public boolean checkCondition(Component component) {
                return WebFileChooser.this.fileChooserPanel.allowHotkeys();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                WebFileChooser.this.result = -1;
            }
        });
        this.setModal(true);
        this.pack();
        this.setDefaultCloseOperation(2);
    }

    public int getResult() {
        return this.result;
    }

    public int showDialog() {
        this.setVisible(true);
        return this.getResult();
    }

    public static List<File> showDialog(Window window) {
        return WebFileChooser.showDialog(window, null);
    }

    public static List<File> showDialog(Window window, String string) {
        WebFileChooser webFileChooser = new WebFileChooser(window, string);
        webFileChooser.setVisible(true);
        if (webFileChooser.getResult() == 0) {
            return webFileChooser.getSelectedFiles();
        }
        return null;
    }

    public WebFileChooserPanel getFileChooserPanel() {
        return this.fileChooserPanel;
    }

    public void addFileChooserListener(FileChooserListener fileChooserListener) {
        this.fileChooserPanel.addFileChooserListener(fileChooserListener);
    }

    public void removeFileChooserListener(FileChooserListener fileChooserListener) {
        this.fileChooserPanel.removeFileChooserListener(fileChooserListener);
    }

    public Painter getPainter() {
        return this.fileChooserPanel.getPainter();
    }

    public void setPainter(Painter painter) {
        this.fileChooserPanel.setPainter(painter);
    }

    public void setCurrentDirectory(String string) {
        this.fileChooserPanel.setCurrentDirectory(string);
    }

    public void setCurrentDirectory(File file) {
        this.fileChooserPanel.setCurrentDirectory(file);
    }

    public File getCurrentDirectory() {
        return this.fileChooserPanel.getCurrentDirectory();
    }

    public SelectionMode getSelectionMode() {
        return this.fileChooserPanel.getSelectionMode();
    }

    public void setSelectionMode(SelectionMode selectionMode) {
        this.fileChooserPanel.setSelectionMode(selectionMode);
    }

    public FilesToChoose getFilesToChoose() {
        return this.fileChooserPanel.getFilesToChoose();
    }

    public void setFilesToChoose(FilesToChoose filesToChoose) {
        this.fileChooserPanel.setFilesToChoose(filesToChoose);
    }

    public List<DefaultFileFilter> getAvailableFilters() {
        return this.fileChooserPanel.getAvailableFilters();
    }

    public void setAvailableFilter(DefaultFileFilter defaultFileFilter) {
        ArrayList<DefaultFileFilter> arrayList = new ArrayList<DefaultFileFilter>();
        arrayList.add(defaultFileFilter);
        this.setAvailableFilters(arrayList);
    }

    public void setAvailableFilters(List<DefaultFileFilter> list) {
        if (list.size() == 1) {
            this.setIconImage(list.get(0).getIcon().getImage());
        }
        this.fileChooserPanel.setAvailableFilters(list);
    }

    public ActionListener getOkListener() {
        return this.okListener;
    }

    public void setOkListener(ActionListener actionListener) {
        this.okListener = actionListener;
    }

    public DefaultFileFilter getPreviewFilter() {
        return this.fileChooserPanel.getPreviewFilter();
    }

    public void setPreviewFilter(DefaultFileFilter defaultFileFilter) {
        this.fileChooserPanel.setPreviewFilter(defaultFileFilter);
    }

    public DefaultFileFilter getChooseFilter() {
        return this.fileChooserPanel.getChooseFilter();
    }

    public void setChooseFilter(DefaultFileFilter defaultFileFilter) {
        this.fileChooserPanel.setChooseFilter(defaultFileFilter);
    }

    public List<File> getSelectedFiles() {
        return this.fileChooserPanel.getSelectedFiles();
    }

    public File getSelectedFile() {
        List<File> list = this.getSelectedFiles();
        return list != null && list.size() > 0 ? list.get(0) : null;
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            this.result = -2;
            this.setLocationRelativeTo(this.getOwner());
        }
        super.setVisible(bl);
    }
}

