/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.dock;

import com.alee.extended.dock.DockingPaneConstants;
import com.alee.extended.dock.DockingPaneLayout;
import com.alee.utils.swing.ZOrderComparator;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class DockingPaneInfo
implements DockingPaneConstants {
    private static final ZOrderComparator comparator = new ZOrderComparator();
    private static final int initialCalcArraysSize = 2;
    public Map<Component, String> constraints;
    public Insets buttonsMargin;
    public int buttonSpacing;
    public int buttonSidesSpacing;
    public Insets framesMargin;
    public Insets contentMargin;
    public Insets margin;
    public Rectangle rect;
    public boolean hasTopButtons;
    public List<Component> topLeftButtons;
    public Dimension topLeftButtonsSize;
    public List<Component> topRightButtons;
    public Dimension topRightButtonsSize;
    public Dimension topButtonsSize;
    public Rectangle topButtonsPaneBounds;
    public boolean hasLeftButtons;
    public List<Component> leftTopButtons;
    public Dimension leftTopButtonsSize;
    public List<Component> leftBottomButtons;
    public Dimension leftBottomButtonsSize;
    public Dimension leftButtonsSize;
    public Rectangle leftButtonsPaneBounds;
    public boolean hasRightButtons;
    public List<Component> rightTopButtons;
    public Dimension rightTopButtonsSize;
    public List<Component> rightBottomButtons;
    public Dimension rightBottomButtonsSize;
    public Dimension rightButtonsSize;
    public Rectangle rightButtonsPaneBounds;
    public boolean hasBottomButtons;
    public List<Component> bottomLeftButtons;
    public Dimension bottomLeftButtonsSize;
    public List<Component> bottomRightButtons;
    public Dimension bottomRightButtonsSize;
    public Dimension bottomButtonsSize;
    public Rectangle bottomButtonsPaneBounds;
    public Component topFrame;
    public Rectangle topFrameBounds;
    public Component leftFrame;
    public Rectangle leftFrameBounds;
    public Component rightFrame;
    public Rectangle rightFrameBounds;
    public Component bottomFrame;
    public Rectangle bottomFrameBounds;
    public Component content;
    public Rectangle contentBounds;

    public DockingPaneInfo(DockingPaneLayout dockingPaneLayout, Container container) {
        this.constraints = dockingPaneLayout.getConstraints();
        this.buttonsMargin = dockingPaneLayout.getButtonsMargin();
        this.buttonSpacing = dockingPaneLayout.getButtonSpacing();
        this.buttonSidesSpacing = dockingPaneLayout.getButtonSidesSpacing();
        this.framesMargin = dockingPaneLayout.getFramesMargin();
        this.contentMargin = dockingPaneLayout.getContentMargin();
        this.margin = container.getInsets();
        this.rect = new Rectangle(this.margin.left, this.margin.top, container.getWidth() - this.margin.left - this.margin.right, container.getHeight() - this.margin.top - this.margin.bottom);
        this.topLeftButtons = new ArrayList<Component>(2);
        this.topRightButtons = new ArrayList<Component>(2);
        this.leftTopButtons = new ArrayList<Component>(2);
        this.leftBottomButtons = new ArrayList<Component>(2);
        this.rightTopButtons = new ArrayList<Component>(2);
        this.rightBottomButtons = new ArrayList<Component>(2);
        this.bottomLeftButtons = new ArrayList<Component>(2);
        this.bottomRightButtons = new ArrayList<Component>(2);
        this.topFrame = null;
        this.leftFrame = null;
        this.rightFrame = null;
        this.bottomFrame = null;
        this.content = null;
        for (Component component : this.constraints.keySet()) {
            if (this.constraints.get(component).equals("TOP_LEFT")) {
                this.topLeftButtons.add(component);
                continue;
            }
            if (this.constraints.get(component).equals("TOP_RIGHT")) {
                this.topRightButtons.add(component);
                continue;
            }
            if (this.constraints.get(component).equals("LEFT_TOP")) {
                this.leftTopButtons.add(component);
                continue;
            }
            if (this.constraints.get(component).equals("LEFT_BOTTOM")) {
                this.leftBottomButtons.add(component);
                continue;
            }
            if (this.constraints.get(component).equals("RIGHT_TOP")) {
                this.rightTopButtons.add(component);
                continue;
            }
            if (this.constraints.get(component).equals("RIGHT_BOTTOM")) {
                this.rightBottomButtons.add(component);
                continue;
            }
            if (this.constraints.get(component).equals("BOTTOM_LEFT")) {
                this.bottomLeftButtons.add(component);
                continue;
            }
            if (this.constraints.get(component).equals("BOTTOM_RIGHT")) {
                this.bottomRightButtons.add(component);
                continue;
            }
            if (this.constraints.get(component).equals("TOP_FRAME")) {
                this.topFrame = component;
                continue;
            }
            if (this.constraints.get(component).equals("LEFT_FRAME")) {
                this.leftFrame = component;
                continue;
            }
            if (this.constraints.get(component).equals("RIGHT_FRAME")) {
                this.rightFrame = component;
                continue;
            }
            if (this.constraints.get(component).equals("BOTTOM_FRAME")) {
                this.bottomFrame = component;
                continue;
            }
            if (!this.constraints.get(component).equals("CONTENT")) continue;
            this.content = component;
        }
        Collections.sort(this.topLeftButtons, comparator);
        Collections.sort(this.topRightButtons, comparator);
        Collections.sort(this.leftTopButtons, comparator);
        Collections.sort(this.leftBottomButtons, comparator);
        Collections.sort(this.rightTopButtons, comparator);
        Collections.sort(this.rightBottomButtons, comparator);
        Collections.sort(this.bottomLeftButtons, comparator);
        Collections.sort(this.bottomRightButtons, comparator);
        boolean bl = this.topLeftButtons.size() > 0 && this.topRightButtons.size() > 0;
        this.hasTopButtons = this.topLeftButtons.size() > 0 || this.topRightButtons.size() > 0;
        this.topLeftButtonsSize = this.hasTopButtons ? this.getSideSize("TOP_LEFT", this.topLeftButtons) : new Dimension(0, 0);
        Dimension dimension = this.topRightButtonsSize = this.hasTopButtons ? this.getSideSize("TOP_RIGHT", this.topRightButtons) : new Dimension(0, 0);
        this.topButtonsSize = this.hasTopButtons ? new Dimension(this.topLeftButtonsSize.width + (bl ? this.buttonSidesSpacing : 0) + this.topRightButtonsSize.width, Math.max(this.topLeftButtonsSize.height, this.topRightButtonsSize.height)) : new Dimension(0, 0);
        bl = this.leftTopButtons.size() > 0 && this.leftBottomButtons.size() > 0;
        this.hasLeftButtons = this.leftTopButtons.size() > 0 || this.leftBottomButtons.size() > 0;
        this.leftTopButtonsSize = this.hasLeftButtons ? this.getSideSize("LEFT_TOP", this.leftTopButtons) : new Dimension(0, 0);
        Dimension dimension2 = this.leftBottomButtonsSize = this.hasLeftButtons ? this.getSideSize("LEFT_BOTTOM", this.leftBottomButtons) : new Dimension(0, 0);
        this.leftButtonsSize = this.hasLeftButtons ? new Dimension(Math.max(this.leftTopButtonsSize.width, this.leftBottomButtonsSize.width), this.leftTopButtonsSize.height + (bl ? this.buttonSidesSpacing : 0) + this.leftBottomButtonsSize.height) : new Dimension(0, 0);
        bl = this.rightTopButtons.size() > 0 && this.rightBottomButtons.size() > 0;
        this.hasRightButtons = this.rightTopButtons.size() > 0 || this.rightBottomButtons.size() > 0;
        this.rightTopButtonsSize = this.hasRightButtons ? this.getSideSize("LEFT_TOP", this.rightTopButtons) : new Dimension(0, 0);
        Dimension dimension3 = this.rightBottomButtonsSize = this.hasRightButtons ? this.getSideSize("LEFT_BOTTOM", this.rightBottomButtons) : new Dimension(0, 0);
        this.rightButtonsSize = this.hasRightButtons ? new Dimension(Math.max(this.rightTopButtonsSize.width, this.rightBottomButtonsSize.width), this.rightTopButtonsSize.height + (bl ? this.buttonSidesSpacing : 0) + this.rightBottomButtonsSize.height) : new Dimension(0, 0);
        bl = this.bottomLeftButtons.size() > 0 && this.bottomRightButtons.size() > 0;
        this.hasBottomButtons = this.bottomLeftButtons.size() > 0 || this.bottomRightButtons.size() > 0;
        this.bottomLeftButtonsSize = this.hasBottomButtons ? this.getSideSize("BOTTOM_LEFT", this.bottomLeftButtons) : new Dimension(0, 0);
        Dimension dimension4 = this.bottomRightButtonsSize = this.hasBottomButtons ? this.getSideSize("BOTTOM_RIGHT", this.bottomRightButtons) : new Dimension(0, 0);
        this.bottomButtonsSize = this.hasBottomButtons ? new Dimension(this.bottomLeftButtonsSize.width + (bl ? this.buttonSidesSpacing : 0) + this.bottomRightButtonsSize.width, Math.max(this.bottomLeftButtonsSize.height, this.bottomRightButtonsSize.height)) : new Dimension(0, 0);
        this.updateBounds();
    }

    public void updateBounds() {
        this.topButtonsPaneBounds = this.hasTopButtons ? new Rectangle(this.rect.x, this.rect.y, this.rect.width, this.buttonsMargin.top + this.topButtonsSize.height + this.buttonsMargin.bottom) : new Rectangle(0, 0);
        this.bottomButtonsPaneBounds = this.hasBottomButtons ? new Rectangle(this.rect.x, this.rect.y + this.rect.height - this.buttonsMargin.top - this.bottomButtonsSize.height - this.buttonsMargin.bottom, this.rect.width, this.buttonsMargin.top + this.bottomButtonsSize.height + this.buttonsMargin.bottom) : new Rectangle(0, 0);
        this.leftButtonsPaneBounds = this.hasLeftButtons ? new Rectangle(this.rect.x, this.rect.y + this.topButtonsPaneBounds.height, this.buttonsMargin.left + this.leftButtonsSize.width + this.buttonsMargin.right, this.rect.height - this.topButtonsPaneBounds.height - this.bottomButtonsPaneBounds.height) : new Rectangle(0, 0);
        this.rightButtonsPaneBounds = this.hasRightButtons ? new Rectangle(this.rect.x + this.rect.width - this.buttonsMargin.left - this.rightButtonsSize.width - this.buttonsMargin.right, this.rect.y + this.topButtonsPaneBounds.height, this.buttonsMargin.left + this.rightButtonsSize.width + this.buttonsMargin.right, this.rect.height - this.topButtonsPaneBounds.height - this.bottomButtonsPaneBounds.height) : new Rectangle(0, 0);
        int n = (this.hasTopButtons ? 1 : 0) + this.framesMargin.top;
        int n2 = (this.hasLeftButtons ? 1 : 0) + this.framesMargin.left;
        int n3 = (this.hasRightButtons ? 1 : 0) + this.framesMargin.right;
        int n4 = (this.hasBottomButtons ? 1 : 0) + this.framesMargin.bottom;
        Dimension dimension = this.topFrame != null ? this.topFrame.getPreferredSize() : null;
        this.topFrameBounds = this.topFrame != null ? new Rectangle(this.rect.x + this.leftButtonsPaneBounds.width + n2, this.rect.y + this.topButtonsPaneBounds.height + n, this.rect.width - this.leftButtonsPaneBounds.width - this.rightButtonsPaneBounds.width - n2 - n3, dimension.height) : new Rectangle(0, 0);
        Dimension dimension2 = this.bottomFrame != null ? this.bottomFrame.getPreferredSize() : null;
        this.bottomFrameBounds = this.bottomFrame != null ? new Rectangle(this.rect.x + this.leftButtonsPaneBounds.width + n2, this.rect.y + this.rect.height - this.bottomButtonsPaneBounds.height - n4 - dimension2.height, this.rect.width - this.leftButtonsPaneBounds.width - this.rightButtonsPaneBounds.width - n2 - n3, dimension2.height) : new Rectangle(0, 0);
        Dimension dimension3 = this.leftFrame != null ? this.leftFrame.getPreferredSize() : null;
        this.leftFrameBounds = this.leftFrame != null ? new Rectangle(this.rect.x + this.leftButtonsPaneBounds.width + n2, this.rect.y + this.topButtonsPaneBounds.height + n + this.topFrameBounds.height, dimension3.width, this.rect.height - this.topButtonsPaneBounds.height - n - this.topFrameBounds.height - this.bottomButtonsPaneBounds.height - n4 - this.bottomFrameBounds.height) : new Rectangle(0, 0);
        Dimension dimension4 = this.rightFrame != null ? this.rightFrame.getPreferredSize() : null;
        this.rightFrameBounds = this.rightFrame != null ? new Rectangle(this.rect.x + this.rect.width - this.rightButtonsPaneBounds.width - n3 - dimension4.width, this.rect.y + this.topButtonsPaneBounds.height + n + this.topFrameBounds.height, dimension4.width, this.rect.height - this.topButtonsPaneBounds.height - n - this.topFrameBounds.height - this.bottomButtonsPaneBounds.height - n4 - this.bottomFrameBounds.height) : new Rectangle(0, 0);
        this.contentBounds = this.content != null ? new Rectangle(this.rect.x + this.leftButtonsPaneBounds.width + n2 + this.leftFrameBounds.width + this.contentMargin.left, this.rect.y + this.topButtonsPaneBounds.height + n + this.topFrameBounds.height + this.contentMargin.top, this.rect.width - this.leftButtonsPaneBounds.width - this.rightButtonsPaneBounds.width - n2 - n3 - this.leftFrameBounds.width - this.rightFrameBounds.width - this.contentMargin.left - this.contentMargin.right, this.rect.height - this.topButtonsPaneBounds.height - this.bottomButtonsPaneBounds.height - n - n4 - this.topFrameBounds.height - this.bottomFrameBounds.height - this.contentMargin.top - this.contentMargin.bottom) : null;
    }

    private Dimension getSideSize(String string, List<Component> list) {
        Dimension dimension = new Dimension(0, 0);
        if (string.startsWith("TOP") || string.startsWith("BOTTOM")) {
            for (Component component : list) {
                Dimension dimension2 = component.getPreferredSize();
                dimension.width += dimension2.width + this.buttonSpacing;
                dimension.height = Math.max(dimension.height, dimension2.height);
            }
            if (list.size() > 0) {
                dimension.width -= this.buttonSpacing;
            }
        } else {
            for (Component component : list) {
                Dimension dimension3 = component.getPreferredSize();
                dimension.height += dimension3.height + this.buttonSpacing;
                dimension.width = Math.max(dimension.width, dimension3.width);
            }
            if (list.size() > 0) {
                dimension.height -= this.buttonSpacing;
            }
        }
        return dimension;
    }
}

