/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.colorchooser;

import com.alee.laf.colorchooser.HSBColor;
import com.alee.laf.panel.WebPanel;
import com.alee.utils.SwingUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Map;
import javax.swing.SwingUtilities;

public class DoubleColorField
extends WebPanel {
    private Color newColor;
    private Color oldColor;
    private HSBColor newHSBColor;
    private HSBColor oldHSBColor;

    public DoubleColorField() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getY() >= DoubleColorField.this.getHeight() / 2) {
                    DoubleColorField.this.oldColorPressed();
                }
            }
        });
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        Map map = SwingUtils.setupTextAntialias(graphics2D, (Component)this);
        graphics2D.setPaint(Color.GRAY);
        graphics2D.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        graphics2D.setPaint(Color.WHITE);
        graphics2D.drawRect(1, 1, this.getWidth() - 3, this.getHeight() - 3);
        graphics2D.setPaint(this.newColor);
        graphics2D.fillRect(2, 2, this.getWidth() - 4, this.getHeight() / 2 - 2);
        graphics2D.setPaint(this.newHSBColor.getBrightness() >= 0.7f && this.newHSBColor.getSaturation() < 0.7f ? Color.BLACK : Color.WHITE);
        graphics2D.drawString("new", this.getWidth() / 2 - fontMetrics.stringWidth("new") / 2, (this.getHeight() - 4) / 4 + fontMetrics.getAscent() / 2);
        graphics2D.setPaint(this.oldColor);
        graphics2D.fillRect(2, this.getHeight() / 2, this.getWidth() - 4, this.getHeight() - this.getHeight() / 2 - 2);
        graphics2D.setPaint(this.oldHSBColor.getBrightness() >= 0.7f && this.oldHSBColor.getSaturation() < 0.7f ? Color.BLACK : Color.WHITE);
        graphics2D.drawString("current", this.getWidth() / 2 - fontMetrics.stringWidth("current") / 2, (this.getHeight() - 4) * 3 / 4 + fontMetrics.getAscent() / 2);
        SwingUtils.restoreTextAntialias(graphics2D, map);
    }

    public Color getNewColor() {
        return this.newColor;
    }

    public void setNewColor(Color color) {
        this.newColor = color;
        this.newHSBColor = new HSBColor(color);
        this.repaint();
    }

    public Color getOldColor() {
        return this.oldColor;
    }

    public void setOldColor(Color color) {
        this.oldColor = color;
        this.oldHSBColor = new HSBColor(color);
        this.repaint();
    }

    protected void oldColorPressed() {
    }
}

