/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.button;

import com.alee.extended.button.WebSwitchGripper;
import com.alee.extended.button.WebSwitchLayout;
import com.alee.extended.button.WebSwitchStyle;
import com.alee.laf.StyleConstants;
import com.alee.laf.label.WebLabel;
import com.alee.laf.panel.WebPanel;
import com.alee.utils.CollectionUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.swing.Timer;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;

public class WebSwitch
extends WebPanel {
    private List<ActionListener> actionListeners = new ArrayList<ActionListener>();
    private boolean animate = WebSwitchStyle.animate;
    private boolean selected = false;
    private boolean animating = false;
    private Timer animator;
    private WebSwitchGripper gripper;
    private WebLabel leftComponent;
    private WebLabel rightComponent;

    public WebSwitch() {
        this(false);
    }

    public WebSwitch(boolean bl) {
        super(true, new WebSwitchLayout());
        this.putClientProperty("HANDLES_ENABLE_STATE", true);
        this.setRound(WebSwitchStyle.round);
        this.setDrawFocus(true);
        this.setFocusable(true);
        this.gripper = new WebSwitchGripper();
        this.add((Component)this.gripper, (Object)"GRIPPER");
        this.leftComponent = new WebLabel("ON", 0);
        this.leftComponent.setMargin(2, 5, 2, 5);
        this.leftComponent.setDrawShade(true);
        this.leftComponent.setForeground(Color.DARK_GRAY);
        this.add((Component)SwingUtils.setBoldFont(this.leftComponent), (Object)"LEFT");
        this.rightComponent = new WebLabel("OFF", 0);
        this.rightComponent.setMargin(2, 5, 2, 5);
        this.rightComponent.setDrawShade(true);
        this.rightComponent.setForeground(Color.DARK_GRAY);
        this.add((Component)SwingUtils.setBoldFont(this.rightComponent), (Object)"RIGHT");
        this.createAnimator();
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (SwingUtils.isLeftMouseButton(mouseEvent) && WebSwitch.this.isEnabled()) {
                    WebSwitch.this.requestFocusInWindow();
                    WebSwitch.this.setSelected(!WebSwitch.this.isSelected());
                }
            }
        };
        this.gripper.addMouseListener(mouseAdapter);
        this.addMouseListener(mouseAdapter);
        this.setSelected(bl, false);
    }

    private void createAnimator() {
        this.animator = new Timer("WebSwitch.animator", (long)StyleConstants.maxAnimationDelay, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WebSwitchLayout webSwitchLayout = WebSwitch.this.getSwitchLayout();
                webSwitchLayout.setGripperLocation(webSwitchLayout.getGripperLocation() + (WebSwitch.this.selected ? 0.1f : -0.1f));
                if (WebSwitch.this.selected && webSwitchLayout.getGripperLocation() >= 1.0f || !WebSwitch.this.selected && webSwitchLayout.getGripperLocation() <= 0.0f) {
                    webSwitchLayout.setGripperLocation(WebSwitch.this.selected ? 1.0f : 0.0f);
                    WebSwitch.this.revalidate();
                    WebSwitch.this.animating = false;
                    WebSwitch.this.animator.stop();
                } else {
                    WebSwitch.this.revalidate();
                }
            }
        });
    }

    private void startAnimation() {
        if (!this.animating) {
            this.animating = true;
            this.animator.start();
        }
    }

    public WebSwitchLayout getSwitchLayout() {
        return (WebSwitchLayout)this.getLayout();
    }

    public WebSwitchGripper getGripper() {
        return this.gripper;
    }

    public WebLabel getLeftComponent() {
        return this.leftComponent;
    }

    public void setLeftComponent(WebLabel webLabel) {
        if (this.leftComponent != null) {
            this.remove(this.leftComponent);
        }
        this.leftComponent = webLabel;
        this.add((Component)webLabel, (Object)"LEFT");
        this.revalidate();
    }

    public WebLabel getRightComponent() {
        return this.rightComponent;
    }

    public void setRightComponent(WebLabel webLabel) {
        if (this.rightComponent != null) {
            this.remove(this.rightComponent);
        }
        this.rightComponent = webLabel;
        this.add((Component)webLabel, (Object)"RIGHT");
        this.revalidate();
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.gripper.setEnabled(bl);
        this.leftComponent.setEnabled(bl);
        this.rightComponent.setEnabled(bl);
    }

    @Override
    public void setRound(int n) {
        super.setRound(n);
        if (this.gripper != null) {
            this.gripper.setRound(Math.max(n - 3, 0));
        }
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean bl) {
        this.setSelected(bl, this.animate);
    }

    public void setSelected(boolean bl, boolean bl2) {
        this.selected = bl;
        if (bl2) {
            this.startAnimation();
        } else {
            this.getSwitchLayout().setGripperLocation(bl ? 1.0f : 0.0f);
            this.revalidate();
        }
        this.fireActionPerformed();
    }

    public boolean isAnimate() {
        return this.animate;
    }

    public void setAnimate(boolean bl) {
        this.animate = bl;
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListeners.add(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionListeners.remove(actionListener);
    }

    private void fireActionPerformed() {
        ActionEvent actionEvent = new ActionEvent(this, 0, "Selection changed");
        for (ActionListener actionListener : CollectionUtils.copy(this.actionListeners)) {
            actionListener.actionPerformed(actionEvent);
        }
    }
}

