/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.trifocal;

import boofcv.struct.geo.TrifocalTensor;
import georegression.struct.point.Point3D_F64;
import org.ejml.alg.dense.decomposition.svd.SafeSvd;
import org.ejml.data.DenseMatrix64F;
import org.ejml.data.Matrix64F;
import org.ejml.factory.DecompositionFactory;
import org.ejml.interfaces.decomposition.SingularValueDecomposition;
import org.ejml.ops.SingularOps;

public class TrifocalExtractEpipoles {
    private SingularValueDecomposition<DenseMatrix64F> svd;
    private DenseMatrix64F u1 = new DenseMatrix64F(3, 1);
    private DenseMatrix64F u2 = new DenseMatrix64F(3, 1);
    private DenseMatrix64F u3 = new DenseMatrix64F(3, 1);
    private DenseMatrix64F v1 = new DenseMatrix64F(3, 1);
    private DenseMatrix64F v2 = new DenseMatrix64F(3, 1);
    private DenseMatrix64F v3 = new DenseMatrix64F(3, 1);
    private DenseMatrix64F U = new DenseMatrix64F(3, 3);
    private DenseMatrix64F V = new DenseMatrix64F(3, 3);
    private DenseMatrix64F tempE = new DenseMatrix64F(3, 1);

    public TrifocalExtractEpipoles() {
        this.svd = DecompositionFactory.svd((int)3, (int)3, (boolean)true, (boolean)true, (boolean)true);
        this.svd = new SafeSvd(this.svd);
    }

    public void process(TrifocalTensor tensor, Point3D_F64 e2, Point3D_F64 e3) {
        this.svd.decompose((Matrix64F)tensor.T1);
        SingularOps.nullVector(this.svd, (boolean)true, (DenseMatrix64F)this.v1);
        SingularOps.nullVector(this.svd, (boolean)false, (DenseMatrix64F)this.u1);
        this.svd.decompose((Matrix64F)tensor.T2);
        SingularOps.nullVector(this.svd, (boolean)true, (DenseMatrix64F)this.v2);
        SingularOps.nullVector(this.svd, (boolean)false, (DenseMatrix64F)this.u2);
        this.svd.decompose((Matrix64F)tensor.T3);
        SingularOps.nullVector(this.svd, (boolean)true, (DenseMatrix64F)this.v3);
        SingularOps.nullVector(this.svd, (boolean)false, (DenseMatrix64F)this.u3);
        for (int i = 0; i < 3; ++i) {
            this.U.set(i, 0, this.u1.get(i));
            this.U.set(i, 1, this.u2.get(i));
            this.U.set(i, 2, this.u3.get(i));
            this.V.set(i, 0, this.v1.get(i));
            this.V.set(i, 1, this.v2.get(i));
            this.V.set(i, 2, this.v3.get(i));
        }
        this.svd.decompose((Matrix64F)this.U);
        SingularOps.nullVector(this.svd, (boolean)false, (DenseMatrix64F)this.tempE);
        e2.set(this.tempE.get(0), this.tempE.get(1), this.tempE.get(2));
        this.svd.decompose((Matrix64F)this.V);
        SingularOps.nullVector(this.svd, (boolean)false, (DenseMatrix64F)this.tempE);
        e3.set(this.tempE.get(0), this.tempE.get(1), this.tempE.get(2));
    }
}

