/*
 * Decompiled with CFR 0.152.
 */
package com.testin.javafx.ui.include;

import com.alibaba.fastjson.JSONArray;
import com.testin.itestin.business.actions.coord.q;
import com.testin.itestin.business.actions.utils.b;
import com.testin.itestin.business.actions.utils.d;
import com.testin.javafx.ui.control.EditFrameDialogController;
import com.testin.javafx.ui.include.c;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.Slider;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;

public class ImageSetController
extends AnchorPane
implements Initializable {
    @FXML
    Label warn;
    @FXML
    Slider rangeSlider;
    @FXML
    Slider unsemSlider;
    @FXML
    Slider timeoutSlider;
    @FXML
    Slider longTimeSlider;
    @FXML
    TextField longTime;
    @FXML
    TextField range;
    @FXML
    TextField unSemblance;
    @FXML
    TextField timeOut;
    @FXML
    RadioButton scrollNo;
    @FXML
    RadioButton scrollYes;
    @FXML
    ImageView image;
    @FXML
    AnchorPane imageAnchorPane;
    @FXML
    Label longTimeLabel;
    public c canvas;
    private double imageValueW;
    private double imageValueH;
    private static double mScale = 1.0;

    public void setVisableLongTime() {
        this.longTimeLabel.setVisible(false);
        this.longTime.setVisible(false);
        this.longTimeSlider.setVisible(false);
    }

    public void initialize(URL arg0, ResourceBundle arg1) {
        this.scrollYes.setSelected(true);
        this.warn.setText("");
        this.rangeSlider.valueProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> arg0, Number arg1, Number arg2) {
                ImageSetController.this.range.setText(String.format("%.3s", arg2));
            }
        });
        this.unsemSlider.valueProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> arg0, Number arg1, Number arg2) {
                ImageSetController.this.unSemblance.setText(String.format("%.4s", arg2));
            }
        });
        this.timeoutSlider.valueProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> arg0, Number arg1, Number arg2) {
                ImageSetController.this.timeOut.setText(String.format("%.2s", arg2.intValue()));
            }
        });
        this.range.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> arg0, String arg1, String arg2) {
                if (ImageSetController.this.range.getText().isEmpty()) {
                    return;
                }
                if (!d.isNumber(ImageSetController.this.range.getText()) || (double)Float.valueOf(ImageSetController.this.range.getText()).floatValue() < 1.0 || (double)Float.valueOf(ImageSetController.this.range.getText()).floatValue() > 5.0) {
                    ImageSetController.this.warn.setText(b.n("imagescriptalterdialog.check"));
                    ImageSetController.this.range.setText("1.0");
                    return;
                }
                ImageSetController.this.rangeSlider.setValue(Double.valueOf(ImageSetController.this.range.getText()).doubleValue());
            }
        });
        this.range.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!ImageSetController.this.range.isFocused() && !ImageSetController.this.range.getText().isEmpty() && d.isNumber(ImageSetController.this.range.getText())) {
                    ImageSetController.this.warn.setText("");
                }
            }
        });
        this.unSemblance.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> arg0, String arg1, String arg2) {
                if (ImageSetController.this.unSemblance.getText().isEmpty()) {
                    return;
                }
                if (!d.isNumber(ImageSetController.this.unSemblance.getText()) || (double)Float.valueOf(ImageSetController.this.unSemblance.getText()).floatValue() < 0.0 || (double)Float.valueOf(ImageSetController.this.unSemblance.getText()).floatValue() > 1.0) {
                    ImageSetController.this.warn.setText(b.n("imagescriptalterdialog.check"));
                    ImageSetController.this.unSemblance.setText("0.35");
                    return;
                }
                ImageSetController.this.unsemSlider.setValue(Double.valueOf(ImageSetController.this.unSemblance.getText()).doubleValue());
            }
        });
        this.unSemblance.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!ImageSetController.this.unSemblance.isFocused() && !ImageSetController.this.unSemblance.getText().isEmpty() && d.isNumber(ImageSetController.this.unSemblance.getText())) {
                    ImageSetController.this.warn.setText("");
                }
            }
        });
        this.timeOut.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> arg0, String arg1, String arg2) {
                if (ImageSetController.this.timeOut.getText().isEmpty()) {
                    return;
                }
                if (!d.isNumber(ImageSetController.this.timeOut.getText()) || Integer.valueOf(ImageSetController.this.timeOut.getText()) > 30) {
                    ImageSetController.this.warn.setText(b.n("controllerset.check"));
                    ImageSetController.this.timeOut.setText("30");
                    return;
                }
                ImageSetController.this.timeoutSlider.setValue(Double.valueOf(ImageSetController.this.timeOut.getText()).doubleValue());
            }
        });
        this.timeOut.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!ImageSetController.this.timeOut.isFocused() && !ImageSetController.this.timeOut.getText().isEmpty() && d.isNumber(ImageSetController.this.timeOut.getText())) {
                    ImageSetController.this.warn.setText("");
                }
            }
        });
        this.longTimeSlider.valueProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> arg0, Number arg1, Number arg2) {
                if (!ImageSetController.this.longTime.isFocused()) {
                    ImageSetController.this.longTime.setText(String.format("%.2s", arg2.intValue()));
                }
            }
        });
        this.longTime.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> arg0, String arg1, String arg2) {
                if (ImageSetController.this.longTime.getText().isEmpty()) {
                    return;
                }
                if (!(ImageSetController.this.longTime.isFocused() || d.isNumber(ImageSetController.this.longTime.getText()) && Integer.valueOf(ImageSetController.this.longTime.getText()) <= 30 && Integer.valueOf(ImageSetController.this.longTime.getText()) >= 2)) {
                    ImageSetController.this.warn.setText(b.n("controllerset.longtimecheck"));
                    ImageSetController.this.longTime.setText("2");
                    return;
                }
                if (d.isNumber(ImageSetController.this.longTime.getText())) {
                    ImageSetController.this.longTimeSlider.setValue(Double.valueOf(ImageSetController.this.longTime.getText()).doubleValue());
                }
            }
        });
        this.longTime.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!ImageSetController.this.longTime.isFocused() && !ImageSetController.this.longTime.getText().isEmpty() && d.isNumber(ImageSetController.this.longTime.getText())) {
                    ImageSetController.this.warn.setText("");
                }
                if (!(ImageSetController.this.longTime.isFocused() || d.isNumber(ImageSetController.this.longTime.getText()) && Integer.valueOf(ImageSetController.this.longTime.getText()) <= 30 && Integer.valueOf(ImageSetController.this.longTime.getText()) >= 2)) {
                    ImageSetController.this.warn.setText(b.n("controllerset.longtimecheck"));
                    ImageSetController.this.longTime.setText("2");
                }
            }
        });
    }

    @FXML
    public void yesClick(MouseEvent event) {
        if (this.scrollNo.isSelected()) {
            this.scrollNo.setSelected(false);
        }
    }

    @FXML
    public void noClick(MouseEvent event) {
        if (this.scrollYes.isSelected()) {
            this.scrollYes.setSelected(false);
        }
    }

    public float getImageRange() {
        return Float.valueOf(this.range.getText()).floatValue();
    }

    public float getImageUnSemblance() {
        return Float.valueOf(this.unSemblance.getText()).floatValue();
    }

    public int getImagetimeOut() {
        return Integer.valueOf(this.timeOut.getText()) * 1000;
    }

    public int getImageLongTime() {
        return Integer.valueOf(this.longTime.getText()) * 1000;
    }

    public Boolean getImageScroll() {
        return this.scrollYes.isSelected();
    }

    public ArrayList<q> getImagePointList() {
        return this.canvas.h();
    }

    public ArrayList<q> getOldImagePointList() {
        return this.canvas.i();
    }

    public void setImageRange(String rangeStr) {
        this.range.setText(rangeStr);
    }

    public void setImageUnSemblance(String unsem) {
        this.unSemblance.setText(unsem);
    }

    public void setImagetimeOut(String timeout) {
        this.timeOut.setText(String.valueOf(Integer.valueOf(timeout) / 1000));
    }

    public void setImageLongTime(String longtime) {
        this.longTime.setText(String.valueOf(Integer.valueOf(longtime) / 1000));
    }

    public void setImageScroll(Boolean scroll) {
        this.scrollYes.setSelected(scroll.booleanValue());
        this.scrollNo.setSelected(scroll == false);
    }

    public void setImg(String imgFile, boolean isTrail) {
        File f2 = new File(imgFile);
        if (!f2.exists()) {
            return;
        }
        try {
            FileInputStream input = new FileInputStream(f2);
            Image icon = new Image((InputStream)input);
            ((InputStream)input).close();
            this.image.setImage(icon);
            this.setimageWH(icon);
            this.setCanvas(isTrail);
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    private void setimageWH(Image i2) {
        this.imageValueW = i2.getWidth();
        this.imageValueH = i2.getHeight();
    }

    public void setCanvas(boolean isTrail) {
        this.getScale();
        this.canvas = new c(mScale * this.imageValueW, mScale * this.imageValueH, isTrail);
        this.imageAnchorPane.getChildren().add((Object)this.canvas);
    }

    public static double getMScale() {
        return mScale;
    }

    private void getScale() {
        double scaleX = this.image.getFitWidth() / this.imageValueW;
        double scaleY = this.image.getFitHeight() / this.imageValueH;
        mScale = Math.min(scaleX, scaleY);
    }

    public void setPointList(ArrayList<q> list) {
        ArrayList<q> newlist = new ArrayList<q>();
        JSONArray ja = JSONArray.parseArray((String)list.toString());
        int i2 = 0;
        while (i2 < ja.size()) {
            q p2 = new q(ja.getJSONArray(i2));
            p2.setX(this.canvas.b(p2.getX(), d.b(mScale * this.imageValueW)));
            p2.setY(this.canvas.b(p2.getY(), d.b(mScale * this.imageValueH)));
            newlist.add(p2);
            ++i2;
        }
        if (list.size() > 2) {
            this.canvas.a(newlist, true);
        } else {
            this.canvas.a(newlist, false);
        }
        this.canvas.h(list);
    }

    public void setIsPointInImage(boolean is) {
        this.canvas.U(is);
    }

    public boolean getIsPointInImage() {
        return this.canvas.aA();
    }

    @FXML
    public void rangeKeyType(KeyEvent event) {
        EditFrameDialogController.getInstance().okKeyTyped(event);
    }

    @FXML
    public void unSemblanceKeyType(KeyEvent event) {
        EditFrameDialogController.getInstance().okKeyTyped(event);
    }

    @FXML
    public void timeOutKeyType(KeyEvent event) {
        EditFrameDialogController.getInstance().okKeyTyped(event);
    }

    @FXML
    public void longTimeKeyType(KeyEvent event) {
        EditFrameDialogController.getInstance().okKeyTyped(event);
    }
}

