/*
 * Decompiled with CFR 0.152.
 */
package com.testin.javafx.ui.include;

import com.testin.itestin.business.actions.utils.b;
import com.testin.itestin.business.actions.utils.d;
import com.testin.javafx.ui.control.EditFrameDialogController;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.Slider;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;

public class ControllerSetController
extends AnchorPane
implements Initializable {
    @FXML
    TextField con = new TextField();
    @FXML
    TextField id;
    @FXML
    Slider conTimeoutSlider;
    @FXML
    Slider longTimeSlider;
    @FXML
    TextField timeOut;
    @FXML
    TextField longTime;
    @FXML
    RadioButton scrollNo;
    @FXML
    RadioButton scrollYes;
    @FXML
    Label warn;
    @FXML
    ImageView image;
    @FXML
    Label longTimeLabel;
    private String oldCon = "";

    public void setVisableLongTime() {
        this.longTimeLabel.setVisible(false);
        this.longTime.setVisible(false);
        this.longTimeSlider.setVisible(false);
    }

    public void initialize(URL arg0, ResourceBundle arg1) {
        this.id.setDisable(true);
        this.scrollYes.setSelected(true);
        this.warn.setText("");
        this.conTimeoutSlider.valueProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> arg0, Number arg1, Number arg2) {
                ControllerSetController.this.timeOut.setText(String.format("%.2s", arg2.intValue()));
            }
        });
        this.timeOut.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> arg0, String arg1, String arg2) {
                if (ControllerSetController.this.timeOut.getText().isEmpty()) {
                    return;
                }
                if (!d.isNumber(ControllerSetController.this.timeOut.getText()) || Integer.valueOf(ControllerSetController.this.timeOut.getText()) > 30) {
                    ControllerSetController.this.warn.setText(b.n("controllerset.check"));
                    ControllerSetController.this.timeOut.setText("30");
                    return;
                }
                ControllerSetController.this.conTimeoutSlider.setValue(Double.valueOf(ControllerSetController.this.timeOut.getText()).doubleValue());
            }
        });
        this.timeOut.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!ControllerSetController.this.timeOut.isFocused() && !ControllerSetController.this.timeOut.getText().isEmpty() && d.isNumber(ControllerSetController.this.timeOut.getText())) {
                    ControllerSetController.this.warn.setText("");
                }
            }
        });
        this.con.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> arg0, Boolean arg1, Boolean arg2) {
                if (!ControllerSetController.this.con.isFocused() && ControllerSetController.this.con.getText().isEmpty()) {
                    ControllerSetController.this.warn.setText(b.n("controllerset.warn"));
                    ControllerSetController.this.con.setText(ControllerSetController.this.oldCon);
                } else {
                    ControllerSetController.this.warn.setText("");
                }
            }
        });
        this.longTimeSlider.valueProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> arg0, Number arg1, Number arg2) {
                if (!ControllerSetController.this.longTime.isFocused()) {
                    ControllerSetController.this.longTime.setText(String.format("%.2s", arg2.intValue()));
                }
            }
        });
        this.longTime.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> arg0, String arg1, String arg2) {
                if (ControllerSetController.this.longTime.getText().isEmpty()) {
                    return;
                }
                if (!(ControllerSetController.this.longTime.isFocused() || d.isNumber(ControllerSetController.this.longTime.getText()) && Integer.valueOf(ControllerSetController.this.longTime.getText()) <= 30 && Integer.valueOf(ControllerSetController.this.longTime.getText()) >= 2)) {
                    ControllerSetController.this.warn.setText(b.n("controllerset.longtimecheck"));
                    ControllerSetController.this.longTime.setText("2");
                    return;
                }
                if (d.isNumber(ControllerSetController.this.longTime.getText())) {
                    ControllerSetController.this.longTimeSlider.setValue(Double.valueOf(ControllerSetController.this.longTime.getText()).doubleValue());
                }
            }
        });
        this.longTime.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!ControllerSetController.this.longTime.isFocused() && !ControllerSetController.this.longTime.getText().isEmpty() && d.isNumber(ControllerSetController.this.longTime.getText())) {
                    ControllerSetController.this.warn.setText("");
                }
                if (!(ControllerSetController.this.longTime.isFocused() || d.isNumber(ControllerSetController.this.longTime.getText()) && Integer.valueOf(ControllerSetController.this.longTime.getText()) <= 30 && Integer.valueOf(ControllerSetController.this.longTime.getText()) >= 2)) {
                    ControllerSetController.this.warn.setText(b.n("controllerset.longtimecheck"));
                    ControllerSetController.this.longTime.setText("2");
                }
            }
        });
    }

    @FXML
    public void yesClick(MouseEvent event) {
        if (this.scrollNo.isSelected()) {
            this.scrollNo.setSelected(false);
        }
    }

    @FXML
    public void noClick(MouseEvent event) {
        if (this.scrollYes.isSelected()) {
            this.scrollYes.setSelected(false);
        }
    }

    public int getControllertimeOut() {
        return Integer.valueOf(this.timeOut.getText()) * 1000;
    }

    public Boolean getControllerScroll() {
        return this.scrollYes.isSelected();
    }

    public int getLongTime() {
        if (this.longTime.getText().isEmpty()) {
            return -1;
        }
        return Integer.valueOf(this.longTime.getText()) * 1000;
    }

    public void setLongTime(String longtime) {
        this.longTime.setText(String.valueOf(Integer.valueOf(longtime) / 1000));
    }

    public void setControllertimeOut(String timeout) {
        this.timeOut.setText(String.valueOf(Integer.valueOf(timeout) / 1000));
    }

    public void setControllerScroll(Boolean scroll) {
        this.scrollYes.setSelected(scroll.booleanValue());
        this.scrollNo.setSelected(scroll == false);
    }

    public void setImg(String imgFile) {
        File f2 = new File(imgFile);
        if (!f2.exists()) {
            return;
        }
        try {
            FileInputStream input = new FileInputStream(f2);
            Image icon = new Image((InputStream)input);
            ((InputStream)input).close();
            this.image.setImage(icon);
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    public void setCon(String conStr) {
        this.con.setText(conStr);
        this.oldCon = conStr;
    }

    public String getCon() {
        return this.con.getText();
    }

    public void setCId(String idStr) {
        this.id.setText(idStr);
    }

    public String getCId() {
        return this.id.getText();
    }

    public void setConDisable(Boolean isDisable) {
        this.con.setDisable(isDisable.booleanValue());
    }

    @FXML
    public void conKeyType(KeyEvent event) {
        EditFrameDialogController.getInstance().okKeyTyped(event);
    }

    @FXML
    public void timeOutKeyType(KeyEvent event) {
        EditFrameDialogController.getInstance().okKeyTyped(event);
    }

    @FXML
    public void longTimeKeyType(KeyEvent event) {
        EditFrameDialogController.getInstance().okKeyTyped(event);
    }
}

