/*
 * Decompiled with CFR 0.152.
 */
package com.testin.javafx.ui.control;

import com.testin.itestin.business.actions.coord.l;
import com.testin.itestin.business.actions.coord.q;
import com.testin.itestin.business.actions.m;
import com.testin.itestin.business.utils.UIController;
import com.testin.itestin.entitys.e;
import com.testin.itestin.util.g;
import com.testin.javafx.b;
import com.testin.javafx.ui.control.a;
import com.testin.javafx.ui.control.c;
import com.testin.javafx.ui.control.i;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javafx.embed.swing.SwingFXUtils;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.stage.Stage;
import javax.imageio.ImageIO;
import org.apache.log4j.Logger;

public class AddImageDialogController
extends AnchorPane
implements Initializable {
    private double mouseDragOffsetX = 0.0;
    private double mouseDragOffsetY = 0.0;
    private i response = new i();
    static Logger log = Logger.getLogger(AddImageDialogController.class);
    public a canvas;
    @FXML
    AnchorPane addImage;
    @FXML
    ImageView image;
    @FXML
    ImageView close;
    @FXML
    Button ok;
    @FXML
    Button cancel;
    @FXML
    TextField des;
    @FXML
    AnchorPane imageAnchorPane;
    private double imageW;
    private double imageH;
    private static double mScale = 1.0;
    private Stage stage;

    public void setStage(Stage stage) {
        this.stage = stage;
    }

    public i getValue() {
        if (this.stage == null) {
            return null;
        }
        return this.response;
    }

    public double getMyPreHeight() {
        return this.addImage.getPrefHeight();
    }

    public double getMyPreWidth() {
        return this.addImage.getPrefWidth();
    }

    public void initialize(URL location, ResourceBundle resources) {
        String css = b.a().aU();
        this.addImage.getStylesheets().add((Object)css);
    }

    @FXML
    public void topOnMouseDragged(MouseEvent event) {
        if (this.stage == null) {
            return;
        }
        this.stage.setX(event.getScreenX() - this.mouseDragOffsetX);
        this.stage.setY(event.getScreenY() - this.mouseDragOffsetY);
    }

    @FXML
    public void topOnMousePressed(MouseEvent event) {
        if (this.stage == null) {
            return;
        }
        this.mouseDragOffsetX = event.getSceneX();
        this.mouseDragOffsetY = event.getSceneY();
    }

    @FXML
    public void closeClick(MouseEvent event) {
        if (this.stage == null) {
            return;
        }
        this.stage.close();
    }

    @FXML
    public void mouseEnter(MouseEvent event) {
        String url = ((Object)((Object)this)).getClass().getResource("/com/testin/javafx/resources/dialog_close_enter_blue.png").toExternalForm();
        this.close.setImage(new Image(url));
    }

    @FXML
    public void mouseExit(MouseEvent event) {
        String url = ((Object)((Object)this)).getClass().getResource("/com/testin/javafx/resources/dialog_close_blue.png").toExternalForm();
        this.close.setImage(new Image(url));
    }

    @FXML
    public void clickOk(MouseEvent event) {
        if (this.stage == null) {
            return;
        }
        if (this.des.getText().isEmpty()) {
            c.a(c.a.c, com.testin.itestin.business.actions.utils.b.n("coordemulatorcontroller.handlemenuitem.imagename"));
            return;
        }
        if (this.canvas.b().x == -1.0f || this.canvas.b().y == -1.0f || this.canvas.a().x == -1.0f || this.canvas.a().y == -1.0f) {
            c.a(c.a.c, com.testin.itestin.business.actions.utils.b.n("coordemulatorcontroller.getimageaction.getrect"));
            return;
        }
        this.getImageMessage();
        this.response.a = i.a.b;
        this.stage.close();
    }

    @FXML
    public void desKey(KeyEvent event) {
        if (event.getCharacter().equals("\r")) {
            this.clickOk(null);
        }
    }

    private void getImageMessage() {
        e myRec = this.getImageRect();
        if (myRec != null) {
            final BufferedImage big = SwingFXUtils.fromFXImage((Image)this.image.getImage(), null);
            int width = myRec.getX() + myRec.getWidth() > big.getWidth() ? big.getWidth() - myRec.getX() : myRec.getWidth();
            int height = myRec.getY() + myRec.getHeight() > big.getHeight() ? big.getHeight() - myRec.getY() : myRec.getHeight();
            final BufferedImage small = big.getSubimage(myRec.getX(), myRec.getY(), width, height);
            BufferedImage thumb = com.testin.itestin.business.utils.a.makeThumbnail(small, 130, 36);
            String timestamp = String.format("%s", System.currentTimeMillis());
            String bigName = String.format("%s.%s", timestamp, "png");
            String smallName = String.format("%s_%s.%s", timestamp, g.y(this.des.getText()), "png");
            String thumbName = String.format("%s_%s_%s.%s", timestamp, g.y(this.des.getText()), "thumb", "png");
            l imageAction = this.getImageTouchAction(myRec, this.des.getText());
            imageAction.G(smallName);
            imageAction.F(bigName);
            String controlDirName = String.valueOf(com.testin.itestin.business.l.z()) + "controldir";
            String controlImgDirName = String.valueOf(controlDirName) + File.separator + "img" + File.separator;
            final File smallPic = new File(String.valueOf(controlImgDirName) + imageAction.J());
            File thumbPic = new File(String.valueOf(controlImgDirName) + thumbName);
            final File bigPic = new File(String.valueOf(controlImgDirName) + bigName);
            this.saveImageInfo(imageAction);
            try {
                ImageIO.write((RenderedImage)thumb, "png", thumbPic);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            new Thread(){

                @Override
                public void run() {
                    try {
                        ImageIO.write((RenderedImage)small, "png", smallPic);
                        ImageIO.write((RenderedImage)big, "png", bigPic);
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }.start();
        }
    }

    public Boolean saveImageInfo(m action) {
        String fName;
        Boolean ret = true;
        if (action == null) {
            return false;
        }
        String controlDirName = String.valueOf(com.testin.itestin.business.l.z()) + "controldir";
        String controlImgDirName = String.valueOf(controlDirName) + File.separator + "img" + File.separator;
        File f2 = new File(controlImgDirName);
        if (!f2.exists()) {
            f2.mkdirs();
        }
        ret = !(f2 = new File(fName = String.valueOf(controlDirName) + File.separator + "info.xml")).exists() ? com.testin.itestin.business.utils.a.a(action, fName) : com.testin.itestin.business.utils.a.b(action, fName);
        return ret;
    }

    private l getImageTouchAction(e myRec, String showName) {
        double h2;
        l imageAction = new l();
        double w2 = this.imageW < this.imageH ? this.imageW : this.imageH;
        double d2 = h2 = this.imageH > this.imageW ? this.imageH : this.imageW;
        if (this.imageW <= this.imageH) {
            imageAction.setRotation(0);
        } else {
            imageAction.setRotation(1);
        }
        imageAction.e((float)((double)myRec.getX() / w2));
        imageAction.f((float)((double)myRec.getY() / h2));
        imageAction.g((float)((double)(myRec.getX() + myRec.getWidth()) / w2));
        imageAction.h((float)((double)(myRec.getY() + myRec.getHeight()) / h2));
        imageAction.t((int)w2);
        imageAction.u((int)h2);
        imageAction.setImageName(showName);
        imageAction.setRange("1.0");
        imageAction.S("0.35");
        imageAction.setTimeout(30000);
        imageAction.o(true);
        ArrayList<q> list = new ArrayList<q>();
        q p2 = new q();
        p2.setX(0.5f);
        p2.setY(0.5f);
        list.add(p2);
        imageAction.setPointList(list);
        return imageAction;
    }

    public e getImageRect() {
        e rec = new e();
        int x0 = (int)((double)this.canvas.b().x / mScale);
        int y0 = (int)((double)this.canvas.b().y / mScale);
        int x1 = (int)((double)this.canvas.a().x / mScale);
        int y1 = (int)((double)this.canvas.a().y / mScale);
        rec.setX(x0);
        rec.setY(y0);
        rec.setWidth(Math.abs(x1 - x0));
        rec.setHeight(Math.abs(y1 - y0));
        return rec;
    }

    @FXML
    public void okExit(MouseEvent event) {
        UIController.updateNodeSytleClass((Node)this.ok, "buttonstyle_normal");
    }

    @FXML
    public void okEnter(MouseEvent event) {
        UIController.updateNodeSytleClass((Node)this.ok, "buttonstyle_enter");
    }

    @FXML
    public void clickCancle(MouseEvent event) {
        if (this.stage == null) {
            return;
        }
        this.response.a = i.a.c;
        this.stage.close();
    }

    @FXML
    public void cancelExit(MouseEvent event) {
        UIController.updateNodeSytleClass((Node)this.cancel, "buttonstyle_normal");
    }

    @FXML
    public void cancelEnter(MouseEvent event) {
        UIController.updateNodeSytleClass((Node)this.cancel, "buttonstyle_enter");
    }

    public void setImage(Image img) {
        this.image.setImage(img);
        this.imageW = img.getWidth();
        this.imageH = img.getHeight();
        this.getScale();
        this.canvas = new a(this.imageW * mScale, this.imageH * mScale);
        this.imageAnchorPane.getChildren().add((Object)this.canvas);
    }

    private void getScale() {
        double scaleX = this.image.getFitWidth() / this.imageW;
        double scaleY = this.image.getFitHeight() / this.imageH;
        mScale = Math.min(scaleX, scaleY);
    }
}

