/*
 * Decompiled with CFR 0.152.
 */
package com.testin.javafx.ui.apk;

import com.testin.javafx.b;
import com.testin.javafx.ui.apk.a;
import com.testin.javafx.ui.control.A;
import com.testin.javafx.ui.control.c;
import com.testin.javafx.ui.control.f;
import com.testin.javafx.ui.control.i;
import com.testin.javafx.ui.control.l;
import com.testin.javafx.ui.include.logic.ScriptManageControllerLogic;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.ContextMenuEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.VBox;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;

public class ApkFolderController
extends VBox {
    static Logger log = Logger.getLogger(ApkFolderController.class);
    private a am;
    @FXML
    private ImageView apkIcon;
    @FXML
    private Label apkName;
    @FXML
    private Label apkVersion;
    @FXML
    public VBox vboxholder;
    private List<MenuItem> MenuItems = null;
    private static ContextMenu contextMenu = new ContextMenu();
    private static ApkFolderController ac = new ApkFolderController();
    ScriptManageControllerLogic logic;

    public static final ApkFolderController getInstance() {
        return ac;
    }

    private void createMenuItems() {
        if (this.MenuItems == null) {
            this.MenuItems = new ArrayList<MenuItem>();
        }
        this.MenuItems.clear();
        this.MenuItems.add(this.makeMenuItem(com.testin.itestin.business.actions.utils.b.n("scriptmanagercontroller.createcase.delete"), "delete"));
        this.MenuItems.add(this.makeMenuItem(com.testin.itestin.business.actions.utils.b.n("scriptmanagecontroller.export.text"), "export"));
    }

    private MenuItem makeMenuItem(String text, String id) {
        MenuItem menuItem = new MenuItem();
        menuItem.setId(id);
        menuItem.setText(text);
        menuItem.setStyle("-fx-font-size: 12px;-fx-font-family: \"Microsoft Yahei\",Tahoma,Arial,Helvetica,STHeiti;-fx-padding:0px 50px 0px 0px;");
        return menuItem;
    }

    @FXML
    public void apkFolderClicked(MouseEvent event) {
        MouseButton button = event.getButton();
        switch (button) {
            case PRIMARY: {
                b.a().e(this.am.p(), this.am.aV(), this.am.getVersion());
                break;
            }
            case SECONDARY: {
                break;
            }
        }
    }

    @FXML
    public void showMenu(ContextMenuEvent event) {
        double x2 = 0.0;
        double y2 = 0.0;
        this.createMenuItems();
        this.initContextMenu();
        if (contextMenu.getWidth() > 0.0 && event.getX() + contextMenu.getWidth() > 400.0) {
            x2 = event.getScreenX() - contextMenu.getWidth();
            if (x2 < 0.0) {
                x2 = event.getScreenX();
            }
        } else {
            x2 = event.getScreenX();
        }
        if (contextMenu.getHeight() > 0.0 && event.getY() + contextMenu.getHeight() > 400.0) {
            y2 = event.getScreenY() - contextMenu.getHeight();
            if (y2 < 0.0) {
                y2 = event.getScreenY();
            }
        } else {
            y2 = event.getScreenY();
        }
        contextMenu.show((Node)this.apkIcon, x2, y2);
    }

    @FXML
    public void onMouseEntered() {
        this.apkIcon.setRotate(-30.0);
    }

    @FXML
    public void onMouseExited() {
        this.apkIcon.setRotate(360.0);
    }

    public a getApkFolderModel() {
        return this.am;
    }

    public void setApkFolderModel(a am) {
        this.am = am;
    }

    public void updateView() {
        try {
            if (this.am.getIcon() != null) {
                File f2 = new File(this.am.getIcon());
                FileInputStream input = new FileInputStream(f2);
                Image icon = new Image((InputStream)input);
                this.apkIcon.setImage(icon);
                ((InputStream)input).close();
            }
            this.apkName.setText(this.am.aV());
            this.apkVersion.setText(this.am.getVersion());
            this.apkVersion.setAlignment(Pos.TOP_CENTER);
        }
        catch (Exception e2) {
            log.error((Object)e2.getMessage(), (Throwable)e2);
        }
    }

    private void initContextMenu() {
        log.info((Object)"Init context menu.");
        this.logic = new ScriptManageControllerLogic(this);
        contextMenu.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                MenuItem item = (MenuItem)event.getTarget();
                final String id = item.getId();
                Thread t2 = new Thread("handleMenuItem"){

                    @Override
                    public void run() {
                        ApkFolderController.this.handleMenuItem(id);
                    }
                };
                com.testin.itestin.threadpool.a.a(t2, "Handle Menu Item '" + id + "'");
                ApkFolderController.this.hideContextMenu();
            }
        });
        contextMenu.getItems().clear();
        contextMenu.getItems().addAll(this.MenuItems);
    }

    private void handleMenuItem(String id) {
        if (id == null) {
            return;
        }
        System.out.println("apkName: " + this.apkName.getText());
        if (id.equals("delete")) {
            try {
                i confirm = f.a(com.testin.itestin.business.actions.utils.b.n("apkfoldercontroller.handleMenuItem.deletewarning"), null);
                if (confirm.a == i.a.b) {
                    FileUtils.deleteDirectory((File)new File(this.am.getIcon()).getParentFile());
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            b.a().ao();
                        }
                    });
                }
            }
            catch (IOException e2) {
                log.error((Object)e2.getMessage(), (Throwable)e2);
            }
        } else if (id.equals("export")) {
            String zipName = String.valueOf(this.am.aV()) + "_" + this.am.getVersion();
            i response = l.a(com.testin.itestin.business.utils.a.q(zipName));
            if (response.a == i.a.b) {
                A progressDialog = new A(A.b.c);
                progressDialog.show();
                progressDialog.setMessage(com.testin.itestin.business.actions.utils.b.n("apkfoldercontroller.export.progressdialog"));
                progressDialog.setProgressValue(10);
                String result = this.logic.exportlocalCase(new File(this.am.getIcon()).getParent(), response.value, response.iM);
                progressDialog.setProgressValue(100);
                progressDialog.close();
                c.a(this.logic.getOptionType(), result);
            }
        }
    }

    public void hideContextMenu() {
        if (contextMenu.isShowing()) {
            log.debug((Object)"Hide context menu.");
            contextMenu.hide();
        }
    }
}

