/*
 * Decompiled with CFR 0.152.
 */
package com.testin.javafx.ui;

import com.testin.itestin.common.a;
import com.testin.javafx.b;
import com.testin.javafx.ui.control.A;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Worker;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.layout.AnchorPane;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class CloudTestController
extends AnchorPane
implements Initializable {
    static Logger log = Logger.getLogger(CloudTestController.class);
    @FXML
    WebView webView;
    WebEngine webEngine;
    String message = com.testin.itestin.business.actions.utils.b.n("cloudtestcontroller.mssage");
    A progressDialog = new A(A.b.c);
    private ChangeListener<String> locationChangeListener = new ChangeListener<String>(){

        public void changed(ObservableValue<? extends String> observable, final String oldValue, String newValue) {
            try {
                URI address;
                if (StringUtils.isNotEmpty((String)oldValue) && StringUtils.isNotEmpty((String)newValue) && !String.valueOf((address = new URI(newValue)).getQuery()).startsWith("op=App.list")) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            (this).CloudTestController.this.webEngine.load(oldValue);
                        }
                    });
                    b.a().getHostServices().showDocument(newValue);
                }
            }
            catch (URISyntaxException e2) {
                log.error((Object)e2.getMessage(), (Throwable)e2);
            }
        }
    };
    private ChangeListener<Worker.State> stateChangeListener = new ChangeListener<Worker.State>(){

        public void changed(ObservableValue<? extends Worker.State> observable, Worker.State oldValue, Worker.State newValue) {
            if (newValue == Worker.State.SUCCEEDED) {
                CloudTestController.this.progressDialog.setProgressValue(100);
                CloudTestController.this.progressDialog.close();
            } else if (newValue == Worker.State.FAILED) {
                CloudTestController.this.progressDialog.close();
            } else if (newValue == Worker.State.READY) {
                CloudTestController.this.progressDialog.setProgressValue(20);
            } else if (newValue == Worker.State.SCHEDULED) {
                CloudTestController.this.progressDialog.setProgressValue(40);
            } else if (newValue == Worker.State.RUNNING) {
                CloudTestController.this.progressDialog.setProgressValue(60);
            }
        }
    };

    public void initialize(URL arg0, ResourceBundle arg1) {
        this.progressDialog.show();
        this.progressDialog.setMessage(this.message);
        this.progressDialog.setProgressValue(10);
        this.webView.setContextMenuEnabled(false);
        this.webEngine = this.webView.getEngine();
        this.webEngine.getLoadWorker().stateProperty().addListener(this.stateChangeListener);
        this.webEngine.locationProperty().addListener(this.locationChangeListener);
    }

    public void loadURL() {
        log.info((Object)a.ao());
        this.webEngine.load(a.ao());
    }
}

