/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.BridgeUtils;
import com.android.ddmlib.DeviceConnection;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.TestinAdbHelper;
import com.android.ddmlib.TimeoutException;
import com.testin.itestin.device.f;
import com.testin.itestin.device.i;
import com.testin.itestin.os.c;
import com.testin.itestin.shell.e;
import com.testin.itestin.util.g;
import com.testin.itestin.util.m;
import java.io.IOException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ViewClient {
    static Logger log = Logger.getLogger(ViewClient.class);
    private final String HEARTBEAT = "heartbeat";
    private boolean isCancelled = false;
    private boolean isRunning = false;
    private f deviceInfo = null;
    private DeviceConnection deviceConnection = null;
    private static ViewClient mViewClient = null;
    private static String lastWindowInfoMD5 = "";
    private static String currentWindowInfo = "";
    private static long lastCmdTimeStamp = System.currentTimeMillis();
    private static final String RESULT_SEPERATOR = "@";
    private static long currentWindowInfoTimeStamp;

    public static String getWindowInfoFromDevice() {
        ViewClient viewclient = ViewClient.getViewClient();
        if (viewclient == null) {
            lastWindowInfoMD5 = "";
            return "";
        }
        String windowinfo = viewclient.fetchWindowInfo(lastWindowInfoMD5).getContent();
        if (!windowinfo.equals("0") && StringUtils.isNotEmpty((String)windowinfo)) {
            lastWindowInfoMD5 = g.y(windowinfo);
            currentWindowInfo = windowinfo;
            ViewClient.setCurrentWindowInfoTimeStamp(System.currentTimeMillis());
        }
        return windowinfo;
    }

    public static String getTextForNode() {
        ViewClient viewclient = ViewClient.getViewClient();
        if (viewclient == null) {
            return "";
        }
        String windowinfo = viewclient.fetchWindowInfo(lastWindowInfoMD5).getContent();
        if (!windowinfo.equals("0") && StringUtils.isNotEmpty((String)windowinfo)) {
            lastWindowInfoMD5 = g.y(windowinfo);
            currentWindowInfo = windowinfo;
            ViewClient.setCurrentWindowInfoTimeStamp(System.currentTimeMillis());
        }
        return windowinfo;
    }

    public static void heartbeat() {
        if (System.currentTimeMillis() - lastCmdTimeStamp < 5000L) {
            return;
        }
        ViewClient viewclient = ViewClient.getViewClient();
        if (viewclient == null) {
            return;
        }
        viewclient.sendHeartbeat();
    }

    public static String getCurrentWindowInfo() {
        return currentWindowInfo;
    }

    public static c runCommand(String command, boolean scroll, int timeout) {
        long t1 = System.currentTimeMillis();
        try {
            ViewClient viewclient = ViewClient.getViewClient();
            if (viewclient == null) {
                c msg = new c();
                msg.setStatus(20);
                c c2 = msg;
                return c2;
            }
            c c3 = viewclient.runCmd(command, scroll, timeout);
            return c3;
        }
        catch (Exception e2) {
            log.error((Object)e2.getMessage(), (Throwable)e2);
            c msg = new c();
            msg.setStatus(20);
            msg.setContent(e2.getMessage());
            c c4 = msg;
            return c4;
        }
        finally {
            long t2 = System.currentTimeMillis();
            log.info((Object)("RunCmd: \n" + command + "\nTimeConsumed: " + (t2 - t1)));
        }
    }

    public static c fetchViewText(String command) {
        long t1 = System.currentTimeMillis();
        try {
            ViewClient viewclient = ViewClient.getViewClient();
            if (viewclient == null) {
                c c2 = new c();
                return c2;
            }
            c c3 = viewclient.fetchText(command);
            return c3;
        }
        catch (Exception e2) {
            e2.printStackTrace();
            c c4 = new c();
            return c4;
        }
        finally {
            long t2 = System.currentTimeMillis();
            log.info((Object)("fetch view text with command: " + command + "\nTimeConsumed: " + (t2 - t1)));
        }
    }

    public static boolean stopViewClient() {
        if (mViewClient != null) {
            return mViewClient.stop();
        }
        return true;
    }

    private static ViewClient getViewClient() {
        f device = i.a();
        if (device == null || device.getDevice() == null || !device.getDevice().isOnline()) {
            log.error((Object)"Device is null or not online.");
            return null;
        }
        if (mViewClient == null) {
            mViewClient = new ViewClient(device);
        }
        if (!mViewClient.isRunning()) {
            mViewClient.start();
        }
        if (mViewClient.isRunning()) {
            return mViewClient;
        }
        return null;
    }

    private ViewClient(f deviceInfo) {
        if (deviceInfo == null) {
            log.error((Object)"Device is null, unable to initialize ViewClient");
            return;
        }
        this.deviceInfo = deviceInfo;
        this.deviceConnection = new DeviceConnection(deviceInfo);
        log.info((Object)("ViewClient initialized for device " + deviceInfo));
    }

    public boolean start() {
        c msg = this.deviceConnection.createForward();
        boolean bl = this.isRunning = msg.getStatus() == 0;
        if (this.isRunning) {
            log.info((Object)"Start running view client.");
        } else {
            log.info((Object)"View client unable to start.");
        }
        return this.isRunning;
    }

    public boolean isRunning() {
        return this.isRunning && !this.isCancelled;
    }

    public c runCmd(String command, boolean scroll, int timeout) {
        long t1 = System.currentTimeMillis();
        c msg = new c();
        e.a rcvr = new e.a();
        try {
            try {
                command = String.format("[scroll/%s]%s", scroll, command);
                if (timeout > 0) {
                    command = String.valueOf(this.getTimeoutFormat(timeout)) + command;
                } else {
                    timeout = 60000;
                }
                Base64 base64 = new Base64(2048);
                byte[] data = base64.encode(command.getBytes("utf-8"));
                String cmd = new String(data, "utf-8");
                String runcmd = String.format("runcmd %s", cmd);
                TestinAdbHelper.executeRemoteCommand(this.deviceConnection.getSocketAddress(), runcmd, this.deviceInfo.getDevice(), rcvr, timeout + 10000);
                ViewClient.setLastCmdTimeStamp(System.currentTimeMillis());
                String r2 = rcvr.getOutput();
                System.out.println("RESULT: " + r2);
                if (StringUtils.isNotEmpty((String)r2) && r2.contains(RESULT_SEPERATOR) && r2.substring(0, r2.indexOf(RESULT_SEPERATOR)).equals("false")) {
                    msg.setContent(r2.substring(r2.indexOf(RESULT_SEPERATOR) + 1, r2.length()));
                    msg.setStatus(1);
                } else {
                    log.error((Object)("RESULT: " + msg));
                }
                log.info((Object)String.format("Run CMD Sucessful: %s\nResult: %s", command, String.valueOf(msg.getStatus()) + (StringUtils.isEmpty((String)msg.getContent()) ? "" : " " + msg.getContent())));
            }
            catch (AdbCommandRejectedException | ShellCommandUnresponsiveException | TimeoutException | IOException ex) {
                System.out.println(ex.getLocalizedMessage());
                msg.setStatus(20);
                msg.setContent(ex.getMessage());
                log.error((Object)String.format("Run CMD Failed: %s, Error Msg: %s", command, ex.getMessage()), ex);
                long t2 = System.currentTimeMillis();
                System.err.println("\u6267\u884c\u547d\u4ee4\uff1a" + command + "\n" + "\u8017\u65f6\uff1a" + (t2 - t1));
            }
        }
        finally {
            long t2 = System.currentTimeMillis();
            System.err.println("\u6267\u884c\u547d\u4ee4\uff1a" + command + "\n" + "\u8017\u65f6\uff1a" + (t2 - t1));
        }
        return msg;
    }

    private String getTimeoutFormat(int timeout) {
        return String.format("[replaytimeout/%s]", timeout);
    }

    public c fetchText(String command) {
        c msg = new c();
        e.a rcvr = new e.a();
        try {
            Base64 base64 = new Base64(2048);
            byte[] data = base64.encode(command.getBytes("utf-8"));
            String cmd = new String(data, "utf-8");
            String runcmd = String.format("fetch.text %s", cmd);
            TestinAdbHelper.executeRemoteCommand(this.deviceConnection.getSocketAddress(), runcmd, this.deviceInfo.getDevice(), rcvr, 60000);
            ViewClient.setLastCmdTimeStamp(System.currentTimeMillis());
            msg.setContent(rcvr.getOutput());
            log.info((Object)String.format("Run CMD Sucessful: %s\nResult: %s", command, msg.getContent()));
        }
        catch (Exception ex) {
            msg.setStatus(20);
            msg.setContent(ex.getMessage());
            log.error((Object)String.format("Run CMD Failed: %s, Error Msg: %s", command, ex.getMessage()), (Throwable)ex);
        }
        return msg;
    }

    public c fetchWindowInfo() {
        return this.fetchWindowInfo(null);
    }

    public c fetchWindowInfo(String lastWindowInfoMD5) {
        c msg = new c();
        try {
            if (m.aF) {
                return msg;
            }
            String command = "viewfetcher";
            if (lastWindowInfoMD5 != null && !lastWindowInfoMD5.equals("")) {
                command = String.format("%s %s", command, lastWindowInfoMD5);
            }
            e.a rcvr = new e.a();
            try {
                try {
                    TestinAdbHelper.executeRemoteCommand(this.deviceConnection.getSocketAddress(), command, this.deviceInfo.getDevice(), rcvr, 60000);
                    ViewClient.setLastCmdTimeStamp(System.currentTimeMillis());
                    msg.setContent(rcvr.getOutput());
                }
                catch (Exception ex) {
                    msg.setStatus(20);
                    msg.setContent(ex.getMessage());
                    log.error((Object)ex.getMessage(), (Throwable)ex);
                    rcvr = null;
                }
            }
            finally {
                rcvr = null;
            }
            return msg;
        }
        catch (Exception e2) {
            log.error((Object)e2.getMessage(), (Throwable)e2);
            return msg;
        }
    }

    public c sendHeartbeat() {
        c msg = new c();
        try {
            e.a rcvr = new e.a();
            try {
                try {
                    TestinAdbHelper.executeRemoteCommand(this.deviceConnection.getSocketAddress(), "heartbeat", this.deviceInfo.getDevice(), rcvr, 60000);
                    ViewClient.setLastCmdTimeStamp(System.currentTimeMillis());
                    msg.setContent(rcvr.getOutput());
                }
                catch (Exception ex) {
                    msg.setStatus(20);
                    msg.setContent(ex.getMessage());
                    log.error((Object)ex.getMessage(), (Throwable)ex);
                    rcvr = null;
                }
            }
            finally {
                rcvr = null;
            }
            return msg;
        }
        catch (Exception e2) {
            log.error((Object)e2.getMessage(), (Throwable)e2);
            return msg;
        }
    }

    public c cancelRunCMD(boolean setCancelValue) {
        c msg = new c();
        try {
            e.a rcvr = new e.a();
            try {
                try {
                    TestinAdbHelper.executeRemoteCommand(this.deviceConnection.getSocketAddress(), "cancelruncmd " + setCancelValue, this.deviceInfo.getDevice(), rcvr, 60000);
                    ViewClient.setLastCmdTimeStamp(System.currentTimeMillis());
                    msg.setContent(rcvr.getOutput());
                }
                catch (Exception ex) {
                    msg.setStatus(20);
                    msg.setContent(ex.getMessage());
                    log.error((Object)ex.getMessage(), (Throwable)ex);
                    rcvr = null;
                }
            }
            finally {
                rcvr = null;
            }
            return msg;
        }
        catch (Exception e2) {
            log.error((Object)e2.getMessage(), (Throwable)e2);
            return msg;
        }
    }

    public boolean stop() {
        String runcmd = "stopserver";
        e.a rcvr = new e.a();
        try {
            log.info((Object)"stop view server on device.");
            TestinAdbHelper.executeRemoteCommand(this.deviceConnection.getSocketAddress(), runcmd, this.deviceInfo.getDevice(), rcvr, 60000);
        }
        catch (Exception ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
        }
        this.deviceConnection.removeForward();
        this.isCancelled = true;
        return true;
    }

    public void reset() {
        this.isCancelled = false;
        this.isRunning = false;
        ViewClient.setThisViewClient(null);
        ViewClient.setLastWindowInfoMD5("");
        ViewClient.setCurrentWindowInfo("");
    }

    public static void endViewServerIfAny() {
        try {
            try {
                ViewClient viewClient = ViewClient.getViewClient();
                if (viewClient != null) {
                    viewClient.stop();
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
                if (mViewClient != null) {
                    mViewClient.reset();
                }
            }
        }
        finally {
            if (mViewClient != null) {
                mViewClient.reset();
            }
        }
    }

    public static long getLastCmdTimeStamp() {
        return lastCmdTimeStamp;
    }

    public static void setLastCmdTimeStamp(long lastCmdTimeStamp) {
        ViewClient.lastCmdTimeStamp = lastCmdTimeStamp;
    }

    public static ViewClient getThisViewClient() {
        return mViewClient;
    }

    public static void setThisViewClient(ViewClient mViewClient) {
        ViewClient.mViewClient = mViewClient;
    }

    public static String getLastWindowInfoMD5() {
        return lastWindowInfoMD5;
    }

    public static void setLastWindowInfoMD5(String lastWindowInfoMD5) {
        ViewClient.lastWindowInfoMD5 = lastWindowInfoMD5;
    }

    public static void setCurrentWindowInfo(String currentWindowInfo) {
        ViewClient.currentWindowInfo = currentWindowInfo;
    }

    public static long getCurrentWindowInfoTimeStamp() {
        return currentWindowInfoTimeStamp;
    }

    public static void setCurrentWindowInfoTimeStamp(long currentWindowInfoTimeStamp) {
        ViewClient.currentWindowInfoTimeStamp = currentWindowInfoTimeStamp;
    }

    public static void main(String[] args) {
        String serialno = "DU2SSE151Y043327";
        new f.a();
        f deviceinfo = f.a.a(serialno);
        IDevice idevice = BridgeUtils.getDevice(serialno);
        log.info((Object)idevice);
        deviceinfo.a(idevice);
        ViewClient viewclient = new ViewClient(deviceinfo);
        viewclient.start();
        c msg = viewclient.cancelRunCMD(false);
        log.info((Object)msg.getContent().toString());
        BridgeUtils.closeBridge();
    }
}

