/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib;

import com.android.ddmlib.AdbCommandRejectedException;
import com.testin.itestin.device.f;
import com.testin.itestin.os.c;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class DeviceConnection {
    static Logger log = Logger.getLogger(DeviceConnection.class);
    private f deviceInfo;
    private static int DEFAULT_VIEW_SERVER_PORT;
    private static int mNextLocalPort;
    private static HashMap<String, Integer> portMgt;
    private int remotePort = 10321;
    private InetSocketAddress sSocketAddr;

    static {
        mNextLocalPort = DEFAULT_VIEW_SERVER_PORT = 10321;
        portMgt = new HashMap();
    }

    public DeviceConnection(f deviceInfo) {
        this.deviceInfo = deviceInfo;
        this.setPort();
    }

    private void setPort() {
        String modelName;
        if (this.deviceInfo != null && StringUtils.isNotEmpty((String)(modelName = this.deviceInfo.at())) && !portMgt.containsKey(modelName)) {
            portMgt.put(modelName, this.getAvailablePort());
        }
    }

    private int getPort() {
        if (this.deviceInfo != null) {
            String modelName = this.deviceInfo.at();
            if (StringUtils.isEmpty((String)modelName)) {
                return DEFAULT_VIEW_SERVER_PORT;
            }
            this.setPort();
            if (portMgt.containsKey(modelName)) {
                return portMgt.get(modelName);
            }
        }
        return DEFAULT_VIEW_SERVER_PORT;
    }

    private int getAvailablePort() {
        return ++mNextLocalPort;
    }

    public c createForward() {
        c mag = new c();
        try {
            if (this.deviceInfo != null && this.deviceInfo.getDevice() != null) {
                log.info((Object)String.format("local port: %s, remote port: %s", this.getPort(), this.remotePort));
                log.info(portMgt);
                this.deviceInfo.getDevice().createForward(this.getPort(), this.remotePort);
                InetAddress addr = InetAddress.getByName("127.0.0.1");
                this.sSocketAddr = new InetSocketAddress(addr, this.getPort());
            }
        }
        catch (Exception e2) {
            mag.setStatus(20);
            mag.setContent(e2.getMessage());
            log.error((Object)e2.getMessage(), (Throwable)e2);
        }
        return mag;
    }

    public InetSocketAddress getSocketAddress() {
        return this.sSocketAddr;
    }

    public void removeForward() {
        try {
            if (this.deviceInfo != null && this.deviceInfo.getDevice() != null) {
                this.deviceInfo.getDevice().removeForward(this.getPort(), this.remotePort);
            }
        }
        catch (AdbCommandRejectedException e2) {
            log.error((Object)"Unable to remove tcp port forward");
        }
        catch (Exception e3) {
            log.error((Object)"Unable to remove tcp port forward", (Throwable)e3);
        }
    }
}

