/*
 * Decompiled with CFR 0.152.
 */
package cn.testin.cv;

import cn.testin.cv.a;
import cn.testin.cv.c;
import cn.testin.cv.e;
import cn.testin.cv.f;
import cn.testin.cv.h;
import com.atul.JavaOpenCV.Imshow;
import com.testin.itestin.business.actions.utils.b;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.imageio.ImageIO;
import net.coobird.thumbnailator.Thumbnailator;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.opencv.core.Core;
import org.opencv.core.CvType;
import org.opencv.core.Mat;
import org.opencv.core.MatOfByte;
import org.opencv.core.MatOfDMatch;
import org.opencv.core.MatOfFloat;
import org.opencv.core.MatOfInt;
import org.opencv.core.MatOfKeyPoint;
import org.opencv.core.Point;
import org.opencv.core.Scalar;
import org.opencv.core.Size;
import org.opencv.features2d.DMatch;
import org.opencv.features2d.DescriptorExtractor;
import org.opencv.features2d.DescriptorMatcher;
import org.opencv.features2d.FeatureDetector;
import org.opencv.features2d.Features2d;
import org.opencv.features2d.KeyPoint;
import org.opencv.highgui.Highgui;
import org.opencv.imgproc.Imgproc;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class d {
    static Logger log = Logger.getLogger(d.class);
    private static boolean c = false;
    public static boolean d = true;
    public static boolean e = false;
    static boolean f = false;
    static int f = 0;
    static int g = 0;
    private static String e;
    private static boolean g;

    static {
        g = false;
    }

    public static void a(Mat src, Mat dst, int angle) {
        log.error((Object)("Do rotation, angle: " + angle));
        if (!src.equals(dst)) {
            src.copyTo(dst);
        }
        int flip_horizontal_or_vertical = (angle = angle / 90 % 4 * 90) > 0 ? 1 : 0;
        int number = Math.abs(angle / 90);
        int i2 = 0;
        while (i2 != number) {
            Core.transpose((Mat)dst, (Mat)dst);
            Core.flip((Mat)dst, (Mat)dst, (int)flip_horizontal_or_vertical);
            ++i2;
        }
    }

    public static double a(Mat A2, Mat B2) {
        if (A2.rows() > 0 && A2.rows() == B2.rows() && A2.cols() > 0 && A2.cols() == B2.cols()) {
            double errorL2 = Core.norm((Mat)A2, (Mat)B2, (int)4);
            double similarity = errorL2 / (double)(A2.rows() * A2.cols());
            return similarity;
        }
        return 10000.0;
    }

    public static double a(String imgFilePath1, String imgFilePath2) {
        Mat source1 = Highgui.imread((String)imgFilePath1);
        Mat source2 = Highgui.imread((String)imgFilePath2);
        double similarity = cn.testin.cv.d.a(source1, source2);
        return similarity;
    }

    public static double b(String imgFilePath1, String imgFilePath2) {
        Mat image1 = Highgui.imread((String)imgFilePath1);
        Mat image2 = Highgui.imread((String)imgFilePath2);
        return cn.testin.cv.d.c(image1, image2);
    }

    public static BufferedImage a(Mat image) {
        MatOfByte mob = new MatOfByte();
        Highgui.imencode((String)".png", (Mat)image, (MatOfByte)mob);
        byte[] byteArray = mob.toArray();
        BufferedImage bufImage = null;
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(byteArray);
            bufImage = ImageIO.read(in);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        return bufImage;
    }

    public static double c(String image1Path, String image2Path) {
        Mat img1 = Highgui.imread((String)image1Path);
        Mat img2 = Highgui.imread((String)image2Path);
        return cn.testin.cv.d.b(img1, img2);
    }

    public static int a(String image1, String image2) {
        long t0 = System.currentTimeMillis();
        if (!image1.toLowerCase().endsWith(".png") && !image1.toLowerCase().endsWith(".jpg") || !image2.toLowerCase().endsWith(".png") && !image2.toLowerCase().endsWith(".jpg")) {
            System.err.println("Unsupported image format, unable to process. image1: " + image1 + "; image2: " + image2);
            return 0;
        }
        File imageFile1 = new File(image1);
        File imageFile2 = new File(image2);
        if (!imageFile1.exists() || !imageFile2.exists()) {
            System.err.println("One of the images is absent.\nImage1: " + imageFile1.exists() + " Path: " + image1 + "\nImage2: " + imageFile2.exists() + " Path: " + image2);
            return 0;
        }
        long t1 = System.currentTimeMillis();
        Mat mat1 = Highgui.imread((String)image1);
        Mat mat2 = Highgui.imread((String)image2);
        long t2 = System.currentTimeMillis();
        if (mat1.cols() > 600) {
            mat1 = cn.testin.cv.d.a(mat1, 600.0 / (double)mat1.cols());
        }
        if (mat2.cols() > 600) {
            mat2 = cn.testin.cv.d.a(mat2, 600.0 / (double)mat2.cols());
        }
        if (mat1.cols() * mat1.rows() < mat2.cols() * mat2.rows()) {
            Imgproc.resize((Mat)mat2, (Mat)mat2, (Size)new Size((double)mat1.cols(), (double)mat1.rows()));
        } else {
            Imgproc.resize((Mat)mat1, (Mat)mat1, (Size)new Size((double)mat2.cols(), (double)mat2.rows()));
        }
        long t4 = System.currentTimeMillis();
        double normL2Similarity = cn.testin.cv.d.a(mat1, mat2);
        long t5 = System.currentTimeMillis();
        double hist = cn.testin.cv.d.c(mat1, mat2);
        long t6 = System.currentTimeMillis();
        int result = cn.testin.cv.d.a(normL2Similarity, hist);
        System.err.println("CheckImageExistence: " + (t1 - t0) + "\nReadImageFiles: " + (t2 - t1) + "\nResize: " + (t4 - t2) + "\nNormL2: " + normL2Similarity + " TimeConsumed: " + (t5 - t4) + "\nHist: " + hist + " TimeConsumed: " + (t6 - t5) + "\nResult: " + result);
        return result;
    }

    private static int a(double normL2, double hist) {
        double result = 0.0;
        result += (100.0 - normL2 * 100.0) * 0.8;
        if ((result += (100.0 - hist * 100.0) * 0.2) > 100.0) {
            return 100;
        }
        if (result < 0.0) {
            return 0;
        }
        if (result > 100.0) {
            return 100;
        }
        if (result < 0.0) {
            return 0;
        }
        return (int)result;
    }

    public static int b(String image1, String image2) {
        Mat mat1 = Highgui.imread((String)image1);
        Mat mat2 = Highgui.imread((String)image2);
        return cn.testin.cv.d.a(mat1, mat2);
    }

    public static int a(Mat image1, Mat image2) {
        if (image1 == null || image2 == null) {
            return 0;
        }
        MatOfKeyPoint keypoints1 = new MatOfKeyPoint();
        MatOfKeyPoint keypoints2 = new MatOfKeyPoint();
        FeatureDetector surf = FeatureDetector.create((int)4);
        surf.detect(image1, keypoints1);
        surf.detect(image2, keypoints2);
        List trainKeyPointList = keypoints1.toList();
        List queryKeyPointList = keypoints2.toList();
        if (trainKeyPointList.isEmpty() || queryKeyPointList.isEmpty()) {
            return 0;
        }
        Mat descriptorsLarge = new Mat();
        Mat descriptorsSmall = new Mat();
        DescriptorExtractor extractor = DescriptorExtractor.create((int)1002);
        extractor.compute(image1, keypoints2, descriptorsLarge);
        extractor.compute(image2, keypoints1, descriptorsSmall);
        MatOfDMatch matches = new MatOfDMatch();
        DescriptorMatcher matcher = DescriptorMatcher.create((int)1);
        matcher.match(descriptorsLarge, descriptorsSmall, matches);
        List matchList = matches.toList();
        int basedKeyPointNum = trainKeyPointList.size();
        int queryKeyPointNum = queryKeyPointList.size();
        int goodMatchCount = 0;
        int i2 = 0;
        while (i2 < matchList.size()) {
            if (((DMatch)matchList.get((int)i2)).distance <= 1.0f) {
                ++goodMatchCount;
            }
            ++i2;
        }
        return (int)((double)goodMatchCount / (double)Math.max(basedKeyPointNum, queryKeyPointNum) * 100.0);
    }

    public static double b(Mat image1, Mat image2) {
        BufferedImage img1 = cn.testin.cv.d.a(image1);
        BufferedImage img2 = cn.testin.cv.d.a(image2);
        return cn.testin.cv.d.a(img1, img2);
    }

    public static double a(BufferedImage template, BufferedImage foundMatch) {
        e ipm = new e();
        int templateFeatureNumber = ipm.a(template);
        log.error((Object)("templateFeatureNumber: " + templateFeatureNumber));
        if (templateFeatureNumber < 5) {
            return -1.0;
        }
        int matchedFeatureNumber = ipm.a((a)ipm.a((BufferedImage)template), (a)ipm.a((BufferedImage)foundMatch)).size;
        log.error((Object)("MatchedFeatureNumber: " + matchedFeatureNumber));
        return 1.0 - (double)matchedFeatureNumber / (double)templateFeatureNumber;
    }

    public static double c(Mat image1, Mat image2) {
        Mat image1Hsv = new Mat();
        Mat image2Hsv = new Mat();
        Imgproc.cvtColor((Mat)image1, (Mat)image1Hsv, (int)40);
        Imgproc.cvtColor((Mat)image2, (Mat)image2Hsv, (int)40);
        Mat histImage1 = new Mat();
        Mat histImage2 = new Mat();
        MatOfFloat ranges = new MatOfFloat(new float[]{0.0f, 256.0f});
        MatOfInt histSize = new MatOfInt(new int[]{50});
        MatOfInt channel = new MatOfInt(new int[]{0});
        Imgproc.calcHist(Arrays.asList(image1Hsv), (MatOfInt)channel, (Mat)new Mat(), (Mat)histImage1, (MatOfInt)histSize, (MatOfFloat)ranges);
        Core.normalize((Mat)histImage1, (Mat)histImage1, (double)0.0, (double)1.0, (int)32, (int)-1, (Mat)new Mat());
        Imgproc.calcHist(Arrays.asList(image2Hsv), (MatOfInt)channel, (Mat)new Mat(), (Mat)histImage2, (MatOfInt)histSize, (MatOfFloat)ranges);
        Core.normalize((Mat)histImage2, (Mat)histImage2, (double)0.0, (double)1.0, (int)32, (int)-1, (Mat)new Mat());
        double correl = Imgproc.compareHist((Mat)histImage1, (Mat)histImage2, (int)0);
        return 1.0 - correl;
    }

    public static double a(Mat image) {
        FeatureDetector fd = FeatureDetector.create((int)1);
        MatOfKeyPoint keyPointsLarge = new MatOfKeyPoint();
        fd.detect(image, keyPointsLarge);
        return keyPointsLarge.size().width;
    }

    public static f a(String query, String train, boolean deleteFileAfterMatch) {
        long t1 = System.currentTimeMillis();
        Process process = null;
        try {
            ArrayList<String> commands = new ArrayList<String>();
            commands.add(com.testin.itestin.business.actions.utils.a.al());
            if (cn.testin.cv.d.isDebug()) {
                commands.add("-d");
            }
            commands.add("-q");
            commands.add(query);
            commands.add("-t");
            commands.add(train);
            ProcessBuilder pb = new ProcessBuilder(commands);
            process = pb.start();
            StringBuilder out = new StringBuilder();
            BufferedReader br = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String line = null;
            String previous = null;
            while ((line = br.readLine()) != null) {
                if (line.equals(previous)) continue;
                previous = line;
                System.out.println(line);
                out.append(line).append('\n');
            }
            if (process.waitFor() == 0) {
                System.out.println("Success!");
            }
            f f2 = new f(out.toString());
            return f2;
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        finally {
            if (process != null) {
                process.destroy();
                FileUtils.deleteQuietly((File)new File(query));
                FileUtils.deleteQuietly((File)new File(train));
            }
            long t2 = System.currentTimeMillis();
            System.err.println("Call In Java Side, Time: " + (t2 - t1));
        }
        return null;
    }

    public static f a(Mat smallImage, Mat largeImage) {
        long t1 = System.currentTimeMillis();
        f result = new f();
        Mat img_1 = smallImage;
        Mat img_2 = largeImage;
        if (img_1 == null || img_2 == null) {
            return result;
        }
        MatOfKeyPoint smallImageKeyPoints = new MatOfKeyPoint();
        MatOfKeyPoint largeImageKeyPoints = new MatOfKeyPoint();
        FeatureDetector surf = FeatureDetector.create((int)4);
        surf.detect(smallImage, smallImageKeyPoints);
        surf.detect(largeImage, largeImageKeyPoints);
        log.info((Object)("TrainKeyPoints: " + smallImageKeyPoints.size()));
        log.info((Object)("QueryKeyPoints: " + largeImageKeyPoints.size()));
        List trainKeyPointList = smallImageKeyPoints.toList();
        List queryKeyPointList = largeImageKeyPoints.toList();
        long t2 = System.currentTimeMillis();
        log.info((Object)("Detect key points take " + (t2 - t1) + "ms."));
        if (trainKeyPointList.isEmpty() || queryKeyPointList.isEmpty()) {
            log.error((Object)("One of the images has no feature key points, match failed. Total time: " + (System.currentTimeMillis() - t1) + "ms."));
            return result;
        }
        Mat descriptorsLarge = new Mat();
        Mat descriptorsSmall = new Mat();
        DescriptorExtractor extractor = DescriptorExtractor.create((int)1002);
        extractor.compute(largeImage, largeImageKeyPoints, descriptorsLarge);
        extractor.compute(smallImage, smallImageKeyPoints, descriptorsSmall);
        long t3 = System.currentTimeMillis();
        log.info((Object)("Compute descriptor takes " + (t3 - t2) + "ms. Total time: " + (t3 - t1) + "ms."));
        MatOfDMatch matches = new MatOfDMatch();
        MatOfDMatch goodMchs = new MatOfDMatch();
        DescriptorMatcher matcher = DescriptorMatcher.create((int)1);
        matcher.match(descriptorsLarge, descriptorsSmall, matches);
        List matchList = matches.toList();
        ArrayList<DMatch> goodMatch = new ArrayList<DMatch>();
        log.info((Object)("Found " + matchList.size() + " matche(s)."));
        if (matchList.size() == 0) {
            log.error((Object)("No match found! Total time: " + (System.currentTimeMillis() - t1) + "ms."));
            return result;
        }
        double minDistance = 1000.0;
        int i2 = 0;
        while (i2 < matchList.size()) {
            if ((double)((DMatch)matchList.get((int)i2)).distance < minDistance) {
                goodMatch.add((DMatch)matchList.get(i2));
            }
            ++i2;
        }
        if (goodMatch.size() == 0) {
            log.error((Object)("No good match found, takes time: " + (System.currentTimeMillis() - t3) + "ms. Total time: " + (System.currentTimeMillis() - t1) + "ms."));
            return result;
        }
        log.info((Object)("Found " + goodMatch.size() + " good matches, takes " + (System.currentTimeMillis() - t3) + "ms. Total time: " + (System.currentTimeMillis() - t1) + "ms."));
        List<DMatch> twoBestMatch = cn.testin.cv.d.a(goodMatch);
        log.info((Object)("Found 2 best matches:\n" + twoBestMatch));
        double resizeRate = cn.testin.cv.d.b(trainKeyPointList, queryKeyPointList, twoBestMatch);
        log.error((Object)("ResizeRate:\t\t" + resizeRate));
        double rotatedAngle = cn.testin.cv.d.a(trainKeyPointList, queryKeyPointList, twoBestMatch);
        log.error((Object)("RotatedAngle:\t\t" + rotatedAngle));
        int rotation = cn.testin.cv.d.a(rotatedAngle);
        log.error((Object)("Rotation:\t\t" + rotation));
        Point startPoint = cn.testin.cv.d.a(trainKeyPointList, queryKeyPointList, twoBestMatch, resizeRate, smallImage.cols(), smallImage.rows(), rotation);
        if (cn.testin.cv.d.isDebug()) {
            goodMchs.fromList(twoBestMatch);
            Mat img2display = largeImage.clone();
            if (rotation % 2 == 0) {
                Core.rectangle((Mat)img2display, (Point)startPoint, (Point)new Point(startPoint.x + (double)smallImage.cols() * resizeRate, startPoint.y + (double)smallImage.rows() * resizeRate), (Scalar)new Scalar(0.0, 255.0, 0.0), (int)2, (int)8, (int)0);
            } else {
                Core.rectangle((Mat)img2display, (Point)startPoint, (Point)new Point(startPoint.x + (double)smallImage.rows() * resizeRate, startPoint.y + (double)smallImage.cols() * resizeRate), (Scalar)new Scalar(0.0, 255.0, 0.0), (int)2, (int)8, (int)0);
            }
            cn.testin.cv.d.a("Matches", smallImage, img2display, smallImageKeyPoints, largeImageKeyPoints, goodMchs);
        }
        result.c((int)startPoint.x);
        result.d((int)startPoint.y);
        if (twoBestMatch.size() > 0) {
            result.c(true);
        }
        result.e(resizeRate);
        result.setRotation(rotation);
        if (rotation % 2 == 0) {
            result.setWidth((int)((double)smallImage.cols() * resizeRate));
            result.setHeight((int)((double)smallImage.rows() * resizeRate));
        } else {
            result.setWidth((int)((double)smallImage.rows() * resizeRate));
            result.setHeight((int)((double)smallImage.cols() * resizeRate));
        }
        return result;
    }

    public static int a(double rotatedAngle) {
        if (rotatedAngle < -45.0) {
            rotatedAngle += 360.0;
        }
        if (rotatedAngle >= -45.0 && rotatedAngle <= 45.0) {
            return 0;
        }
        if (rotatedAngle >= 45.0 && rotatedAngle <= 135.0) {
            return 1;
        }
        if (rotatedAngle >= 135.0 && rotatedAngle <= 225.0) {
            return 2;
        }
        if (rotatedAngle >= 225.0 && rotatedAngle <= 315.0) {
            return 3;
        }
        return 0;
    }

    public static double a(List<KeyPoint> trainKeyPointList, List<KeyPoint> queryKeyPointList, List<DMatch> bestMatches) {
        if (bestMatches.size() < 2) {
            return 0.0;
        }
        Point tPoint1 = trainKeyPointList.get((int)bestMatches.get((int)0).trainIdx).pt;
        Point tPoint2 = trainKeyPointList.get((int)bestMatches.get((int)1).trainIdx).pt;
        Point qPoint1 = queryKeyPointList.get((int)bestMatches.get((int)0).queryIdx).pt;
        Point qPoint2 = queryKeyPointList.get((int)bestMatches.get((int)1).queryIdx).pt;
        double tTan = (tPoint1.y - tPoint2.y) / (tPoint1.x - tPoint2.x);
        double addDegreeT = cn.testin.cv.d.a(tPoint1.y - tPoint2.y, tPoint1.x - tPoint2.x);
        double qTan = (qPoint1.y - qPoint2.y) / (qPoint1.x - qPoint2.x);
        double addDegreeQ = cn.testin.cv.d.a(qPoint1.y - qPoint2.y, qPoint1.x - qPoint2.x);
        double angle1 = Math.toDegrees(Math.atan(tTan)) + addDegreeT;
        double angle2 = Math.toDegrees(Math.atan(qTan)) + addDegreeQ;
        double rotatedAngle = angle2 - angle1;
        if (Double.isInfinite(rotatedAngle) || Double.isNaN(rotatedAngle)) {
            rotatedAngle = 0.0;
        }
        return rotatedAngle;
    }

    private static double a(double value1, double value2) {
        if (value1 >= 0.0 && value2 >= 0.0) {
            return 0.0;
        }
        if (value1 >= 0.0 && value2 <= 0.0) {
            return 180.0;
        }
        if (value1 <= 0.0 && value2 <= 0.0) {
            return 180.0;
        }
        if (value1 <= 0.0 && value2 >= 0.0) {
            return 360.0;
        }
        return 0.0;
    }

    public static double b(List<KeyPoint> trainKeyPointList, List<KeyPoint> queryKeyPointList, List<DMatch> bestMatches) {
        double resizeRate = 1.0;
        if (bestMatches != null && bestMatches.size() >= 2) {
            double distanceTrain = cn.testin.cv.d.a(trainKeyPointList.get((int)bestMatches.get((int)0).trainIdx).pt, trainKeyPointList.get((int)bestMatches.get((int)1).trainIdx).pt);
            double distanceQuery = cn.testin.cv.d.a(queryKeyPointList.get((int)bestMatches.get((int)0).queryIdx).pt, queryKeyPointList.get((int)bestMatches.get((int)1).queryIdx).pt);
            resizeRate = distanceQuery / distanceTrain;
        }
        if (Double.isInfinite(resizeRate) || Double.isNaN(resizeRate)) {
            resizeRate = 1.0;
        }
        return resizeRate;
    }

    public static Point a(List<KeyPoint> trainKeyPointList, List<KeyPoint> queryKeyPointList, List<DMatch> bestMatches, double resizeRate, int trainWidth, int trainHeight, int rotation) {
        if (bestMatches == null || bestMatches.size() == 0) {
            return null;
        }
        if (bestMatches.size() == 1) {
            Point trainMatch = trainKeyPointList.get((int)bestMatches.get((int)0).trainIdx).pt;
            Point queryMatch = queryKeyPointList.get((int)bestMatches.get((int)0).queryIdx).pt;
            Point startPoint = new Point(Math.abs(queryMatch.x - trainMatch.x), Math.abs(queryMatch.y - trainMatch.y));
            return startPoint;
        }
        Point trainMatch = trainKeyPointList.get((int)bestMatches.get((int)0).trainIdx).pt;
        Point queryMatch = queryKeyPointList.get((int)bestMatches.get((int)0).queryIdx).pt;
        Point startPoint = null;
        if (rotation == 0) {
            startPoint = new Point(Math.abs(queryMatch.x - trainMatch.x * resizeRate), Math.abs(queryMatch.y - trainMatch.y * resizeRate));
        } else if (rotation == 1) {
            startPoint = new Point(Math.abs(queryMatch.x - ((double)trainHeight - trainMatch.y) * resizeRate), Math.abs(queryMatch.y - trainMatch.x * resizeRate));
        } else if (rotation == 2) {
            startPoint = new Point(Math.abs(queryMatch.x - ((double)trainWidth - trainMatch.x) * resizeRate), Math.abs(queryMatch.y - ((double)trainHeight - trainMatch.y) * resizeRate));
        } else if (rotation == 3) {
            startPoint = new Point(Math.abs(queryMatch.x - trainMatch.y * resizeRate), Math.abs(queryMatch.y - ((double)trainWidth - trainMatch.x) * resizeRate));
        }
        return startPoint;
    }

    private static double a(Point point1, Point point2) {
        if (point1 == null || point2 == null) {
            return 0.0;
        }
        return Math.sqrt(Math.pow(Math.abs(point1.x - point2.x), 2.0) + Math.pow(Math.abs(point1.y - point2.y), 2.0));
    }

    private static List<DMatch> a(List<DMatch> matchList) {
        if (matchList == null || matchList.size() < 2) {
            return matchList;
        }
        double minDistance = 1000.0;
        double secondlyMinDistance = 1000.0;
        int minIndex = 0;
        int secondMinIndex = 0;
        int i2 = 0;
        while (i2 < matchList.size()) {
            if ((double)matchList.get((int)i2).distance < minDistance) {
                minDistance = matchList.get((int)i2).distance;
                minIndex = i2;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < matchList.size()) {
            if ((double)matchList.get((int)i2).distance > minDistance && (double)matchList.get((int)i2).distance < secondlyMinDistance && matchList.get((int)i2).queryIdx != matchList.get((int)minIndex).queryIdx && matchList.get((int)i2).trainIdx != matchList.get((int)minIndex).trainIdx) {
                secondlyMinDistance = matchList.get((int)i2).distance;
                secondMinIndex = i2;
            }
            ++i2;
        }
        ArrayList<DMatch> twoBestMatches = new ArrayList<DMatch>();
        twoBestMatches.add(matchList.get(minIndex));
        twoBestMatches.add(matchList.get(secondMinIndex));
        return twoBestMatches;
    }

    public static f a(c imgobj) {
        return imgobj.c();
    }

    public static void a(String title, Mat smallImg, Mat largeImg, MatOfKeyPoint smallKeyPoints, MatOfKeyPoint largeKeyPoints, MatOfDMatch matches) {
        Mat img_matches = new Mat();
        Features2d.drawMatches((Mat)largeImg, (MatOfKeyPoint)largeKeyPoints, (Mat)smallImg, (MatOfKeyPoint)smallKeyPoints, (MatOfDMatch)matches, (Mat)img_matches);
        cn.testin.cv.d.a("Matches", img_matches);
    }

    public static void a(String title, Mat img2show) {
        cn.testin.cv.d.a(title, img2show, 1400, 780);
    }

    public static void a(String title, Mat img2show, int maxWidth, int maxHeight) {
        int height;
        double heightResizeRate;
        if (img2show == null) {
            log.error((Object)"img2show is invalid, unable to render the picture.");
            return;
        }
        int width = img2show.cols();
        double widthResizeRate = (double)maxWidth / (double)width;
        double resizeRate = Math.min(widthResizeRate, heightResizeRate = (double)maxHeight / (double)(height = img2show.rows()));
        if (resizeRate > 1.0) {
            resizeRate = 1.0;
        }
        img2show = cn.testin.cv.d.a(img2show, resizeRate);
        Imshow im = new Imshow(title);
        im.showImage(img2show);
    }

    public static Mat a(BufferedImage img) {
        if (img == null || img.getType() != 5) {
            log.error((Object)("img is invalid. unable to process. image: " + img + (img != null ? " type: " + img.getType() : "")));
            return null;
        }
        int width = img.getWidth();
        int height = img.getHeight();
        Mat out = new Mat(height, width, CvType.CV_8UC3);
        byte[] pixels = ((DataBufferByte)img.getRaster().getDataBuffer()).getData();
        out.put(0, 0, pixels);
        return out;
    }

    public static Mat a(String imgPath) {
        if (StringUtils.isEmpty((String)imgPath)) {
            log.error((Object)"imgPath is invalid.");
            return null;
        }
        File imgFile = new File(imgPath);
        if (!imgFile.exists()) {
            log.error((Object)("Image file with path " + imgPath + " doesn't exist."));
            return null;
        }
        try {
            BufferedImage img = ImageIO.read(imgFile);
            if (imgPath.toLowerCase().endsWith(".png")) {
                img = cn.testin.cv.d.a(img);
            }
            return cn.testin.cv.d.a(img);
        }
        catch (IOException e2) {
            log.error((Object)e2.getMessage(), (Throwable)e2);
            return null;
        }
    }

    public static BufferedImage a(BufferedImage pngimg) {
        try {
            BufferedImage newBufferedImage = new BufferedImage(pngimg.getWidth(), pngimg.getHeight(), 5);
            newBufferedImage.createGraphics().drawImage(pngimg, 0, 0, Color.WHITE, null);
            return newBufferedImage;
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return null;
        }
    }

    public static h a(BufferedImage big, int x2, int y2, int width, int height, float i2) {
        h si = new h();
        int sourceW = width + com.testin.itestin.business.actions.utils.d.a((float)width * i2 * 2.0f);
        int sourceH = height + com.testin.itestin.business.actions.utils.d.a((float)height * i2 * 2.0f);
        int temp = com.testin.itestin.business.actions.utils.d.a((float)x2 - (float)width * i2);
        int sourceX = temp > 0 ? temp : 0;
        temp = com.testin.itestin.business.actions.utils.d.a(y2 - height * 1);
        int sourceY = temp > 0 ? temp : 0;
        sourceW = sourceX + sourceW < big.getWidth() ? sourceW : big.getWidth() - sourceX;
        sourceH = sourceY + sourceH < big.getHeight() ? sourceH : big.getHeight() - sourceY;
        log.info((Object)String.format("W=%s, H=%s, sub image: [%s, %s], w=%s, h=%s", big.getWidth(), big.getHeight(), sourceX, sourceY, sourceW, sourceH));
        si.setBufferedImage(big.getSubimage(sourceX, sourceY, sourceW, sourceH));
        si.a(new java.awt.Point(sourceX, sourceY));
        si.b(new java.awt.Point(x2 - sourceX, y2 - sourceY));
        return si;
    }

    public static BufferedImage a(BufferedImage template, int scriptW, int scriptH, int width, int height) {
        float hh;
        float ww;
        int scaleW = scriptW;
        int scaleH = scriptH;
        float scale = 0.0f;
        int w2 = 0;
        int h2 = 0;
        if (scaleW > width || scaleH > height) {
            ww = scriptW;
            hh = scriptH;
            scale = ww / (float)width > hh / (float)height ? ww / (float)width : hh / (float)height;
            w2 = com.testin.itestin.business.actions.utils.d.a((float)template.getWidth() / scale);
            h2 = com.testin.itestin.business.actions.utils.d.a((float)template.getHeight() / scale);
        } else {
            ww = scriptW;
            hh = scriptH;
            scale = (float)width / ww > (float)height / hh ? (float)height / hh : (float)width / ww;
            w2 = com.testin.itestin.business.actions.utils.d.a((float)template.getWidth() * scale);
            h2 = com.testin.itestin.business.actions.utils.d.a((float)template.getHeight() * scale);
        }
        BufferedImage thu = new BufferedImage(w2, h2, 6);
        Graphics2D g2 = thu.createGraphics();
        g2.drawImage(template, 0, 0, w2, h2, null);
        g2.dispose();
        Thumbnailator.createThumbnail((BufferedImage)template, (int)w2, (int)h2);
        return thu;
    }

    public static void f() {
        if (!cn.testin.cv.d.c() && !g) {
            g = true;
            new Thread(){

                @Override
                public void run() {
                    if (cn.testin.cv.d.b()) {
                        cn.testin.cv.d.b(true);
                        com.testin.itestin.business.actions.utils.f.aa("OK");
                    } else {
                        g = false;
                        com.testin.itestin.business.actions.utils.f.aa("NOK");
                    }
                }
            }.start();
        }
    }

    public static boolean b() {
        com.testin.itestin.business.actions.utils.a.al();
        String libName = "";
        String platform = System.getProperty("os.name");
        log.info((Object)("Current OS Name: " + platform));
        if (platform.startsWith("Linux")) {
            File t2;
            if (System.getProperty("sun.arch.data.model").equals("32")) {
                t2 = new File(String.valueOf(com.testin.itestin.business.actions.utils.a.aa()) + File.separator + "OpenCV" + File.separator + "linux" + File.separator + "x86" + File.separator + "libopencv_java2410.so");
                libName = t2.exists() ? t2.getAbsolutePath() : "/data/itestin-m/tools/OpenCV/linux/x86/libopencv_java2410.so";
            } else if (System.getProperty("sun.arch.data.model").equals("64")) {
                t2 = new File(String.valueOf(com.testin.itestin.business.actions.utils.a.aa()) + File.separator + "OpenCV" + File.separator + "linux" + File.separator + "x64" + File.separator + "libopencv_java2410.so");
                libName = t2.exists() ? t2.getAbsolutePath() : "/data/itestin-m/tools/OpenCV/linux/x64/libopencv_java2410.so";
            }
        } else if (platform.startsWith("Windows")) {
            if (System.getProperty("sun.arch.data.model").equals("32")) {
                libName = new File(String.valueOf(com.testin.itestin.business.actions.utils.a.aa()) + File.separator + "OpenCV" + File.separator + "windows" + File.separator + "x86" + File.separator + "opencv_java2410.dll").getAbsolutePath();
            } else if (System.getProperty("sun.arch.data.model").equals("64")) {
                libName = new File(String.valueOf(com.testin.itestin.business.actions.utils.a.aa()) + File.separator + "OpenCV" + File.separator + "windows" + File.separator + "x64" + File.separator + "opencv_java2410.dll").getAbsolutePath();
            }
        } else if (platform.startsWith("Mac")) {
            StringBuilder opencvDylibPathBuilder = new StringBuilder(com.testin.itestin.business.actions.utils.a.aa());
            opencvDylibPathBuilder.append(File.separator);
            opencvDylibPathBuilder.append("OpenCV");
            opencvDylibPathBuilder.append(File.separator);
            opencvDylibPathBuilder.append("mac");
            opencvDylibPathBuilder.append(File.separator);
            opencvDylibPathBuilder.append("libopencv_java2410.dylib");
            libName = opencvDylibPathBuilder.toString();
        }
        log.info((Object)("Load openCV library from " + libName));
        File dllFile = new File(libName);
        try {
            InputStream inputStream = d.class.getResourceAsStream(libName);
            log.info((Object)("dllFile exist: " + dllFile.exists()));
            if (!dllFile.exists()) {
                FileOutputStream outputStream = new FileOutputStream(dllFile);
                byte[] array = new byte[1024];
                int bytesRead = -1;
                while ((bytesRead = inputStream.read(array)) != -1) {
                    outputStream.write(array, 0, bytesRead);
                }
                outputStream.flush();
                outputStream.close();
            }
            System.load(dllFile.getPath());
            log.info((Object)("load dll success from " + libName));
            if (b.F()) {
                cn.testin.cv.d.f(libName);
            }
            return true;
        }
        catch (UnsatisfiedLinkError err) {
            log.error((Object)err.getMessage(), (Throwable)err);
            return false;
        }
        catch (Throwable e2) {
            e2.printStackTrace();
            log.error((Object)e2.getMessage(), e2);
            return false;
        }
    }

    public static void g() {
        new Thread(){

            @Override
            public void run() {
                log.info((Object)"Load OpenCV library.");
                cn.testin.cv.d.b();
            }
        }.start();
    }

    public static String d() {
        return e;
    }

    public static void f(String lIBFILENAME) {
        e = lIBFILENAME;
    }

    public static boolean c() {
        return f;
    }

    public static void b(boolean dllLoaded) {
        f = dllLoaded;
    }

    public static boolean isDebug() {
        return c;
    }

    public static void setDebug(boolean isDebug) {
        c = isDebug;
    }

    public static void a(String imagePath, double resizeRate, String savePath) {
        try {
            Mat image2resize = Highgui.imread((String)imagePath);
            Mat result = new Mat();
            Imgproc.resize((Mat)image2resize, (Mat)result, (Size)new Size((double)image2resize.cols() * resizeRate, (double)image2resize.rows() * resizeRate));
            Highgui.imwrite((String)savePath, (Mat)result);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public static Mat a(Mat originalMat, double resizeRate) {
        Mat image2resize = originalMat;
        try {
            Mat result = new Mat();
            Imgproc.resize((Mat)image2resize, (Mat)result, (Size)new Size((double)image2resize.cols() * resizeRate, (double)image2resize.rows() * resizeRate));
            return result;
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return image2resize;
        }
    }

    public static void h() {
        cn.testin.cv.d.a();
        String sourceImg = "/Users/xiechunhong/Desktop/runOpenCV/test/test10/train_120_270.png";
        String templateImg = "/Users/xiechunhong/Desktop/runOpenCV/test/test10/query.png";
        Mat source = Highgui.imread((String)sourceImg);
        Mat template = Highgui.imread((String)templateImg);
        cn.testin.cv.d.a(template, source);
    }

    public static void i() {
        cn.testin.cv.d.a();
        String sourceImg = "/Users/xiechunhong/Documents/workspace/iTestinFxSVN/script/air.com.bbfriend.ddsz_2.3.500_dir/script_003_dir/img/1441792690185_9342b3a51070903fb383b7c122695c95_shot_1441864161105.png";
        String templateImg = "/Users/xiechunhong/Documents/workspace/iTestinFxSVN/script/air.com.bbfriend.ddsz_2.3.500_dir/script_003_dir/img/1441792698074_a24ce6073d933579f016c6615f4fb423.png";
        long t1 = System.currentTimeMillis();
        c imgobj = new c(sourceImg, templateImg, new Point(440.0, 337.0), 720, 1280, 1, 2.0);
        imgobj.c();
        long t2 = System.currentTimeMillis();
        log.info((Object)("TimeConsumed: " + (t2 - t1)));
    }

    public static void a(String sourceImg, String templateImg, int startX, int startY, int originalWidth, int originalHeight, int rotation, double searchAreaFactor, double diffThreshold) {
        long t1 = System.currentTimeMillis();
        c imgobj = new c(sourceImg, templateImg, new Point((double)startX, (double)startY), originalWidth, originalHeight, rotation, searchAreaFactor, diffThreshold);
        f result = imgobj.c();
        long t2 = System.currentTimeMillis();
        log.info((Object)("TimeConsumed: " + (t2 - t1)));
        System.out.println("Result:\n" + result);
        if (result != null && result.d()) {
            System.out.println("SUCCESSFUL COUNT: " + ++f + "  TimeConsumed: " + (t2 - t1));
        } else {
            System.out.println("FAILED COUNT: " + ++g + "  TimeConsumed: " + (t2 - t1));
        }
    }

    private static void a() {
        cn.testin.cv.d.b();
    }

    public static void main(String[] args) throws IOException, InterruptedException {
        log.info((Object)Math.asin(-1.0));
        log.info((Object)Math.toDegrees(Math.asin(-0.5)));
    }
}

