/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.feature.detect.intensity;

import boofcv.alg.feature.detect.intensity.FastCornerIntensity;
import boofcv.alg.feature.detect.intensity.HarrisCornerIntensity;
import boofcv.alg.feature.detect.intensity.ShiTomasiCornerIntensity;
import boofcv.alg.feature.detect.intensity.impl.FastHelper;
import boofcv.alg.feature.detect.intensity.impl.ImplFastHelper_F32;
import boofcv.alg.feature.detect.intensity.impl.ImplFastHelper_U8;
import boofcv.alg.feature.detect.intensity.impl.ImplFastIntensity10;
import boofcv.alg.feature.detect.intensity.impl.ImplFastIntensity11;
import boofcv.alg.feature.detect.intensity.impl.ImplFastIntensity12;
import boofcv.alg.feature.detect.intensity.impl.ImplFastIntensity9;
import boofcv.alg.feature.detect.intensity.impl.ImplHarrisCornerWeighted_F32;
import boofcv.alg.feature.detect.intensity.impl.ImplHarrisCornerWeighted_S16;
import boofcv.alg.feature.detect.intensity.impl.ImplHarrisCorner_F32;
import boofcv.alg.feature.detect.intensity.impl.ImplHarrisCorner_S16;
import boofcv.alg.feature.detect.intensity.impl.ImplShiTomasiCornerWeighted_F32;
import boofcv.alg.feature.detect.intensity.impl.ImplShiTomasiCornerWeighted_S16;
import boofcv.alg.feature.detect.intensity.impl.ImplShiTomasiCorner_F32;
import boofcv.alg.feature.detect.intensity.impl.ImplShiTomasiCorner_S16;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageSInt16;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.image.ImageUInt8;

public class FactoryIntensityPointAlg {
    public static <T extends ImageSingleBand> FastCornerIntensity<T> fast(int pixelTol, int minCont, Class<T> imageType) {
        FastHelper<ImageFloat32> helper;
        if (imageType == ImageFloat32.class) {
            helper = new ImplFastHelper_F32(pixelTol);
        } else if (imageType == ImageUInt8.class) {
            helper = new ImplFastHelper_U8(pixelTol);
        } else {
            throw new IllegalArgumentException("Unsupported image type " + imageType);
        }
        if (minCont == 9) {
            return new ImplFastIntensity9<ImageFloat32>(helper);
        }
        if (minCont == 10) {
            return new ImplFastIntensity10<ImageFloat32>(helper);
        }
        if (minCont == 11) {
            return new ImplFastIntensity11<ImageFloat32>(helper);
        }
        if (minCont == 12) {
            return new ImplFastIntensity12<ImageFloat32>(helper);
        }
        throw new IllegalArgumentException("Specified minCont is not supported");
    }

    public static <D extends ImageSingleBand> HarrisCornerIntensity<D> harris(int windowRadius, float kappa, boolean weighted, Class<D> derivType) {
        if (derivType == ImageFloat32.class) {
            if (weighted) {
                return new ImplHarrisCornerWeighted_F32(windowRadius, kappa);
            }
            return new ImplHarrisCorner_F32(windowRadius, kappa);
        }
        if (derivType == ImageSInt16.class) {
            if (weighted) {
                return new ImplHarrisCornerWeighted_S16(windowRadius, kappa);
            }
            return new ImplHarrisCorner_S16(windowRadius, kappa);
        }
        throw new IllegalArgumentException("Unknown image type " + derivType);
    }

    public static <D extends ImageSingleBand> ShiTomasiCornerIntensity<D> shiTomasi(int windowRadius, boolean weighted, Class<D> derivType) {
        if (derivType == ImageFloat32.class) {
            if (weighted) {
                return new ImplShiTomasiCornerWeighted_F32(windowRadius);
            }
            return new ImplShiTomasiCorner_F32(windowRadius);
        }
        if (derivType == ImageSInt16.class) {
            if (weighted) {
                return new ImplShiTomasiCornerWeighted_S16(windowRadius);
            }
            return new ImplShiTomasiCorner_S16(windowRadius);
        }
        throw new IllegalArgumentException("Unknown image type " + derivType);
    }
}

