/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.flow;

import boofcv.abst.filter.derivative.ImageGradient;
import boofcv.alg.flow.DenseFlowPyramidBase;
import boofcv.alg.interpolate.InterpolatePixelS;
import boofcv.alg.misc.ImageMiscOps;
import boofcv.factory.filter.derivative.FactoryDerivative;
import boofcv.factory.flow.ConfigHornSchunckPyramid;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.pyramid.ImagePyramid;

public class HornSchunckPyramid<T extends ImageSingleBand>
extends DenseFlowPyramidBase<T> {
    private float alpha2;
    private float SOR_RELAXATION;
    private int numWarps;
    private int maxInnerIterations;
    private float convergeTolerance;
    private ImageGradient<ImageFloat32, ImageFloat32> gradient = FactoryDerivative.three(ImageFloat32.class, ImageFloat32.class);
    private ImageFloat32 deriv2X = new ImageFloat32(1, 1);
    private ImageFloat32 deriv2Y = new ImageFloat32(1, 1);
    protected ImageFloat32 flowX = new ImageFloat32(1, 1);
    protected ImageFloat32 flowY = new ImageFloat32(1, 1);
    protected ImageFloat32 initFlowX = new ImageFloat32(1, 1);
    protected ImageFloat32 initFlowY = new ImageFloat32(1, 1);
    protected ImageFloat32 warpImage2 = new ImageFloat32(1, 1);
    protected ImageFloat32 warpDeriv2X = new ImageFloat32(1, 1);
    protected ImageFloat32 warpDeriv2Y = new ImageFloat32(1, 1);

    public HornSchunckPyramid(ConfigHornSchunckPyramid config, InterpolatePixelS<ImageFloat32> interp) {
        super(config.pyrScale, config.pyrSigma, config.pyrMaxLayers, interp);
        this.alpha2 = config.alpha * config.alpha;
        this.SOR_RELAXATION = config.SOR_RELAXATION;
        this.numWarps = config.numWarps;
        this.maxInnerIterations = config.maxInnerIterations;
        this.interp = interp;
        this.convergeTolerance = config.convergeTolerance;
    }

    @Override
    public void process(ImagePyramid<ImageFloat32> image1, ImagePyramid<ImageFloat32> image2) {
        boolean first = true;
        for (int i = image1.getNumLayers() - 1; i >= 0; --i) {
            ImageFloat32 layer1 = (ImageFloat32)image1.getLayer(i);
            ImageFloat32 layer2 = (ImageFloat32)image2.getLayer(i);
            this.deriv2X.reshape(layer1.width, layer1.height);
            this.deriv2Y.reshape(layer1.width, layer1.height);
            this.warpDeriv2X.reshape(layer1.width, layer1.height);
            this.warpDeriv2Y.reshape(layer1.width, layer1.height);
            this.warpImage2.reshape(layer1.width, layer1.height);
            this.gradient.process((ImageBase)layer2, (ImageBase)this.deriv2X, (ImageBase)this.deriv2Y);
            if (!first) {
                this.interpolateFlowScale(layer1.width, layer1.height);
            } else {
                first = false;
                this.initFlowX.reshape(layer1.width, layer1.height);
                this.initFlowY.reshape(layer1.width, layer1.height);
                this.flowX.reshape(layer1.width, layer1.height);
                this.flowY.reshape(layer1.width, layer1.height);
                ImageMiscOps.fill((ImageFloat32)this.flowX, (float)0.0f);
                ImageMiscOps.fill((ImageFloat32)this.flowY, (float)0.0f);
                ImageMiscOps.fill((ImageFloat32)this.initFlowX, (float)0.0f);
                ImageMiscOps.fill((ImageFloat32)this.initFlowY, (float)0.0f);
            }
            this.processLayer(layer1, layer2, this.deriv2X, this.deriv2Y);
        }
    }

    protected void interpolateFlowScale(int widthNew, int heightNew) {
        this.initFlowX.reshape(widthNew, heightNew);
        this.initFlowY.reshape(widthNew, heightNew);
        this.interpolateFlowScale(this.flowX, this.initFlowX);
        this.interpolateFlowScale(this.flowY, this.initFlowY);
        this.flowX.reshape(widthNew, heightNew);
        this.flowY.reshape(widthNew, heightNew);
        this.flowX.setTo((ImageSingleBand)this.initFlowX);
        this.flowY.setTo((ImageSingleBand)this.initFlowY);
    }

    @Override
    protected void interpolateFlowScale(ImageFloat32 prev, ImageFloat32 curr) {
        this.interp.setImage((ImageBase)prev);
        float scaleX = (float)(prev.width - 1) / (float)(curr.width - 1) * 0.999f;
        float scaleY = (float)(prev.height - 1) / (float)(curr.height - 1) * 0.999f;
        float scale = (float)prev.width / (float)curr.width;
        int indexCurr = 0;
        for (int y = 0; y < curr.height; ++y) {
            for (int x = 0; x < curr.width; ++x) {
                curr.data[indexCurr++] = this.interp.get((float)x * scaleX, (float)y * scaleY) / scale;
            }
        }
    }

    @Override
    protected void warpImageTaylor(ImageFloat32 before, ImageFloat32 flowX, ImageFloat32 flowY, ImageFloat32 after) {
        this.interp.setImage((ImageBase)before);
        for (int y = 0; y < before.height; ++y) {
            int pixelIndex = y * before.width;
            int x = 0;
            while (x < before.width) {
                float u = flowX.data[pixelIndex];
                float v = flowY.data[pixelIndex];
                float wx = (float)x + u;
                float wy = (float)y + v;
                after.data[pixelIndex] = wx < 0.0f || wx > (float)(before.width - 1) || wy < 0.0f || wy > (float)(before.height - 1) ? 0.0f : this.interp.get(wx, wy);
                ++x;
                ++pixelIndex;
            }
        }
    }

    protected void processLayer(ImageFloat32 image1, ImageFloat32 image2, ImageFloat32 derivX2, ImageFloat32 derivY2) {
        float w = this.SOR_RELAXATION;
        for (int warp = 0; warp < this.numWarps; ++warp) {
            float error;
            this.initFlowX.setTo((ImageSingleBand)this.flowX);
            this.initFlowY.setTo((ImageSingleBand)this.flowY);
            this.warpImageTaylor(derivX2, this.initFlowX, this.initFlowY, this.warpDeriv2X);
            this.warpImageTaylor(derivY2, this.initFlowX, this.initFlowY, this.warpDeriv2Y);
            this.warpImageTaylor(image2, this.initFlowX, this.initFlowY, this.warpImage2);
            int iter = 0;
            do {
                int x;
                error = 0.0f;
                for (int y = 1; y < image1.height - 1; ++y) {
                    int pixelIndex = y * image1.width + 1;
                    x = 1;
                    while (x < image1.width - 1) {
                        float vf;
                        float uf;
                        float ui = this.initFlowX.data[pixelIndex];
                        float vi = this.initFlowY.data[pixelIndex];
                        float u = this.flowX.data[pixelIndex];
                        float v = this.flowY.data[pixelIndex];
                        float I1 = image1.data[pixelIndex];
                        float I2 = this.warpImage2.data[pixelIndex];
                        float I2x = this.warpDeriv2X.data[pixelIndex];
                        float I2y = this.warpDeriv2Y.data[pixelIndex];
                        float AU = HornSchunckPyramid.A(x, y, this.flowX);
                        float AV = HornSchunckPyramid.A(x, y, this.flowY);
                        this.flowX.data[pixelIndex] = uf = (1.0f - w) * u + w * ((I1 - I2 + I2x * ui - I2y * (v - vi)) * I2x + this.alpha2 * AU) / (I2x * I2x + this.alpha2);
                        this.flowY.data[pixelIndex] = vf = (1.0f - w) * v + w * ((I1 - I2 + I2y * vi - I2x * (uf - ui)) * I2y + this.alpha2 * AV) / (I2y * I2y + this.alpha2);
                        error += (uf - u) * (uf - u) + (vf - v) * (vf - v);
                        ++x;
                        ++pixelIndex;
                    }
                }
                int pixelIndex0 = 0;
                int pixelIndex1 = (image1.height - 1) * image1.width;
                for (x = 0; x < image1.width; ++x) {
                    error += this.iterationSorSafe(image1, x, 0, pixelIndex0++);
                    error += this.iterationSorSafe(image1, x, image1.height - 1, pixelIndex1++);
                }
                pixelIndex0 = image1.width;
                pixelIndex1 = image1.width + image1.width - 1;
                for (int y = 1; y < image1.height - 1; ++y) {
                    error += this.iterationSorSafe(image1, 0, y, pixelIndex0);
                    error += this.iterationSorSafe(image1, image1.width - 1, y, pixelIndex1);
                    pixelIndex0 += image1.width;
                    pixelIndex1 += image1.width;
                }
            } while (error > this.convergeTolerance * (float)image1.width * (float)image1.height && ++iter < this.maxInnerIterations);
        }
    }

    private float iterationSorSafe(ImageFloat32 image1, int x, int y, int pixelIndex) {
        float vf;
        float uf;
        float w = this.SOR_RELAXATION;
        float ui = this.initFlowX.data[pixelIndex];
        float vi = this.initFlowY.data[pixelIndex];
        float u = this.flowX.data[pixelIndex];
        float v = this.flowY.data[pixelIndex];
        float I1 = image1.data[pixelIndex];
        float I2 = this.warpImage2.data[pixelIndex];
        float I2x = this.warpDeriv2X.data[pixelIndex];
        float I2y = this.warpDeriv2Y.data[pixelIndex];
        float AU = HornSchunckPyramid.A_safe(x, y, this.flowX);
        float AV = HornSchunckPyramid.A_safe(x, y, this.flowY);
        this.flowX.data[pixelIndex] = uf = (1.0f - w) * u + w * ((I1 - I2 + I2x * ui - I2y * (v - vi)) * I2x + this.alpha2 * AU) / (I2x * I2x + this.alpha2);
        this.flowY.data[pixelIndex] = vf = (1.0f - w) * v + w * ((I1 - I2 + I2y * vi - I2x * (uf - ui)) * I2y + this.alpha2 * AV) / (I2y * I2y + this.alpha2);
        return (uf - u) * (uf - u) + (vf - v) * (vf - v);
    }

    protected static float A_safe(int x, int y, ImageFloat32 flow) {
        float u0 = HornSchunckPyramid.safe(x - 1, y, flow);
        float u1 = HornSchunckPyramid.safe(x + 1, y, flow);
        float u2 = HornSchunckPyramid.safe(x, y - 1, flow);
        float u3 = HornSchunckPyramid.safe(x, y + 1, flow);
        float u4 = HornSchunckPyramid.safe(x - 1, y - 1, flow);
        float u5 = HornSchunckPyramid.safe(x + 1, y - 1, flow);
        float u6 = HornSchunckPyramid.safe(x - 1, y + 1, flow);
        float u7 = HornSchunckPyramid.safe(x + 1, y + 1, flow);
        return 0.16666667f * (u0 + u1 + u2 + u3) + 0.083333336f * (u4 + u5 + u6 + u7);
    }

    protected static float A(int x, int y, ImageFloat32 flow) {
        int index = flow.getIndex(x, y);
        float u0 = flow.data[index - 1];
        float u1 = flow.data[index + 1];
        float u2 = flow.data[index - flow.stride];
        float u3 = flow.data[index + flow.stride];
        float u4 = flow.data[index - 1 - flow.stride];
        float u5 = flow.data[index + 1 - flow.stride];
        float u6 = flow.data[index - 1 + flow.stride];
        float u7 = flow.data[index + 1 + flow.stride];
        return 0.16666667f * (u0 + u1 + u2 + u3) + 0.083333336f * (u4 + u5 + u6 + u7);
    }

    protected static float safe(int x, int y, ImageFloat32 image) {
        if (x < 0) {
            x = 0;
        } else if (x >= image.width) {
            x = image.width - 1;
        }
        if (y < 0) {
            y = 0;
        } else if (y >= image.height) {
            y = image.height - 1;
        }
        return image.unsafe_get(x, y);
    }

    public ImageFloat32 getFlowX() {
        return this.flowX;
    }

    public ImageFloat32 getFlowY() {
        return this.flowY;
    }
}

