/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.flow;

import boofcv.alg.flow.UtilDenseOpticalFlow;
import boofcv.alg.interpolate.InterpolatePixelS;
import boofcv.alg.misc.GImageStatistics;
import boofcv.core.image.GConvertImage;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.pyramid.ImagePyramid;
import boofcv.struct.pyramid.PyramidFloat;

public abstract class DenseFlowPyramidBase<T extends ImageSingleBand> {
    private ImageFloat32 norm1 = new ImageFloat32(1, 1);
    private ImageFloat32 norm2 = new ImageFloat32(1, 1);
    private double scale;
    private double sigma;
    private int maxLayers;
    protected PyramidFloat<ImageFloat32> pyr1;
    protected PyramidFloat<ImageFloat32> pyr2;
    protected InterpolatePixelS<ImageFloat32> interp;

    public DenseFlowPyramidBase(double scale, double sigma, int maxLayers, InterpolatePixelS<ImageFloat32> interp) {
        this.scale = scale;
        this.sigma = sigma;
        this.maxLayers = maxLayers;
        this.interp = interp;
    }

    public void process(T image1, T image2) {
        if (this.pyr1 == null || this.pyr1.getInputWidth() != ((ImageSingleBand)image1).width || this.pyr1.getInputHeight() != ((ImageSingleBand)image1).height) {
            this.pyr1 = UtilDenseOpticalFlow.standardPyramid(((ImageSingleBand)image1).width, ((ImageSingleBand)image1).height, this.scale, this.sigma, 5, this.maxLayers, ImageFloat32.class);
            this.pyr2 = UtilDenseOpticalFlow.standardPyramid(((ImageSingleBand)image1).width, ((ImageSingleBand)image1).height, this.scale, this.sigma, 5, this.maxLayers, ImageFloat32.class);
            this.pyr1.initialize(((ImageSingleBand)image1).width, ((ImageSingleBand)image1).height);
            this.pyr2.initialize(((ImageSingleBand)image1).width, ((ImageSingleBand)image1).height);
        }
        this.norm1.reshape(((ImageSingleBand)image1).width, ((ImageSingleBand)image1).height);
        this.norm2.reshape(((ImageSingleBand)image1).width, ((ImageSingleBand)image1).height);
        DenseFlowPyramidBase.imageNormalization(image1, image2, this.norm1, this.norm2);
        this.pyr1.process((ImageBase)this.norm1);
        this.pyr2.process((ImageBase)this.norm2);
        this.process((ImagePyramid<ImageFloat32>)this.pyr1, (ImagePyramid<ImageFloat32>)this.pyr2);
    }

    protected void interpolateFlowScale(ImageFloat32 prev, ImageFloat32 curr) {
        this.interp.setImage((ImageBase)prev);
        float scaleX = (float)(prev.width - 1) / (float)(curr.width - 1) * 0.999f;
        float scaleY = (float)(prev.height - 1) / (float)(curr.height - 1) * 0.999f;
        float scale = (float)prev.width / (float)curr.width;
        int indexCurr = 0;
        for (int y = 0; y < curr.height; ++y) {
            for (int x = 0; x < curr.width; ++x) {
                curr.data[indexCurr++] = this.interp.get((float)x * scaleX, (float)y * scaleY) / scale;
            }
        }
    }

    protected void warpImageTaylor(ImageFloat32 before, ImageFloat32 flowX, ImageFloat32 flowY, ImageFloat32 after) {
        this.interp.setImage((ImageBase)before);
        for (int y = 0; y < before.height; ++y) {
            int pixelIndex = y * before.width;
            int x = 0;
            while (x < before.width) {
                float u = flowX.data[pixelIndex];
                float v = flowY.data[pixelIndex];
                float wx = (float)x + u;
                float wy = (float)y + v;
                after.data[pixelIndex] = wx < 0.0f || wx > (float)(before.width - 1) || wy < 0.0f || wy > (float)(before.height - 1) ? 0.0f : this.interp.get(wx, wy);
                ++x;
                ++pixelIndex;
            }
        }
    }

    public abstract void process(ImagePyramid<ImageFloat32> var1, ImagePyramid<ImageFloat32> var2);

    protected static <T extends ImageSingleBand> void imageNormalization(T image1, T image2, ImageFloat32 normalized1, ImageFloat32 normalized2) {
        float min2;
        float min1;
        float min;
        float max2;
        float max1 = (float)GImageStatistics.max(image1);
        float max = max1 > (max2 = (float)GImageStatistics.max(image2)) ? max1 : max2;
        float range = max - (min = (min1 = (float)GImageStatistics.min(image1)) < (min2 = (float)GImageStatistics.min(image2)) ? min1 : min2);
        if (range > 0.0f) {
            int indexN = 0;
            for (int y = 0; y < image1.height; ++y) {
                int x = 0;
                while (x < image1.width) {
                    float pv1 = (float)GeneralizedImageOps.get(image1, (int)x, (int)y);
                    float pv2 = (float)GeneralizedImageOps.get(image2, (int)x, (int)y);
                    normalized1.data[indexN] = (pv1 - min) / range;
                    normalized2.data[indexN] = (pv2 - min) / range;
                    ++x;
                    ++indexN;
                }
            }
        } else {
            GConvertImage.convert(image1, (ImageBase)normalized1);
            GConvertImage.convert(image2, (ImageBase)normalized2);
        }
    }
}

