/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.orientation;

import boofcv.abst.feature.orientation.OrientationIntegral;
import boofcv.alg.feature.describe.SurfDescribeOps;
import boofcv.factory.filter.kernel.FactoryKernelGaussian;
import boofcv.struct.convolve.Kernel2D_F64;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.sparse.GradientValue;
import boofcv.struct.sparse.SparseScaleGradient;

public abstract class OrientationIntegralBase<II extends ImageSingleBand, G extends GradientValue>
implements OrientationIntegral<II> {
    protected II ii;
    protected double scale = 1.0;
    protected int radius;
    protected int width;
    protected Kernel2D_F64 weights;
    protected int sampleWidth;
    protected double period;
    protected SparseScaleGradient<II, G> g;
    Class<II> integralType;

    public OrientationIntegralBase(int radius, double period, int sampleWidth, double weightSigma, Class<II> integralType) {
        this.radius = radius;
        this.period = period;
        this.sampleWidth = sampleWidth;
        this.width = radius * 2 + 1;
        this.integralType = integralType;
        if (weightSigma != 0.0) {
            this.weights = (Kernel2D_F64)FactoryKernelGaussian.gaussian((int)2, (boolean)true, (int)64, (double)weightSigma, (int)radius);
        }
        this.g = SurfDescribeOps.createGradient(false, sampleWidth, integralType);
    }

    @Override
    public void setScale(double scale) {
        this.scale = scale;
        this.g.setScale(scale);
    }

    @Override
    public void setImage(II integralImage) {
        this.ii = integralImage;
        this.g.setImage(this.ii);
    }

    @Override
    public Class<II> getImageType() {
        return this.integralType;
    }
}

