/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.disparity.impl;

import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageSInt16;
import boofcv.struct.image.ImageUInt8;

public class UtilDisparityScore {
    public static void computeScoreRow(ImageUInt8 left, ImageUInt8 right, int row, int[] scores, int minDisparity, int maxDisparity, int regionWidth, int[] elementScore) {
        for (int d = minDisparity; d < maxDisparity; ++d) {
            int dispFromMin = d - minDisparity;
            int colMax = left.width - d;
            int scoreMax = colMax - regionWidth;
            int indexScore = left.width * dispFromMin + dispFromMin;
            int indexLeft = left.startIndex + left.stride * row + d;
            int indexRight = right.startIndex + right.stride * row;
            UtilDisparityScore.computeScoreRowSad(left, right, colMax, indexLeft, indexRight, elementScore);
            int score = 0;
            for (int i = 0; i < regionWidth; ++i) {
                score += elementScore[i];
            }
            scores[indexScore++] = score;
            int col = 0;
            while (col < scoreMax) {
                scores[indexScore] = score += elementScore[col + regionWidth] - elementScore[col];
                ++col;
                ++indexScore;
            }
        }
    }

    public static void computeScoreRowSad(ImageUInt8 left, ImageUInt8 right, int elementMax, int indexLeft, int indexRight, int[] elementScore) {
        for (int rCol = 0; rCol < elementMax; ++rCol) {
            int diff = (left.data[indexLeft++] & 0xFF) - (right.data[indexRight++] & 0xFF);
            elementScore[rCol] = Math.abs(diff);
        }
    }

    public static void computeScoreRow(ImageSInt16 left, ImageSInt16 right, int row, int[] scores, int minDisparity, int maxDisparity, int regionWidth, int[] elementScore) {
        for (int d = minDisparity; d < maxDisparity; ++d) {
            int dispFromMin = d - minDisparity;
            int colMax = left.width - d;
            int scoreMax = colMax - regionWidth;
            int indexScore = left.width * dispFromMin + dispFromMin;
            int indexLeft = left.startIndex + left.stride * row + d;
            int indexRight = right.startIndex + right.stride * row;
            UtilDisparityScore.computeScoreRowSad(left, right, colMax, indexLeft, indexRight, elementScore);
            int score = 0;
            for (int i = 0; i < regionWidth; ++i) {
                score += elementScore[i];
            }
            scores[indexScore++] = score;
            int col = 0;
            while (col < scoreMax) {
                scores[indexScore] = score += elementScore[col + regionWidth] - elementScore[col];
                ++col;
                ++indexScore;
            }
        }
    }

    public static void computeScoreRowSad(ImageSInt16 left, ImageSInt16 right, int elementMax, int indexLeft, int indexRight, int[] elementScore) {
        for (int rCol = 0; rCol < elementMax; ++rCol) {
            int diff = left.data[indexLeft++] - right.data[indexRight++];
            elementScore[rCol] = Math.abs(diff);
        }
    }

    public static void computeScoreRow(ImageFloat32 left, ImageFloat32 right, int row, float[] scores, int minDisparity, int maxDisparity, int regionWidth, float[] elementScore) {
        for (int d = minDisparity; d < maxDisparity; ++d) {
            int dispFromMin = d - minDisparity;
            int colMax = left.width - d;
            int scoreMax = colMax - regionWidth;
            int indexScore = left.width * dispFromMin + dispFromMin;
            int indexLeft = left.startIndex + left.stride * row + d;
            int indexRight = right.startIndex + right.stride * row;
            UtilDisparityScore.computeScoreRowSad(left, right, colMax, indexLeft, indexRight, elementScore);
            float score = 0.0f;
            for (int i = 0; i < regionWidth; ++i) {
                score += elementScore[i];
            }
            scores[indexScore++] = score;
            int col = 0;
            while (col < scoreMax) {
                scores[indexScore] = score += elementScore[col + regionWidth] - elementScore[col];
                ++col;
                ++indexScore;
            }
        }
    }

    public static void computeScoreRowSad(ImageFloat32 left, ImageFloat32 right, int elementMax, int indexLeft, int indexRight, float[] elementScore) {
        for (int rCol = 0; rCol < elementMax; ++rCol) {
            float diff = left.data[indexLeft++] - right.data[indexRight++];
            elementScore[rCol] = Math.abs(diff);
        }
    }
}

