/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.intensity.impl;

import boofcv.alg.InputSanityCheck;
import boofcv.alg.feature.detect.intensity.GradientCornerIntensity;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageSingleBand;

public abstract class ImplSsdCornerBase<D extends ImageSingleBand, D2 extends ImageSingleBand>
implements GradientCornerIntensity<D> {
    protected D derivX;
    protected D derivY;
    protected int radius;
    protected D2 horizXX;
    protected D2 horizXY;
    protected D2 horizYY;
    protected int x;
    protected int y;

    public ImplSsdCornerBase(int windowRadius, Class<D2> secondDerivType) {
        this.radius = windowRadius;
        this.horizXX = GeneralizedImageOps.createSingleBand(secondDerivType, (int)1, (int)1);
        this.horizXY = GeneralizedImageOps.createSingleBand(secondDerivType, (int)1, (int)1);
        this.horizYY = GeneralizedImageOps.createSingleBand(secondDerivType, (int)1, (int)1);
    }

    public void setImageShape(int imageWidth, int imageHeight) {
        this.horizXX.reshape(imageWidth, imageHeight);
        this.horizYY.reshape(imageWidth, imageHeight);
        this.horizXY.reshape(imageWidth, imageHeight);
    }

    @Override
    public int getRadius() {
        return this.radius;
    }

    protected abstract float computeIntensity();

    @Override
    public int getIgnoreBorder() {
        return this.radius;
    }

    @Override
    public void process(D derivX, D derivY, ImageFloat32 intensity) {
        InputSanityCheck.checkSameShape(derivX, derivY, (ImageBase)intensity);
        this.setImageShape(derivX.getWidth(), derivX.getHeight());
        this.derivX = derivX;
        this.derivY = derivY;
        this.horizontal();
        this.vertical(intensity);
    }

    protected abstract void horizontal();

    protected abstract void vertical(ImageFloat32 var1);
}

