/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.describe;

import boofcv.alg.feature.describe.DescribePointSurf;
import boofcv.alg.feature.describe.SurfDescribeOps;
import boofcv.struct.feature.SurfFeature;
import boofcv.struct.feature.TupleDesc_F64;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.image.MultiSpectral;

public class DescribePointSurfMultiSpectral<II extends ImageSingleBand> {
    private DescribePointSurf<II> describe;
    private int descriptorLength;
    private II grayII;
    private MultiSpectral<II> ii;
    private TupleDesc_F64 bandDesc;
    private int numBands;

    public DescribePointSurfMultiSpectral(DescribePointSurf<II> describe, int numBands) {
        this.describe = describe;
        this.numBands = numBands;
        this.bandDesc = new TupleDesc_F64(describe.getDescriptionLength());
        this.descriptorLength = describe.getDescriptionLength() * numBands;
    }

    public SurfFeature createDescription() {
        return new SurfFeature(this.descriptorLength);
    }

    public int getDescriptorLength() {
        return this.descriptorLength;
    }

    public Class<SurfFeature> getDescriptionType() {
        return SurfFeature.class;
    }

    public void setImage(II grayII, MultiSpectral<II> integralImage) {
        this.grayII = grayII;
        this.ii = integralImage;
    }

    public void describe(double x, double y, double angle, double scale, SurfFeature desc) {
        int featureIndex = 0;
        for (int band = 0; band < this.ii.getNumBands(); ++band) {
            this.describe.setImage(this.ii.getBand(band));
            this.describe.describe(x, y, angle, scale, this.bandDesc);
            System.arraycopy(this.bandDesc.value, 0, desc.value, featureIndex, this.bandDesc.size());
            featureIndex += this.bandDesc.size();
        }
        SurfDescribeOps.normalizeFeatures(desc.value);
        this.describe.setImage(this.grayII);
        desc.laplacianPositive = this.describe.computeLaplaceSign((int)(x + 0.5), (int)(y + 0.5), scale);
    }

    public DescribePointSurf<II> getDescribe() {
        return this.describe;
    }

    public int getNumBands() {
        return this.numBands;
    }
}

