/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.flow;

import boofcv.abst.flow.DenseOpticalFlow;
import boofcv.alg.flow.HornSchunckPyramid;
import boofcv.struct.flow.ImageFlow;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.image.ImageType;

public class HornSchunckPyramid_to_DenseOpticalFlow<T extends ImageSingleBand>
implements DenseOpticalFlow<T> {
    HornSchunckPyramid<T> hornSchunck;
    Class<T> imageType;

    public HornSchunckPyramid_to_DenseOpticalFlow(HornSchunckPyramid<T> hornSchunck, Class<T> imageType) {
        this.hornSchunck = hornSchunck;
        this.imageType = imageType;
    }

    @Override
    public void process(T source, T destination, ImageFlow flow) {
        this.hornSchunck.process(source, destination);
        ImageFloat32 flowX = this.hornSchunck.getFlowX();
        ImageFloat32 flowY = this.hornSchunck.getFlowY();
        int index = 0;
        for (int y = 0; y < flow.height; ++y) {
            int x = 0;
            while (x < flow.width) {
                ImageFlow.D d = flow.unsafe_get(x, y);
                d.x = flowX.data[index];
                d.y = flowY.data[index];
                ++x;
                ++index;
            }
        }
    }

    @Override
    public ImageType<T> getInputType() {
        return ImageType.single(this.imageType);
    }
}

