/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.feature.detect.line;

import boofcv.abst.feature.detect.line.DetectLineSegment;
import boofcv.abst.filter.derivative.ImageGradient;
import boofcv.alg.feature.detect.edge.GGradientToEdgeFeatures;
import boofcv.alg.feature.detect.line.ConnectLinesGrid;
import boofcv.alg.feature.detect.line.GridRansacLineDetector;
import boofcv.alg.feature.detect.line.LineImageOps;
import boofcv.alg.filter.binary.GThresholdImageOps;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.struct.feature.MatrixOfList;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.image.ImageUInt8;
import georegression.struct.line.LineSegment2D_F32;
import java.util.List;

public class DetectLineSegmentsGridRansac<T extends ImageSingleBand, D extends ImageSingleBand>
implements DetectLineSegment<T> {
    GridRansacLineDetector<D> detectorGrid;
    ConnectLinesGrid connect;
    D derivX;
    D derivY;
    ImageFloat32 edgeIntensity;
    ImageUInt8 detected;
    ImageGradient<T, D> gradient;
    double edgeThreshold;

    public DetectLineSegmentsGridRansac(GridRansacLineDetector<D> detectorGrid, ConnectLinesGrid connect, ImageGradient<T, D> gradient, double edgeThreshold, Class<T> imageType, Class<D> derivType) {
        this.detectorGrid = detectorGrid;
        this.connect = connect;
        this.gradient = gradient;
        this.edgeThreshold = edgeThreshold;
        this.derivX = GeneralizedImageOps.createSingleBand(derivType, (int)1, (int)1);
        this.derivY = GeneralizedImageOps.createSingleBand(derivType, (int)1, (int)1);
        this.edgeIntensity = new ImageFloat32(1, 1);
        this.detected = new ImageUInt8(1, 1);
    }

    @Override
    public List<LineSegment2D_F32> detect(T input) {
        this.derivX.reshape(((ImageSingleBand)input).width, ((ImageSingleBand)input).height);
        this.derivY.reshape(((ImageSingleBand)input).width, ((ImageSingleBand)input).height);
        this.edgeIntensity.reshape(((ImageSingleBand)input).width, ((ImageSingleBand)input).height);
        this.detected.reshape(((ImageSingleBand)input).width, ((ImageSingleBand)input).height);
        this.gradient.process(input, this.derivX, this.derivY);
        GGradientToEdgeFeatures.intensityAbs(this.derivX, this.derivY, this.edgeIntensity);
        GThresholdImageOps.threshold((ImageSingleBand)this.edgeIntensity, (ImageUInt8)this.detected, (double)this.edgeThreshold, (boolean)false);
        this.detectorGrid.process(this.derivX, this.derivY, this.detected);
        MatrixOfList<LineSegment2D_F32> grid = this.detectorGrid.getFoundLines();
        if (this.connect != null) {
            this.connect.process(grid);
        }
        List<LineSegment2D_F32> found = grid.createSingleList();
        LineImageOps.mergeSimilar(found, 0.09424778f, 5.0f);
        return found;
    }
}

